/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ArrayMap<T, V>
extends AbstractMap<T, V>
implements Cloneable {
    private Map<T, Integer> map;
    private V[] array;

    public ArrayMap(Collection<T> init) {
        this.array = new Object[init.size()];
        this.map = new HashMap<T, Integer>(init.size() * 2);
        int index = 0;
        for (T t : init) {
            this.map.put(t, index++);
        }
    }

    public ArrayMap(T ... init) {
        this.array = new Object[init.length];
        this.map = new HashMap<T, Integer>(init.length * 2);
        int index = 0;
        for (T t : init) {
            this.map.put(t, index++);
        }
    }

    public int getIndexOf(T key) {
        Integer index = this.map.get(key);
        if (index != null) {
            return index;
        }
        throw new IllegalArgumentException(key + " unknown");
    }

    @Override
    public int size() {
        int count = 0;
        for (V ob : this.array) {
            if (ob == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        Integer index = this.map.get(key);
        if (index != null) {
            return this.array[index] != null;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.array) {
            if (!value.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Integer index = this.map.get(key);
        if (index != null) {
            return this.array[index];
        }
        return null;
    }

    public V get(int index) {
        return this.array[index];
    }

    public int capacity() {
        return this.array.length;
    }

    @Override
    public V put(T key, V value) {
        Integer index = this.map.get(key);
        if (index != null) {
            V v = this.array[index];
            this.array[index.intValue()] = value;
            return v;
        }
        return null;
    }

    @Override
    public V put(int index, V value) {
        V v = this.array[index];
        this.array[index] = value;
        return v;
    }

    @Override
    public V remove(Object key) {
        Integer index = this.map.get(key);
        if (index != null) {
            V v = this.array[index];
            this.array[index.intValue()] = null;
            return v;
        }
        return null;
    }

    public V remove(int index) {
        V v = this.array[index];
        this.array[index] = null;
        return v;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, null);
    }

    @Override
    public Set<Map.Entry<T, V>> entrySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toString() {
        return "ArrayMap{map=" + this.map + '}';
    }
}

