/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.vesalainen.parsers.sql.util.SingleSubSet;
import org.vesalainen.parsers.sql.util.SubSet;

public class FastSet<T>
extends AbstractSet<T> {
    private Map<T, Integer> map;
    private T[] array;
    private long[] bits;

    public FastSet(Collection<T> all) {
        this(all, false);
    }

    public FastSet(Collection<T> all, boolean fill) {
        this.map = new HashMap<T, Integer>();
        this.array = new Object[all.size()];
        this.bits = new long[this.array.length / 64 + 1];
        if (fill) {
            Arrays.fill(this.bits, -1L);
        }
        int index = 0;
        for (T t : all) {
            this.map.put(t, index);
            this.array[index++] = t;
        }
    }

    protected FastSet(FastSet<T> other) {
        this.map = other.map;
        this.array = other.array;
        this.bits = Arrays.copyOf(other.bits, other.bits.length);
    }

    public FastSet<T> copy() {
        return new FastSet<T>(this);
    }

    public FastSet<T> sub() {
        return new SubSet(this);
    }

    public SingleSubSet<T> singleSub() {
        return new SingleSubSet(this);
    }

    public void and(FastSet<T> other) {
        if (this.map != other.map) {
            throw new IllegalArgumentException("objects are not from the same base collection");
        }
        for (int ii = 0; ii < this.bits.length; ++ii) {
            int n = ii;
            this.bits[n] = this.bits[n] & other.bits[ii];
        }
    }

    public void or(FastSet<T> other) {
        if (this.map != other.map) {
            throw new IllegalArgumentException("objects are not from the same base collection");
        }
        for (int ii = 0; ii < this.bits.length; ++ii) {
            int n = ii;
            this.bits[n] = this.bits[n] | other.bits[ii];
        }
    }

    void clear(FastSet<T> other) {
        if (this.map != other.map) {
            throw new IllegalArgumentException("objects are not from the same base collection");
        }
        for (int ii = 0; ii < this.bits.length; ++ii) {
            int n = ii;
            this.bits[n] = this.bits[n] & (other.bits[ii] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    void setBit(int index) {
        if (index < 0 || index > this.array.length) {
            throw new IndexOutOfBoundsException(index + " negative or > " + this.array.length);
        }
        int n = index / 64;
        this.bits[n] = this.bits[n] | 1L << index % 64;
    }

    void resetBit(int index) {
        if (index < 0 || index > this.array.length) {
            throw new IndexOutOfBoundsException(index + " negative or > " + this.array.length);
        }
        int n = index / 64;
        this.bits[n] = this.bits[n] & (1L << index % 64 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    boolean isSet(int index) {
        if (index < 0 || index > this.array.length) {
            throw new IndexOutOfBoundsException(index + " negative or > " + this.array.length);
        }
        return (this.bits[index / 64] & 1L << index % 64) != 0L;
    }

    @Override
    public int size() {
        int count = 0;
        int c = 0;
        int max = this.array.length;
        for (int ii = 0; ii < this.bits.length && c < max; ++ii) {
            long b = this.bits[ii];
            if (b != 0L) {
                for (int jj = 0; jj < 64 && c < max; ++jj, ++c) {
                    if ((b & 1L << jj) == 0L) continue;
                    ++count;
                }
                continue;
            }
            c += 64;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        Integer index = this.map.get(o);
        if (index != null) {
            return this.isSet(index);
        }
        return false;
    }

    int getIndexOf(T e) {
        return this.map.get(e);
    }

    @Override
    public boolean add(T e) {
        Integer index = this.map.get(e);
        if (index != null) {
            boolean wasSet = this.isSet(index);
            this.setBit(index);
            return !wasSet;
        }
        throw new IllegalArgumentException(e + " was not in initial collection");
    }

    @Override
    public boolean remove(Object o) {
        Integer index = this.map.get(o);
        if (index != null) {
            boolean wasSet = this.isSet(index);
            this.resetBit(index);
            return wasSet;
        }
        throw new IllegalArgumentException(o + " was not in initial collection");
    }

    @Override
    public void clear() {
        Arrays.fill(this.bits, 0L);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    public static void main(String[] args) {
        try {
            HashSet<String> set = new HashSet<String>();
            for (int ii = 0; ii < 100; ++ii) {
                set.add("item" + ii);
            }
            FastSet fset = new FastSet(set, false);
            System.err.println(fset.size());
            for (int ii = 0; ii < 100; ++ii) {
                System.err.println(ii + ": " + fset.isSet(ii));
            }
            System.err.println(fset.size());
            System.err.println(fset.contains("item33"));
            FastSet fset2 = fset.copy();
            fset2.clear();
            fset2.add((T)"item24");
            fset.and(fset2);
            System.err.println(fset.size());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class Iter
    implements Iterator<T> {
        private int next;

        public Iter() {
            this.skipUnset();
        }

        private void skipUnset() {
            int length = FastSet.this.array.length;
            while (this.next < length && (FastSet.this.bits[this.next / 64] & 1L << this.next % 64) == 0L) {
                ++this.next;
            }
            if (this.next == length) {
                this.next = -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != -1;
        }

        @Override
        public T next() {
            Object t = FastSet.this.array[this.next++];
            this.skipUnset();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

