/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.sql.util;

import java.util.AbstractSet;
import java.util.Iterator;
import org.vesalainen.parsers.sql.util.FastSet;

public class SingleSubSet<T>
extends AbstractSet<T> {
    private FastSet<T> parent;
    private T item;
    private int index = -1;

    SingleSubSet(FastSet<T> parent) {
        this.parent = parent;
    }

    SingleSubSet(FastSet<T> parent, T item) {
        this.parent = parent;
        this.item = item;
        this.index = parent.getIndexOf(item);
    }

    @Override
    public int size() {
        if (this.item != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.item == null;
    }

    @Override
    public boolean contains(Object o) {
        return this.item != null && this.item.equals(o);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.item != null && !this.parent.isSet(this.index)) {
            this.item = null;
            this.index = -1;
        }
        return new Iter(this.item);
    }

    @Override
    public boolean add(T e) {
        if (this.item == null) {
            this.item = e;
            this.index = this.parent.getIndexOf(this.item);
            return true;
        }
        if (this.item.equals(e)) {
            return false;
        }
        throw new IllegalArgumentException("set capasity (1) exceeded");
    }

    @Override
    public boolean remove(Object o) {
        if (this.item != null && this.item.equals(o)) {
            this.item = null;
            this.parent.resetBit(this.index);
            this.index = -1;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.item != null) {
            this.parent.resetBit(this.index);
            this.item = null;
            this.index = -1;
        }
    }

    public class Iter
    implements Iterator<T> {
        T t;

        public Iter(T t) {
            this.t = t;
        }

        @Override
        public boolean hasNext() {
            return this.t != null;
        }

        @Override
        public T next() {
            Object r = this.t;
            this.t = null;
            return r;
        }

        @Override
        public void remove() {
            SingleSubSet.this.item = null;
        }
    }
}

