/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.xml;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import org.vesalainen.bcc.model.El;
import org.vesalainen.grammar.AnnotatedGrammar;
import org.vesalainen.parser.GenClassFactory;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.parser.util.InputReader;
import org.vesalainen.parsers.xml.DTDParserCompilerBase;
import org.vesalainen.parsers.xml.ExternalEntity;
import org.vesalainen.parsers.xml.QName;
import org.vesalainen.parsers.xml.XMLDTDBaseGrammar;
import org.vesalainen.parsers.xml.XMLLocator;
import org.vesalainen.parsers.xml.attr.AttDef;
import org.vesalainen.parsers.xml.attr.AttType;
import org.vesalainen.parsers.xml.attr.DefaultDecl;
import org.vesalainen.parsers.xml.attr.NSAttDef;
import org.vesalainen.parsers.xml.attr.NormalAttDef;
import org.vesalainen.parsers.xml.model.Attribute;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class DTDParser
extends XMLDTDBaseGrammar {
    public static final char ELPRF = '#';
    private Map<QName, String> elementMap = new HashMap<QName, String>();
    private Map<QName, List<AttDef>> AttributeMap = new HashMap<QName, List<AttDef>>();
    private Set<QName> childElements = new HashSet<QName>();
    private Set<AttDef> uniqueAttributes = new HashSet<AttDef>();
    private String publicId;
    private String officialSystemId;

    public static DTDParser createDTDParser() throws IOException {
        return (DTDParser)GenClassFactory.getGenInstance(DTDParser.class);
    }

    public void parse(String officialSystemId) throws IOException, SAXException, URISyntaxException {
        this.parse(null, officialSystemId, officialSystemId);
    }

    public void parse(String publicId, String officialSystemId) throws IOException, SAXException, URISyntaxException {
        this.parse(publicId, officialSystemId, officialSystemId);
    }

    public void parse(String publicId, String officialSystemId, String effectiveSystemId) throws IOException, SAXException, URISyntaxException {
        this.publicId = publicId;
        this.officialSystemId = officialSystemId;
        this.parse(new InputSource(effectiveSystemId));
    }

    private void parse(InputSource input) throws IOException, SAXException {
        try {
            this.input = input;
            this.inputReader = InputReader.getInstance((InputSource)input, (int)8192);
            this.locator = new XMLLocator(this.inputReader);
            this.parseExtSubset(this.inputReader);
            this.inputReader.close();
            this.createGrammar();
        }
        catch (IOException ex) {
            SAXParseException exception = new SAXParseException("syntax error", this.locator, ex);
            throw exception;
        }
    }

    private void createGrammar() throws IOException {
        if (this.elementMap.size() - this.childElements.size() != 1) {
            throw new IllegalArgumentException("not exactly one root element");
        }
        AnnotatedGrammar g = new AnnotatedGrammar(El.getTypeElement((CharSequence)DTDParserCompilerBase.class.getCanonicalName()));
        g.addRule("any", new String[0]);
        for (QName name : this.elementMap.keySet()) {
            String localPart = name.getLocalPart();
            String lhs = '#' + localPart;
            List<AttDef> attList = this.AttributeMap.get(name);
            String lhsAttrs = "";
            if (!attList.isEmpty()) {
                lhsAttrs = lhs + "Attrs";
                g.addRule(El.getMethod(DTDParser.class, (String)"attributeListStart", (Class[])new Class[0]), lhsAttrs, new String[0]);
                for (AttDef attr : attList) {
                    ExecutableElement reducer = El.getMethod(DTDParser.class, (String)"attributeListNext", (Class[])new Class[]{List.class, Attribute.class});
                    g.addRule(reducer, lhsAttrs, new String[]{lhsAttrs, attr.greateRhs()});
                }
            }
            if (!this.childElements.contains(name)) {
                g.addRule("element", new String[]{lhs});
            }
            String rhs = this.elementMap.get(name);
            g.addRule("any", new String[]{"any", lhs});
        }
    }

    private AttDef addAttDef(AttDef attDef) {
        if (!this.uniqueAttributes.contains(attDef)) {
            this.uniqueAttributes.add(attDef);
            return attDef;
        }
        for (AttDef a : this.uniqueAttributes) {
            if (!a.equals(attDef)) continue;
            return a;
        }
        assert (false);
        return null;
    }

    @Override
    @Rule(value={"'<!DOCTYPE'", "qName", "optExternalID"})
    protected void doctypedeclStart(QName name, String[] externalID) throws SAXException, IOException {
        String pubId = externalID[0];
        String sysId = externalID[1];
        InputSource embeddedInput = null;
        try {
            URI uri = new URI(this.input.getSystemId());
            String newSystemId = uri.resolve(sysId).toString();
            if (embeddedInput == null) {
                embeddedInput = new InputSource(newSystemId);
            }
            embeddedInput.setEncoding(this.input.getEncoding());
            embeddedInput.setPublicId(pubId);
            embeddedInput.setSystemId(newSystemId);
            this.parse(embeddedInput);
        }
        catch (Exception ex) {
            throw new SAXParseException("", this.locator, ex);
        }
    }

    @Override
    @Rule(value={"'>'"})
    protected void doctypedeclEnd() throws SAXException {
    }

    @Override
    @Rule(value={"externalID"})
    protected Object peDef(String[] externalID) throws SAXException, IOException {
        String pubId = externalID[0];
        String sysId = externalID[1];
        return new ExternalEntity(this.input, pubId, sysId, null);
    }

    @Rules(value={@Rule(value={"emptyElemTag"}), @Rule(value={"sTag", "content", "eTag"})})
    protected abstract void element();

    @Rule(value={"'<'", "qName", "attributes", "'>'"})
    protected void sTag(QName name) throws SAXException {
    }

    @Rules(value={@Rule, @Rule(value={"attributes", "attribute"})})
    protected abstract void attributes();

    @Rule(value={"qName", "eq", "attValue"})
    protected void attribute(QName name, String value) {
    }

    @Rule(value={"nsAttName", "eq", "attValue"})
    protected void attribute(String name, String uri) throws SAXException {
    }

    @Rule(value={"'<'", "'/'", "qName", "'>'"})
    protected void eTag(QName name) throws SAXException {
    }

    @Rules(value={@Rule, @Rule(value={"content", "element"}), @Rule(value={"content", "cdSect"})})
    protected abstract void content();

    @Rules(value={@Rule(value={"content", "reference"})})
    protected void content(String charData) {
    }

    @Rule(value={"'<'", "qName", "attributes", "'/'", "'>'"})
    protected void emptyElemTag(QName name) throws SAXException {
    }

    @Rule(value={"'<!ELEMENT'", "qName", "contentspec", "'>'"})
    protected void elementdecl(QName name, String content) {
        String old = this.elementMap.put(name, content);
        if (old != null) {
            throw new IllegalArgumentException("element " + name + " defined twice");
        }
    }

    @Rule(value={"'EMPTY'"})
    protected String emptyContentspec() {
        return null;
    }

    @Rule(value={"'ANY'"})
    protected String anyContentspec() {
        return "any";
    }

    @Rules(value={@Rule(value={"emptyContentspec"}), @Rule(value={"anyContentspec"}), @Rule(value={"mixed"}), @Rule(value={"children"})})
    protected abstract String contentspec(String var1);

    @Terminal(expression="[\\+\\*\\?]")
    protected abstract char quantifierChar(char var1);

    @Rule
    protected char quantifier() {
        return '\u0000';
    }

    @Rule(value={"quantifierChar"})
    protected char quantifier(char cc) {
        return cc;
    }

    @Rules(value={@Rule(value={"choice", "quantifier"}), @Rule(value={"seq", "quantifier"})})
    protected String children(String content, char quantifier) {
        if (quantifier != '\u0000') {
            return content + quantifier;
        }
        return content;
    }

    @Rule(value={"qName", "quantifier"})
    protected String cp(QName name, char quantifier) {
        this.childElements.add(name);
        if (quantifier != '\u0000') {
            return '#' + name.getLocalPart() + quantifier;
        }
        return '#' + name.getLocalPart();
    }

    @Rules(value={@Rule(value={"choice", "quantifier"}), @Rule(value={"seq", "quantifier"})})
    protected String cp(String content, char quantifier) {
        if (quantifier != '\u0000') {
            return content + quantifier;
        }
        return content;
    }

    @Rule(value={"'\\('", "choices", "'\\)'"})
    protected String choice(String choices) {
        return '(' + choices + ')';
    }

    @Rules(value={@Rule(value={"cp", "'\\|'", "cp"}), @Rule(value={"choices", "'\\|'", "cp"})})
    protected String choices(String cp1, String cp2) {
        return cp1 + '|' + cp2;
    }

    @Rule(value={"'\\('", "seqs", "'\\)'"})
    protected String seq(String seqs) {
        return '(' + seqs + ')';
    }

    @Rule(value={"cp"})
    protected String seqs(String cp) {
        return cp;
    }

    @Rule(value={"seqs", "'\\,'", "cp"})
    protected String seqs(String seqs, String cp) {
        return seqs + ' ' + cp;
    }

    @Rule(value={"'\\('", "'#PCDATA'", "'\\)'"})
    protected String mixed() {
        return "";
    }

    @Rule(value={"'\\('", "'#PCDATA'", "mixedNames", "'\\)'", "'\\*'"})
    protected String mixed(String qNames) {
        return '(' + qNames + ')';
    }

    @Rule
    protected String mixedNames() {
        return "";
    }

    @Rule(value={"mixedNames", "'\\|'", "qName"})
    protected String mixedNames(String qNames, QName name) {
        return qNames + '|' + name.toString();
    }

    @Rule(value={"'<!ATTLIST'", "qName", "attDefs", "'>'"})
    protected void attlistDecl(QName name, List<AttDef> attDefs) {
        String element = this.elementMap.get(name);
        if (element == null) {
            throw new UnsupportedOperationException("attlistDecl without elementdecl not supported. element=" + name);
        }
        if (this.AttributeMap.containsKey(name)) {
            throw new UnsupportedOperationException("attlistDecl merge not supported. element=" + name);
        }
        this.AttributeMap.put(name, attDefs);
    }

    @Rule
    protected List<AttDef> attDefs() {
        return new ArrayList<AttDef>();
    }

    @Rule(value={"attDefs", "attDef"})
    protected List<AttDef> attDefs(List<AttDef> attDefs, AttDef attDef) {
        if (attDef != null) {
            attDefs.add(attDef);
        }
        return attDefs;
    }

    @Rule(value={"qName", "attType", "defaultDecl"})
    protected AttDef attDef(QName name, AttType attType, DefaultDecl defaultDecl) {
        return this.addAttDef(new NormalAttDef(name, attType, defaultDecl));
    }

    @Rule(value={"nsAttName", "attType", "defaultDecl"})
    protected AttDef attDef(String name, AttType attType, DefaultDecl defaultDecl) {
        if (!name.isEmpty()) {
            return this.addAttDef(new NSAttDef(name, attType, defaultDecl));
        }
        return null;
    }

    @Rules(value={@Rule(value={"stringType"}), @Rule(value={"tokenizedType"}), @Rule(value={"enumeratedType"})})
    protected abstract AttType attType(AttType var1);

    @Rule(value={"'CDATA'"})
    protected AttType stringType() {
        return AttType.PCDATA;
    }

    @Rules(value={@Rule(value={"tokenizedTypeId"}), @Rule(value={"tokenizedTypeIdRef"}), @Rule(value={"tokenizedTypeIdRefs"}), @Rule(value={"tokenizedTypeEntity"}), @Rule(value={"tokenizedTypeEntities"}), @Rule(value={"tokenizedTypeNmToken"}), @Rule(value={"tokenizedTypeNmTokens"})})
    protected abstract AttType tokenizedType(AttType var1);

    @Rule(value={"'ID'"})
    protected AttType tokenizedTypeId() {
        return AttType.ID;
    }

    @Rule(value={"'ID'", "'REF'"})
    protected AttType tokenizedTypeIdRef() {
        return AttType.IDREF;
    }

    @Rule(value={"'ID'", "'REF'", "'S'"})
    protected AttType tokenizedTypeIdRefs() {
        return AttType.IDREFS;
    }

    @Rule(value={"'ENTITY'"})
    protected AttType tokenizedTypeEntity() {
        return AttType.ENTITY;
    }

    @Rule(value={"'ENTITIES'"})
    protected AttType tokenizedTypeEntities() {
        return AttType.ENTITIES;
    }

    @Rule(value={"'NMTOKEN'"})
    protected AttType tokenizedTypeNmToken() {
        return AttType.NMTOKEN;
    }

    @Rule(value={"'NMTOKEN'", "'S'"})
    protected AttType tokenizedTypeNmTokens() {
        return AttType.NMTOKENS;
    }

    @Rules(value={@Rule(value={"notationType"}), @Rule(value={"enumeration"})})
    protected abstract AttType enumeratedType(AttType var1);

    @Rule(value={"'NOTATION'", "'\\('", "notationTypeNames", "'\\)'"})
    protected AttType notationType(List<String> names) {
        return new AttType.NotationType(names);
    }

    @Rule(value={"name"})
    protected List<String> notationTypeNames(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        return list;
    }

    @Rule(value={"notationTypeNames", "'\\|'", "name"})
    protected List<String> notationTypeNames(List<String> names, String name) {
        names.add(name);
        return names;
    }

    @Rule(value={"'\\('", "enumerationNMTokens", "'\\)'"})
    protected AttType enumeration(List<String> names) {
        return new AttType.Enumeration(names);
    }

    @Rule(value={"nmtoken"})
    protected List<String> enumerationNMTokens(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        return list;
    }

    @Rule(value={"enumerationNMTokens", "'\\|'", "nmtoken"})
    protected List<String> enumerationNMTokens(List<String> names, String name) {
        names.add(name);
        return names;
    }

    @Rules(value={@Rule(value={"defaultDeclRequired"}), @Rule(value={"defaultDeclImplied"}), @Rule(value={"defaultDeclFixed"})})
    protected abstract DefaultDecl defaultDecl(DefaultDecl var1);

    @Rule(value={"'#REQUIRED'"})
    protected DefaultDecl defaultDeclRequired() {
        return DefaultDecl.REQUIRED;
    }

    @Rule(value={"'#IMPLIED'"})
    protected DefaultDecl defaultDeclImplied() {
        return DefaultDecl.IMPLIED;
    }

    @Rule(value={"'#FIXED'", "attValue"})
    protected DefaultDecl defaultDeclFixed(String value) {
        return new DefaultDecl.DefaultValue(value, true);
    }

    @Rule(value={"attValue"})
    protected DefaultDecl defaultDecl(String value) {
        return new DefaultDecl.DefaultValue(value, false);
    }

    public static List<Attribute> attributeListStart() {
        return new ArrayList<Attribute>();
    }

    public static List<Attribute> attributeListNext(List<Attribute> list, Attribute t) {
        list.add(t);
        return list;
    }

    public static void main(String[] args) {
        try {
            DTDParser parser = DTDParser.createDTDParser();
            File f = new File("c:\\temp\\XMLSchema.dtd");
            parser.parse("-//W3C//DTD XMLSCHEMA 200102//EN", "http://www.w3.org/2001/XMLSchema.dtd", f.toURI().toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

