/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.xml;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import org.vesalainen.parsers.xml.InputSourceHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class ExternalEntity {
    private InputSource base;
    private String publicId;
    private String systemId;
    private EntityResolver entityResolver;

    ExternalEntity(InputSource base, String pubId, String sysId, EntityResolver entityResolver) {
        this.base = base;
        this.publicId = pubId;
        this.systemId = sysId;
        this.entityResolver = entityResolver;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public PushbackReader createReader() throws IOException {
        try {
            InputSource embeddedInput = null;
            if (this.entityResolver != null) {
                if (this.entityResolver instanceof EntityResolver2) {
                    EntityResolver2 er2 = (EntityResolver2)this.entityResolver;
                    embeddedInput = er2.resolveEntity(null, this.publicId, this.base.getSystemId(), this.systemId);
                } else {
                    embeddedInput = this.entityResolver.resolveEntity(this.publicId, this.systemId);
                }
            }
            URI uri = new URI(this.base.getSystemId());
            String newSystemId = uri.resolve(this.systemId).toString();
            if (embeddedInput == null) {
                embeddedInput = new InputSource(newSystemId);
            }
            embeddedInput.setEncoding(this.base.getEncoding());
            embeddedInput.setPublicId(this.publicId);
            embeddedInput.setSystemId(newSystemId);
            Reader r = InputSourceHelper.getReader(embeddedInput);
            return new PushbackReader(r);
        }
        catch (URISyntaxException | SAXException ex) {
            throw new IOException(ex);
        }
    }
}

