/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class InputStreamDecoderReader
extends Reader {
    private static final int BUFFERSIZE = 8192;
    private InputStream in;
    private CharsetDecoder decoder;
    private byte[] buffer;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private String charset;

    public InputStreamDecoderReader(InputStream in, String charset) {
        this.in = in;
        Charset cs = Charset.forName(charset);
        this.decoder = cs.newDecoder();
        this.buffer = new byte[8192];
        this.byteBuffer = ByteBuffer.wrap(this.buffer);
        this.byteBuffer.flip();
        this.charBuffer = CharBuffer.allocate(1);
        this.charBuffer.flip();
    }

    public void setEncoding(String charset) {
        if (this.charset == null) {
            this.charset = charset;
            Charset cs = Charset.forName(charset);
            this.decoder = cs.newDecoder();
            assert (!this.charBuffer.hasRemaining());
            this.charBuffer = CharBuffer.allocate(8192);
            this.charBuffer.flip();
        } else {
            Charset cs = Charset.forName(charset);
            if (!this.charset.equals(charset) && !cs.aliases().contains(charset)) {
                throw new IllegalArgumentException("attempt to replace " + this.charset + " with " + charset);
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.charBuffer.hasRemaining()) {
            return this.charBuffer.get();
        }
        if (!this.byteBuffer.hasRemaining()) {
            int rc = this.in.read(this.buffer);
            if (rc == -1) {
                return -1;
            }
            this.byteBuffer.position(0);
            this.byteBuffer.limit(rc);
        }
        this.charBuffer.clear();
        CoderResult res = this.decoder.decode(this.byteBuffer, this.charBuffer, false);
        while (res.isUnderflow()) {
            assert (!this.byteBuffer.hasRemaining());
            int rc = this.in.read(this.buffer);
            this.byteBuffer.position(0);
            if (rc != -1) {
                this.byteBuffer.limit(rc);
                res = this.decoder.decode(this.byteBuffer, this.charBuffer, false);
                continue;
            }
            this.byteBuffer.limit(0);
            this.decoder.decode(this.byteBuffer, this.charBuffer, true);
            this.decoder.flush(this.charBuffer);
            break;
        }
        if (res.isError()) {
            throw new IOException(res.toString());
        }
        this.charBuffer.flip();
        if (!this.charBuffer.hasRemaining()) {
            return -1;
        }
        return this.charBuffer.get();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("C:\\Users\\tkv\\Documents\\NetBeansProjects\\KML\\src\\fi\\sw_nets\\kml\\Placemark.xml");
            InputStreamDecoderReader isdr = new InputStreamDecoderReader(fis, "US-ASCII");
            int cc = isdr.read();
            while (cc != -1) {
                System.err.print((char)cc);
                cc = isdr.read();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

