/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.xml;

import org.vesalainen.parsers.xml.SAX2Constants;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXFeatures
implements SAX2Constants,
Cloneable {
    private boolean isNamespaceAware = false;
    private boolean supportNameSpacePrefixes = false;
    private boolean isValidating = false;
    private boolean isXIncludeAware = false;
    private boolean isStandalone;

    public SAXFeatures clone() throws CloneNotSupportedException {
        return (SAXFeatures)super.clone();
    }

    public void setNamespaceAware(boolean awareness) throws SAXException {
        this.isNamespaceAware = awareness;
    }

    public void setValidating(boolean validating) {
        this.isValidating = validating;
    }

    public void setXIncludeAware(boolean state) {
        this.isXIncludeAware = state;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.isNamespaceAware;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.supportNameSpacePrefixes;
        }
        if ("http://xml.org/sax/features/validation".equals(name)) {
            return this.isValidating;
        }
        if ("http://xml.org/sax/features/use-attributes2".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/use-entity-resolver2".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/use-locator2".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/xml-1.1".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/is-standalone".equals(name)) {
            return this.isStandalone;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.isNamespaceAware = value;
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.supportNameSpacePrefixes = value;
            return;
        }
        if ("http://xml.org/sax/features/validation".equals(name)) {
            this.isValidating = value;
            return;
        }
        if ("http://xml.org/sax/features/use-entity-resolver2".equals(name)) {
            throw new SAXNotSupportedException(name);
        }
        if ("http://xml.org/sax/features/use-attributes2".equals(name)) {
            throw new SAXNotSupportedException(name);
        }
        if ("http://xml.org/sax/features/use-locator2".equals(name)) {
            throw new SAXNotSupportedException(name);
        }
        if ("http://xml.org/sax/features/xml-1.1".equals(name)) {
            throw new SAXNotSupportedException(name);
        }
        if ("http://xml.org/sax/features/is-standalone".equals(name)) {
            throw new SAXNotSupportedException(name);
        }
        throw new SAXNotRecognizedException(name);
    }
}

