/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.xml;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.vesalainen.parsers.xml.SAXFeatures;
import org.vesalainen.parsers.xml.SAXParserImpl;
import org.vesalainen.parsers.xml.XMLDocumentParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    private SAXFeatures features = new SAXFeatures();

    @Override
    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        try {
            XMLDocumentParser reader = XMLDocumentParser.getInstance();
            SAXFeatures f = this.features.clone();
            f.setNamespaceAware(this.isNamespaceAware());
            f.setValidating(this.isValidating());
            reader.setFeatures(f.clone());
            return new SAXParserImpl(reader);
        }
        catch (IOException | CloneNotSupportedException ex) {
            throw new ParserConfigurationException(ex.getMessage());
        }
    }

    @Override
    public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.features.setFeature(name, value);
    }

    @Override
    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.features.getFeature(name);
    }
}

