/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.xml;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.parser.util.InputReader;
import org.vesalainen.parsers.xml.ExternalEntity;
import org.vesalainen.parsers.xml.QName;
import org.vesalainen.parsers.xml.XMLLocator;
import org.vesalainen.regex.Regex;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLBaseGrammar {
    public static final int BUFFERSIZE = 8192;
    protected static final String Char = "\\x01-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}";
    protected static final String RestrictedChar = "\\x1-\\x8\\xB-\\xC\\xE-\\x1F\\x7F-\\x84\\x86-\\x9F";
    protected static final String S = "\\x20\\x09\\x0A";
    protected static final String NameStartChar = ":A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}";
    protected static final String NameChar = ":A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040";
    protected static final String PubidChar = "\\x20\\x0D\\x0Aa-zA-Z0-9\\-'\\(\\)\\+\\,\\./:=\\?;!\\*#@\\$_%";
    protected static final String PubidCharMinusApostrophe = "\\x20\\x0D\\x0Aa-zA-Z0-9\\-\\(\\)\\+\\,\\./:=\\?;!\\*#@\\$_%";
    protected static final String NCNameStartChar = "A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}";
    protected static final String NCNameChar = "A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040";
    protected InputReader inputReader;
    protected InputSource input;
    protected XMLLocator locator;
    protected Map<String, Object> generalReferences = new HashMap<String, Object>();
    protected Map<String, Object> parameterReferences = new HashMap<String, Object>();
    protected boolean external;
    private static char[] eolChar = new char[]{'\n'};

    public XMLBaseGrammar() {
        this.generalReferences.put("lt", "&<");
        this.generalReferences.put("gt", ">");
        this.generalReferences.put("amp", "&&");
        this.generalReferences.put("apos", "'");
        this.generalReferences.put("quot", "\"");
    }

    @ParseMethod(start="extSubset", whiteSpace={"eol", "s", "pi", "comment", "peReference"})
    protected abstract void parseExtSubset(InputReader var1);

    @ParseMethod(start="document", whiteSpace={"eol", "s"})
    protected abstract void parseDocument(InputReader var1);

    @ParseMethod(start="quotAttValueSub", eof="singleQuot")
    protected abstract String parseQuotAttValue(InputReader var1);

    @ParseMethod(start="aposAttValueSub", eof="singleApostrophe")
    protected abstract String parseAposAttValue(InputReader var1);

    @ParseMethod(start="quotEntityValueSub", eof="singleQuot", whiteSpace={"peReference"})
    protected abstract String parseQuotEntityValue(InputReader var1);

    @ParseMethod(start="aposEntityValueSub", eof="singleApostrophe", whiteSpace={"peReference"})
    protected abstract String parseAposEntityValue(InputReader var1);

    @Rule(value={"prolog", "element", "misc*"})
    protected abstract void document() throws SAXException;

    @Terminal(expression="[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*")
    protected abstract String name(String var1);

    @Rule(value={"name"})
    protected List<String> names(String name) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(name);
        return res;
    }

    @Rule(value={"names", "' '", "name"})
    protected List<String> names(List<String> names, String name) {
        names.add(name);
        return names;
    }

    @Terminal(expression="[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]+")
    protected abstract String nmtoken(String var1);

    @Rule(value={"nmtoken"})
    protected List<String> nmtokens(String nmtoken) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(nmtoken);
        return res;
    }

    @Rule(value={"nmtokens", "' '", "nmtoken"})
    protected List<String> nmtokens(List<String> nmtokens, String nmtoken) {
        nmtokens.add(nmtoken);
        return nmtokens;
    }

    @Rule(value={"'\"'"})
    protected String quotEntityValueStart(@ParserContext(value="$inputReader") InputReader reader) throws IOException {
        String s = this.parseQuotEntityValue(reader);
        return s;
    }

    @Rule(value={"`'\u00b4"})
    protected String aposEntityValueStart(@ParserContext(value="$inputReader") InputReader reader) throws IOException {
        return this.parseAposEntityValue(reader);
    }

    @Rules(value={@Rule(value={"quotEntityValueStart"}), @Rule(value={"aposEntityValueStart"})})
    protected String entityValue(String str) throws IOException {
        return str;
    }

    @Rule(value={"quotEntityValue"})
    protected String quotEntityValueSub(String str) {
        return str;
    }

    @Rule(value={"aposEntityValue"})
    protected String aposEntityValueSub(String str) {
        return str;
    }

    @Rule
    protected String quotEntityValue() {
        return "";
    }

    @Rule
    protected String aposEntityValue() {
        return "";
    }

    @Rules(value={@Rule(value={"quotEntityValue", "notQuotValue"}), @Rule(value={"quotEntityValue", "reference"})})
    protected String quotEntityValue(String str, String value) {
        return str + value;
    }

    @Rules(value={@Rule(value={"aposEntityValue", "notAposValue"}), @Rule(value={"aposEntityValue", "reference"})})
    protected String aposEntityValue(String str, String value) {
        return str + value;
    }

    @Rule(value={"'\"'"})
    protected String quotAttValueStart(@ParserContext(value="$inputReader") InputReader reader) throws IOException {
        return this.parseQuotAttValue(reader);
    }

    @Rule(value={"`'\u00b4"})
    protected String aposAttValueStart(@ParserContext(value="$inputReader") InputReader reader) throws IOException {
        return this.parseAposAttValue(reader);
    }

    @Rules(value={@Rule(value={"quotAttValueStart"}), @Rule(value={"aposAttValueStart"})})
    protected String attValue(String str) throws IOException {
        return str;
    }

    @Terminal(expression="\"")
    protected abstract void singleQuot();

    @Terminal(expression="'")
    protected abstract void singleApostrophe();

    @Rule(value={"quotAttValue"})
    protected String quotAttValueSub(String str) {
        return str;
    }

    @Rule(value={"aposAttValue"})
    protected String aposAttValueSub(String str) {
        return str;
    }

    @Rule
    protected String quotAttValue() {
        return "";
    }

    @Rule
    protected String aposAttValue() {
        return "";
    }

    @Rules(value={@Rule(value={"quotAttValue", "notQuotValue"}), @Rule(value={"quotAttValue", "reference"})})
    protected String quotAttValue(String str, String value) {
        return str + value;
    }

    @Rules(value={@Rule(value={"aposAttValue", "notAposValue"}), @Rule(value={"aposAttValue", "reference"})})
    protected String aposAttValue(String str, String value) {
        return str + value;
    }

    @Rules(value={@Rule(value={"'\"\"'"}), @Rule(value={"`'\u00b4'"})})
    protected String emptyQuote() {
        return "";
    }

    @Terminal(expression="\"[^\"]*\"|'[^']*'")
    protected String systemLiteral(String literal) {
        return literal.substring(1, literal.length() - 1);
    }

    @Rules(value={@Rule(value={"pubidLiteralWithApostrophe"}), @Rule(value={"pubidLiteralMinusApostrophe"})})
    protected abstract String pubidLiteral(String var1);

    @Terminal(expression="[^%\\&\"]+")
    protected abstract String notQuotValue(String var1);

    @Terminal(expression="[^%\\&']+")
    protected abstract String notAposValue(String var1);

    @Terminal(expression="[^\"]+")
    protected abstract String notQuot(String var1);

    @Terminal(expression="[^']+")
    protected abstract String notApos(String var1);

    @Terminal(expression="\"[\\x20\\x0D\\x0Aa-zA-Z0-9\\-'\\(\\)\\+\\,\\./:=\\?;!\\*#@\\$_%]*\"")
    protected String pubidLiteralWithApostrophe(String value) {
        return value.substring(1, value.length() - 1);
    }

    @Terminal(expression="'[\\x20\\x0D\\x0Aa-zA-Z0-9\\-\\(\\)\\+\\,\\./:=\\?;!\\*#@\\$_%]*'")
    protected String pubidLiteralMinusApostrophe(String value) {
        return value.substring(1, value.length() - 1);
    }

    @Terminal(expression="[^<\\&\\x0d\\x85\\u2028]+")
    protected void charData(InputReader reader) throws SAXException {
    }

    @Terminal(expression="<!\\-\\-[\\x01-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}]*\\-\\->", options={Regex.Option.FIXED_ENDER})
    protected void comment(InputReader reader) throws SAXException {
    }

    @Terminal(expression="[\\x20\\x09\\x0A]+")
    protected abstract void s();

    @Terminal(expression="<\\?[\\x01-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}]*\\?>", options={Regex.Option.FIXED_ENDER})
    protected void pi() {
    }

    @Terminal(expression="<!\\[CDATA\\[[\\x01-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}]*\\]\\]>", options={Regex.Option.FIXED_ENDER})
    protected void cdSect(InputReader r) throws SAXException {
        this.charData(r);
    }

    @Terminal(expression="[0-9]+")
    protected abstract int digit(int var1);

    @Terminal(expression="[0-9a-fA-F]+")
    protected int hex(String value) {
        return Integer.parseInt(value, 16);
    }

    @Rule(value={"byteOrderMark?", "xmlPrefix", "versionInfo", "encodingDecl?", "sdDecl?", "'\\?>'"})
    protected abstract void xmlDecl();

    @Rules(value={@Rule(value={"utf32BE"}), @Rule(value={"utf32LE"}), @Rule(value={"utf16BE"}), @Rule(value={"utf16LE"}), @Rule(value={"utf8"})})
    protected abstract void byteOrderMark();

    @Rule(value={"'\\x00\\x00\\xFE\\xFF'"})
    protected void utf32BE() throws SAXParseException {
        try {
            this.setEncoding("UTF-32BE");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Rule(value={"'\\xFF\\xFE\\x00\\x00'"})
    protected void utf32LE() throws SAXParseException {
        try {
            this.setEncoding("UTF-32LE");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Rule(value={"'\\xFE\\xFF'"})
    protected void utf16BE() throws SAXParseException {
        try {
            this.setEncoding("UTF-16BE");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Rule(value={"'\\xFF\\xFE'"})
    protected void utf16LE() throws SAXParseException {
        try {
            this.setEncoding("UTF-16LE");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Rule(value={"'\\xEF\\xBB\\xBF'"})
    protected void utf8() throws SAXParseException {
        try {
            this.input.setEncoding("UTF-8");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Rules(value={@Rule(value={"utf32BEPrefix"}), @Rule(value={"utf32LEPrefix"}), @Rule(value={"utf16BEPrefix"}), @Rule(value={"utf16LEPrefix"}), @Rule(value={"utf8Prefix"})})
    protected abstract void xmlPrefix();

    @Terminal(expression="\\x00\\x00\\x00<\\x00\\x00\\x00\\?\\x00\\x00\\x00x\\x00\\x00\\x00m\\x00\\x00\\x00l", options={Regex.Option.ACCEPT_IMMEDIATELY})
    protected void utf32BEPrefix() throws SAXParseException {
        try {
            this.setEncoding("UTF-32BE");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Terminal(expression="<\\x00\\x00\\x00\\?\\x00\\x00\\x00x\\x00\\x00\\x00m\\x00\\x00\\x00l\\x00\\x00\\x00", options={Regex.Option.ACCEPT_IMMEDIATELY})
    protected void utf32LEPrefix() throws SAXParseException {
        try {
            this.setEncoding("UTF-32LE");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Terminal(expression="\\x00<\\x00\\?\\x00x\\x00m\\x00l", options={Regex.Option.ACCEPT_IMMEDIATELY})
    protected void utf16BEPrefix() throws SAXParseException {
        try {
            this.setEncoding("UTF-16BE");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Terminal(expression="<\\x00\\?\\x00x\\x00m\\x00l\\x00", options={Regex.Option.ACCEPT_IMMEDIATELY})
    protected void utf16LEPrefix() throws SAXParseException {
        try {
            this.setEncoding("UTF-16LE");
        }
        catch (IllegalArgumentException ex) {
            throw new SAXParseException("unsupported encoding", this.locator, ex);
        }
    }

    @Terminal(expression="<\\?xml", options={Regex.Option.ACCEPT_IMMEDIATELY})
    protected abstract void utf8Prefix();

    @Rule(value={"'version'", "eq", "versionNum"})
    protected void versionInfo(String version) throws SAXParseException {
        if (!"1.0".equals(version) && !"1.1".equals(version)) {
            throw new SAXParseException("unsupported xml version " + version, this.locator);
        }
        this.locator.setXmlVersion(version);
    }

    @Rule(value={"version"})
    protected abstract String versionNum(String var1);

    @Terminal(expression="\"[0-9]\\.[0-9]\"|'[0-9]\\.[0-9]'")
    protected String version(String version) {
        return version.substring(1, version.length() - 1);
    }

    @Rule(value={"'='"})
    protected abstract void eq();

    @Rule(value={"(comment|pi)"})
    protected abstract void misc();

    @Rules(value={@Rule(value={"'standalone'", "eq", "yesNo", "`'\u00b4"}), @Rule(value={"'standalone'", "eq", "yesNo", "'\"'"})})
    protected void sdDecl(boolean opt) {
    }

    @Terminal(expression="(yes)|(no)")
    protected boolean yesNo(String opt) {
        return "yes".equals(opt);
    }

    @Rules(value={@Rule(value={"charRefDecimal"}), @Rule(value={"charRefHex"})})
    protected String charRef(int value) {
        return Character.toString((char)value);
    }

    @Terminal(expression="\\&#[0-9]+;")
    protected int charRefDecimal(String s) {
        return Integer.parseInt(s.substring(2, s.length() - 1));
    }

    @Terminal(expression="\\&#x[0-9a-fA-F]+;")
    protected int charRefHex(String s) {
        return Integer.parseInt(s.substring(3, s.length() - 1), 16);
    }

    @Rules(value={@Rule(value={"entityRef"}), @Rule(value={"charRef"})})
    protected abstract String reference(String var1);

    @Terminal(expression="\\&[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*;")
    protected String entityRef(String name) throws SAXParseException {
        Object res = this.generalReferences.get(name.substring(1, name.length() - 1));
        if (res == null) {
            throw new SAXParseException("EntityRef " + name + " not defined", this.locator);
        }
        return res.toString();
    }

    @Terminal(expression="%[:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][:A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*;")
    protected String peReference(String name, @ParserContext(value="$inputReader") InputReader reader) throws SAXParseException, IOException {
        Object res = this.parameterReferences.get(name.substring(1, name.length() - 1));
        if (res == null) {
            throw new SAXParseException("PEReference " + name + " not defined", this.locator);
        }
        if (res instanceof ExternalEntity) {
            ExternalEntity ee = (ExternalEntity)res;
            reader.include(ee.createReader(), ee.getSystemId());
            return "";
        }
        return res.toString();
    }

    @Rules(value={@Rule(value={"geDecl"}), @Rule(value={"peDecl"})})
    protected abstract void entityDecl();

    @Rule(value={"'<!ENTITY'", "name", "entityDef", "'>'"})
    protected void geDecl(String name) {
    }

    @Rule(value={"'<!ENTITY'", "'%'", "name", "peDef", "'>'"})
    protected void peDecl(String name, Object value) throws SAXException {
        Object old = this.parameterReferences.put(name, value);
    }

    @Rule(value={"entityValue"})
    protected void entityDef(String entityValue) {
    }

    @Rule(value={"externalID", "nDataDecl?"})
    protected void entityDef(String[] externalID) {
    }

    @Rule(value={"entityValue"})
    protected Object peDef(String entityValue) {
        return entityValue;
    }

    @Rule(value={"externalID"})
    protected Object peDef(String[] externalID) throws SAXException, IOException {
        return null;
    }

    @Rule
    protected String[] optExternalID() {
        return new String[]{null, null};
    }

    @Rule(value={"externalID"})
    protected String[] optExternalID(String[] externalID) {
        return externalID;
    }

    @Rule(value={"'SYSTEM'", "systemLiteral"})
    protected String[] externalID(String systemLiteral) {
        return new String[]{null, systemLiteral};
    }

    @Rule(value={"'PUBLIC'", "pubidLiteral", "systemLiteral"})
    protected String[] externalID(String pubidLiteral, String systemLiteral) {
        return new String[]{pubidLiteral, systemLiteral};
    }

    @Rule(value={"'NDATA'", "name"})
    protected void nDataDecl(String name) {
    }

    @Rules(value={@Rule(value={"'encoding'", "eq", "'\"'", "encName", "'\"'"}), @Rule(value={"'encoding'", "eq", "`'\u00b4", "encName", "`'\u00b4"})})
    protected void encodingDecl(String charset) {
        this.setEncoding(charset);
    }

    @Terminal(expression="[A-Za-z][A-Za-z0-9\\._\\-]*")
    protected abstract String encName(String var1);

    @Rule(value={"'<!NOTATION'", "name", "externalID", "'>'"})
    protected void notationDecl(String name, String[] externalID) throws SAXException {
    }

    @Rule(value={"'<!NOTATION'", "name", "publicID", "'>'"})
    protected void notationDecl(String name, String publicID) throws SAXException {
    }

    @Rule(value={"'PUBLIC'", "pubidLiteral"})
    protected abstract String publicID(String var1);

    @Terminal(expression="xmlns(:[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*)?", priority=1)
    protected String nsAttName(String s) throws IOException {
        int idx = s.indexOf(58);
        if (idx == -1) {
            return "";
        }
        return s.substring(idx + 1);
    }

    @Terminal(expression="<[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*(:[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*)?")
    protected QName sTagName(String s) throws IOException {
        return new QName(s.substring(1));
    }

    @Terminal(expression="</[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*(:[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*)?[\\x20\\x09\\x0A]*>")
    protected QName eTagName(String s) throws IOException {
        return new QName(s.substring(2));
    }

    @Terminal(expression="[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*(:[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*)?")
    protected QName qName(String s) throws IOException {
        return new QName(s);
    }

    @Terminal(expression="\\x0d\\x0a|\\x0d\\x85|\\x85|\\x0d|\\u2028")
    protected char[] eol() throws IOException {
        return eolChar;
    }

    public String getEncoding() {
        return this.input.getEncoding();
    }

    private void setEncoding(String charset) {
        this.input.setEncoding(charset);
        this.inputReader.setEncoding(charset);
    }

    public String getPublicId() {
        return this.input.getPublicId();
    }

    public void setPublicId(String publicId) {
        this.input.setPublicId(publicId);
    }

    public String getSystemId() {
        return this.input.getSystemId();
    }

    public void setSystemId(String systemId) throws URISyntaxException {
        this.input.setSystemId(systemId);
    }

    public String getXmlVersion() {
        return this.locator.getXMLVersion();
    }

    public void setXmlVersion(String xmlVersion) {
        this.locator.setXmlVersion(xmlVersion);
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public static enum Context {
        COMMENT,
        CONTENT,
        ATTR_VALUE,
        AS_ATTR_VALUE,
        ENTITY_VALUE,
        DTD;

    }
}

