/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.xml;

import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vesalainen.parser.GenClassFactory;
import org.vesalainen.parser.ParserInfo;
import org.vesalainen.parser.Trace;
import org.vesalainen.parser.TraceHelper;
import org.vesalainen.parser.annotation.ParseMethod;
import org.vesalainen.parser.annotation.ParserContext;
import org.vesalainen.parser.annotation.Rule;
import org.vesalainen.parser.annotation.Rules;
import org.vesalainen.parser.annotation.Terminal;
import org.vesalainen.parser.util.InputReader;
import org.vesalainen.parsers.xml.ExternalEntity;
import org.vesalainen.parsers.xml.QName;
import org.vesalainen.parsers.xml.SAX2Constants;
import org.vesalainen.parsers.xml.SAXFeatures;
import org.vesalainen.parsers.xml.XMLDTDBaseGrammar;
import org.vesalainen.parsers.xml.XMLLocator;
import org.vesalainen.regex.Regex;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XMLDocumentParser
extends XMLDTDBaseGrammar
implements XMLReader,
SAX2Constants,
ParserInfo {
    private DefaultHandler2 defaultHandler = new DefaultHandler2();
    private ContentHandler contentHandler = this.defaultHandler;
    private DTDHandler dtdHandler = this.defaultHandler;
    private EntityResolver entityResolver = this.defaultHandler;
    private ErrorHandler errorHandler = this.defaultHandler;
    private DeclHandler declHandler = this.defaultHandler;
    private LexicalHandler lexicalHandler = this.defaultHandler;
    private SAXFeatures features;
    private AttributesImpl attributes = new AttributesImpl();
    private int level;
    private Map<Integer, List<String>> nsScope = new HashMap<Integer, List<String>>();
    private Map<String, String> nameSpaces = new HashMap<String, String>();

    public XMLDocumentParser() {
        this.nameSpaces.put("", "");
    }

    public static XMLDocumentParser getInstance() throws IOException {
        return (XMLDocumentParser)GenClassFactory.getGenInstance(XMLDocumentParser.class);
    }

    void setFeatures(SAXFeatures features) {
        this.features = features;
    }

    private void parseExternal(InputSource input) throws IOException, SAXException {
        this.external = true;
        this.parse(input);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        try {
            this.input = input;
            this.inputReader = InputReader.getInstance((InputSource)input, (int)8192);
            this.locator = new XMLLocator(this.inputReader);
            if (this.contentHandler != null && !this.external) {
                this.contentHandler.setDocumentLocator(this.locator);
                this.contentHandler.startDocument();
            }
            if (this.external) {
                this.parseExtSubset(this.inputReader);
            } else {
                this.parseDocument(this.inputReader);
            }
            this.inputReader.close();
        }
        catch (IOException | SAXException ex) {
            SAXParseException exception = new SAXParseException("syntax error", this.locator, ex);
            if (this.errorHandler != null) {
                this.errorHandler.fatalError(exception);
            }
            throw exception;
        }
    }

    public void parseText(String text) throws IOException, SAXException {
        this.parse(new InputSource(new StringReader(text)));
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    @Rule(value={"prolog", "element", "misc*"})
    protected void document() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Rules(value={@Rule(value={"sTag"})})
    protected abstract void element();

    @Rule(value={"content"})
    protected abstract void elementContent();

    @ParseMethod(start="elementContent", eof="eTag", whiteSpace={"eol", "pi", "comment", "charData"})
    protected abstract void parseContent(InputReader var1);

    @Rule(value={"sTagName"})
    protected void sTag(QName name, @ParserContext(value="$inputReader") InputReader reader) throws SAXException {
        boolean empty;
        boolean bl = empty = !this.parseAttributes(reader);
        if (this.isNamespaceAware()) {
            this.contentHandler.startElement(this.nameSpaces.get(name.getPrefix()), name.getLocalPart(), name.toString(), this.attributes);
            if (empty) {
                this.contentHandler.endElement(this.nameSpaces.get(name.getPrefix()), name.getLocalPart(), name.toString());
            }
        } else {
            this.contentHandler.startElement("", "", name.toString(), this.attributes);
            if (empty) {
                this.contentHandler.endElement("", "", name.toString());
            }
        }
        this.attributes = new AttributesImpl();
        ++this.level;
        if (!empty) {
            this.parseContent(reader);
        }
    }

    @Terminal(expression=">")
    protected void endTag() {
    }

    @Rule
    protected boolean contentTag() {
        return true;
    }

    @Rule(value={"'/'"})
    protected boolean emptyTag() {
        return false;
    }

    @Rules(value={@Rule(value={"contentTag"}), @Rule(value={"emptyTag"})})
    protected boolean tagType(boolean hasContent) {
        return hasContent;
    }

    @ParseMethod(start="attributesSub", eof="endTag")
    protected abstract boolean parseAttributes(InputReader var1);

    @Rule(value={"attributes", "s?", "tagType"})
    protected abstract boolean attributesSub(boolean var1);

    @Rules(value={@Rule, @Rule(value={"attributes", "s", "attribute"})})
    protected abstract void attributes();

    @Rule(value={"qName", "eq", "attValue"})
    protected void attribute(QName name, String value) {
        if (this.isNamespaceAware()) {
            this.attributes.addAttribute(this.nameSpaces.get(name.getPrefix()), name.getLocalPart(), name.toString(), "", value);
        } else {
            this.attributes.addAttribute("", "", name.toString(), "", value);
        }
    }

    @Rule(value={"nsAttName", "eq", "attValue"})
    protected void attribute(String name, String uri) throws SAXException {
        if (this.isNamespaceAware()) {
            if (uri.isEmpty()) {
                String remove = this.nameSpaces.remove(name);
                if (remove == null) {
                    throw new SAXParseException("removing prefix " + name + " which is out of scope", this.locator);
                }
                if (this.supportNameSpacePrefixes()) {
                    this.contentHandler.endPrefixMapping(name);
                }
                List<String> prefixes = this.nsScope.get(this.level);
                prefixes.remove(name);
            } else {
                List<String> prefixes;
                this.nameSpaces.put(name, uri);
                if (this.supportNameSpacePrefixes()) {
                    this.contentHandler.startPrefixMapping(name, uri);
                }
                if ((prefixes = this.nsScope.get(this.level)) == null) {
                    prefixes = new ArrayList<String>();
                    this.nsScope.put(this.level, prefixes);
                }
                prefixes.add(name);
            }
            if (this.supportNameSpacePrefixes()) {
                this.attributes.addAttribute(this.nameSpaces.get("xmlns"), name, name, "", uri);
            }
        } else if (this.supportNameSpacePrefixes()) {
            this.attributes.addAttribute("", "", name.toString(), "", uri);
        }
    }

    @Terminal(expression="</[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*(:[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}][A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}\\-\\.0-9\\xB7\\u0300-\\u036F\\u203F-\\u2040]*)?[\\x20\\x09\\x0A]*>")
    protected void eTag(String s) throws SAXException {
        QName name = new QName(s.substring(2, s.length() - 1).trim());
        --this.level;
        if (this.isNamespaceAware()) {
            this.contentHandler.endElement(this.nameSpaces.get(name.getPrefix()), name.getLocalPart(), name.toString());
        } else {
            this.contentHandler.endElement("", "", name.toString());
        }
        List<String> prefixes = this.nsScope.get(this.level);
        if (prefixes != null) {
            if (this.supportNameSpacePrefixes()) {
                for (String prefix : prefixes) {
                    this.contentHandler.endPrefixMapping(prefix);
                }
            }
            this.nsScope.remove(this.level);
        }
    }

    @Rules(value={@Rule, @Rule(value={"content", "element"}), @Rule(value={"content", "cdSect"})})
    protected abstract void content();

    @Rules(value={@Rule(value={"content", "reference"})})
    protected void content(String charData) {
    }

    @Override
    @Rule(value={"externalID"})
    protected Object peDef(String[] externalID) throws SAXException, IOException {
        String pubId = externalID[0];
        String sysId = externalID[1];
        return new ExternalEntity(this.input, pubId, sysId, this.entityResolver);
    }

    @Override
    @Terminal(expression="[^<\\&\\x0d\\x85\\u2028]+")
    protected void charData(InputReader reader) throws SAXException {
        int end;
        int me;
        char[] array = reader.getArray();
        int start = reader.getStart();
        int ms = start % array.length;
        if (ms <= (me = (end = reader.getEnd()) % array.length)) {
            this.contentHandler.characters(array, ms, me - ms);
        } else {
            this.contentHandler.characters(array, ms, array.length - ms);
            this.contentHandler.characters(array, 0, me);
        }
    }

    @Override
    @Terminal(expression="<!\\-\\-[\\x01-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}]*\\-\\->", options={Regex.Option.FIXED_ENDER})
    protected void comment(InputReader reader) throws SAXException {
        int end;
        int me;
        char[] array = reader.getArray();
        int start = reader.getStart() + 4;
        int ms = start % array.length;
        if (ms <= (me = (end = reader.getEnd() - 3) % array.length)) {
            this.lexicalHandler.comment(array, ms, me - ms);
        } else {
            this.lexicalHandler.comment(array, ms, array.length - ms);
            this.lexicalHandler.comment(array, 0, me);
        }
    }

    @Override
    @Rule(value={"'<!DOCTYPE'", "qName", "optExternalID"})
    protected void doctypedeclStart(QName name, String[] externalID) throws SAXException, IOException {
        String pubId = externalID[0];
        String sysId = externalID[1];
        InputSource embeddedInput = null;
        this.lexicalHandler.startDTD(name.toString(), pubId, sysId);
        if (this.entityResolver instanceof EntityResolver2) {
            EntityResolver2 er2 = (EntityResolver2)this.entityResolver;
            embeddedInput = er2.resolveEntity(null, pubId, this.input.getSystemId(), sysId);
        } else {
            embeddedInput = this.entityResolver.resolveEntity(pubId, sysId);
        }
        this.lexicalHandler.startEntity("[dtd]");
        try {
            URI uri = new URI(this.input.getSystemId());
            String newSystemId = uri.resolve(sysId).toString();
            if (embeddedInput == null) {
                embeddedInput = new InputSource(newSystemId);
            }
            embeddedInput.setEncoding(this.input.getEncoding());
            embeddedInput.setPublicId(pubId);
            embeddedInput.setSystemId(newSystemId);
            this.parseExternal(embeddedInput);
        }
        catch (IOException | URISyntaxException | SAXException ex) {
            throw new SAXParseException("", this.locator, ex);
        }
    }

    @Override
    @Rule(value={"'>'"})
    protected void doctypedeclEnd() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    @Override
    @Rule(value={"'<!ENTITY'", "'%'", "name", "peDef", "'>'"})
    protected void peDecl(String name, Object value) throws SAXException {
        Object old = this.parameterReferences.put(name, value);
        if (old != null) {
            this.errorHandler.warning(new SAXParseException(name + " parameter reference defined more than once", this.locator));
        }
    }

    @Override
    @Rule(value={"'<!NOTATION'", "name", "externalID", "'>'"})
    protected void notationDecl(String name, String[] externalID) throws SAXException {
        this.dtdHandler.notationDecl(name, externalID[0], externalID[1]);
    }

    @Override
    @Rule(value={"'<!NOTATION'", "name", "publicID", "'>'"})
    protected void notationDecl(String name, String publicID) throws SAXException {
        this.dtdHandler.notationDecl(name, publicID, null);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler != null ? contentHandler : this.defaultHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this.declHandler = declHandler != null ? declHandler : this.defaultHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler != null ? dtdHandler : this.defaultHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver != null ? entityResolver : this.defaultHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler != null ? errorHandler : this.defaultHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler != null ? lexicalHandler : this.defaultHandler;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            return this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/document-xml-version".equals(name)) {
            return this.locator.getXMLVersion();
        }
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            this.declHandler = (DeclHandler)value;
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
            return;
        }
        if ("http://xml.org/sax/properties/document-xml-version".equals(name)) {
            throw new SAXNotSupportedException(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    protected void trace(int ord, int ctx, @ParserContext(value="$inputReader") InputReader reader, @ParserContext(value="$token") int token, @ParserContext(value="$laToken") int laToken, @ParserContext(value="$curTok") int curtok, @ParserContext(value="$stateStack") int[] stack, @ParserContext(value="$sp") int sp, @ParserContext(value="$typeStack") int[] typeStack, @ParserContext(value="$valueStack") Object[] valueStack) {
        Trace trace = Trace.values()[ord];
        switch (trace) {
            case STATE: {
                System.err.println("state " + stack[sp]);
                break;
            }
            case INPUT: {
                System.err.println("input" + ctx + "='" + reader.getString() + "' token=" + this.getToken(token));
                break;
            }
            case LAINPUT: {
                System.err.println("lainput" + ctx + "='" + reader.getString() + "' token=" + this.getToken(laToken));
                break;
            }
            case PUSHVALUE: {
                System.err.println("push value");
                break;
            }
            case EXITLA: {
                System.err.println("exit La");
                TraceHelper.printStacks((PrintStream)System.err, (int[])stack, (int[])typeStack, (Object[])valueStack, (int)sp);
                break;
            }
            case BEFOREREDUCE: {
                System.err.println("Before reducing rule " + this.getRule(ctx));
                TraceHelper.printStacks((PrintStream)System.err, (int[])stack, (int[])typeStack, (Object[])valueStack, (int)sp);
                break;
            }
            case AFTERREDUCE: {
                System.err.println("After reducing rule " + this.getRule(ctx));
                TraceHelper.printStacks((PrintStream)System.err, (int[])stack, (int[])typeStack, (Object[])valueStack, (int)sp);
                break;
            }
            case GOTO: {
                System.err.println("Goto " + ctx);
                break;
            }
            case SHIFT: {
                System.err.println("Shift " + ctx);
                break;
            }
            case SHRD: {
                System.err.println("Shift/Reduce");
                break;
            }
            case LASHRD: {
                System.err.println("La Shift/Reduce");
                break;
            }
            case GTRD: {
                System.err.println("Goto/Reduce");
                break;
            }
            case LASHIFT: {
                System.err.println("LaShift State " + ctx);
                TraceHelper.printStacks((PrintStream)System.err, (int[])stack, (int[])typeStack, (Object[])valueStack, (int)sp);
                break;
            }
            default: {
                System.err.println("unknown action " + trace);
            }
        }
    }

    @Rule(value={"'<!ELEMENT'", "qName", "contentspec", "'>'"})
    protected void elementdecl(QName name) {
    }

    @Rules(value={@Rule(value={"'EMPTY'"}), @Rule(value={"'ANY'"}), @Rule(value={"mixed"}), @Rule(value={"children"})})
    protected abstract void contentspec();

    @Rules(value={@Rule(value={"choice", "('[\\+\\*\\?]')?"}), @Rule(value={"seq", "('[\\+\\*\\?]')?"})})
    protected abstract void children();

    @Rule(value={"qName", "('[\\+\\*\\?]')?"})
    protected void cp(QName name) {
    }

    @Rules(value={@Rule(value={"choice", "('[\\+\\*\\?]')?"}), @Rule(value={"seq", "('[\\+\\*\\?]')?"})})
    protected abstract void cp();

    @Rule(value={"'\\('", "cp", "('\\|' cp)+", "'\\)'"})
    protected abstract void choice();

    @Rule(value={"'\\('", "cp", "('\\,' cp)*", "'\\)'"})
    protected abstract void seq();

    @Rules(value={@Rule(value={"'\\('", "'#PCDATA'", "mixedNames", "'\\)'", "'\\*'"}), @Rule(value={"'\\('", "'#PCDATA'", "'\\)'"})})
    protected abstract void mixed();

    @Rule
    protected abstract void mixedNames();

    @Rule(value={"mixedNames", "'\\|'", "qName"})
    protected void mixedNames(QName name) {
    }

    @Rule(value={"'<!ATTLIST'", "qName", "attDef*", "'>'"})
    protected void attlistDecl(QName name) {
    }

    @Rule(value={"qName", "attType", "defaultDecl"})
    protected void attDef(QName name) {
    }

    @Rule(value={"nsAttName", "attType", "defaultDecl"})
    protected void attDef(String name) {
    }

    @Rules(value={@Rule(value={"stringType"}), @Rule(value={"tokenizedType"}), @Rule(value={"enumeratedType"})})
    protected abstract void attType();

    @Rule(value={"'CDATA'"})
    protected abstract void stringType();

    @Rules(value={@Rule(value={"'ID'"}), @Rule(value={"'ID'", "'REF'"}), @Rule(value={"'ID'", "'REF'", "'S'"}), @Rule(value={"'ENTITY'"}), @Rule(value={"'ENTITIES'"}), @Rule(value={"'NMTOKEN'"}), @Rule(value={"'NMTOKEN'", "'S'"})})
    protected abstract void tokenizedType();

    @Rules(value={@Rule(value={"notationType"}), @Rule(value={"enumeration"})})
    protected abstract void enumeratedType();

    @Rule(value={"'NOTATION'", "'\\('", "name", "notationTypeNames", "'\\)'"})
    protected void notationType(String name) {
    }

    @Rule
    protected abstract void notationTypeNames();

    @Rule(value={"notationTypeNames", "'\\|'", "name"})
    protected void notationTypeNames(String name) {
    }

    @Rule(value={"'\\('", "nmtoken", "enumerationNMTokens", "'\\)'"})
    protected void enumeration(String name) {
    }

    @Rule
    protected abstract void enumerationNMTokens();

    @Rule(value={"enumerationNMTokens", "'\\|'", "nmtoken"})
    protected void enumerationNMTokens(String name) {
    }

    @Rules(value={@Rule(value={"'#REQUIRED'"}), @Rule(value={"'#IMPLIED'"})})
    protected abstract void defaultDecl();

    @Rule(value={"'#FIXED'?", "attValue"})
    protected void defaultDecl(String value) {
    }

    public static void main(String[] args) {
    }

    private boolean isNamespaceAware() {
        try {
            return this.features.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            return false;
        }
    }

    private boolean supportNameSpacePrefixes() {
        try {
            return this.features.getFeature("http://xml.org/sax/features/namespace-prefixes");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            return false;
        }
    }
}

