/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.parsers.xml.model;

import java.util.Arrays;
import java.util.List;

public abstract class Attribute {
    private String name;

    public Attribute(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract Object getValue();

    public static Attribute createSingleAttribute(String name, String value) {
        return new SingleAttribute(name, value);
    }

    public static Attribute createListAttribute(String name, String value) {
        return new ListAttribute(name, Arrays.asList(value.split(" ")));
    }

    private static class ListAttribute
    extends Attribute {
        private List<String> value;

        public ListAttribute(String name, List<String> value) {
            super(name);
            this.value = value;
        }

        @Override
        public List<String> getValue() {
            return this.value;
        }
    }

    private static class SingleAttribute
    extends Attribute {
        private String value;

        public SingleAttribute(String name, String value) {
            super(name);
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

