/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.ash.circe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.virtuslab.ash.circe.Compression;
import org.virtuslab.ash.circe.Compression$Off$;
import scala.MatchError;

public final class Compression$ {
    public static final Compression$ MODULE$ = new Compression$();

    public byte[] compressIfNeeded(byte[] bytes, int bufferSize, Compression.Algorithm compressionAlgorithm) {
        Compression.Algorithm algorithm = compressionAlgorithm;
        if (Compression$Off$.MODULE$.equals(algorithm)) {
            return bytes;
        }
        if (algorithm instanceof Compression.GZip) {
            Compression.GZip gZip = (Compression.GZip)algorithm;
            long largerThan = gZip.greaterThan();
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bufferSize);
            try (GZIPOutputStream outputStream = new GZIPOutputStream(byteArrayOutputStream);){
                outputStream.write(bytes);
            }
            return byteArrayOutputStream.toByteArray();
        }
        throw new MatchError((Object)algorithm);
    }

    public byte[] decompressIfNeeded(byte[] bytes, int bufferSize) {
        if (this.isCompressedWithGzip(bytes)) {
            GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(bytes));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[bufferSize];
            try {
                this.readChunk$1(inputStream, buffer, outputStream);
            }
            finally {
                inputStream.close();
            }
            return outputStream.toByteArray();
        }
        return bytes;
    }

    public boolean isCompressedWithGzip(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[0] == (byte)35615 && bytes[1] == (byte)139;
    }

    private final void readChunk$1(GZIPInputStream inputStream$1, byte[] buffer$1, ByteArrayOutputStream outputStream$1) {
        block3: while (true) {
            int n = inputStream$1.read(buffer$1);
            switch (n) {
                case -1: {
                    break block3;
                }
                default: {
                    outputStream$1.write(buffer$1, 0, n);
                    break;
                }
            }
        }
    }

    private Compression$() {
    }
}

