/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bazel.commons.symlinks;

import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/bazel/commons/symlinks/BazelSymlinksCalculator;", "", "<init>", "()V", "calculateBazelSymlinksToExclude", "", "Ljava/nio/file/Path;", "workspaceRoot", "bazelSymlinksScanMaxDepth", "", "commons_src_main_kotlin_org_jetbrains_bazel_commons_symlinks-symlinks"})
public final class BazelSymlinksCalculator {
    @NotNull
    public static final BazelSymlinksCalculator INSTANCE = new BazelSymlinksCalculator();

    private BazelSymlinksCalculator() {
    }

    @NotNull
    public final List<Path> calculateBazelSymlinksToExclude(@NotNull Path workspaceRoot, int bazelSymlinksScanMaxDepth) {
        Intrinsics.checkNotNullParameter((Object)workspaceRoot, (String)"workspaceRoot");
        List symlinksToExclude = new ArrayList();
        Object[] objectArray = new String[]{"bin", "out", "testlogs", PathsKt.getName((Path)workspaceRoot)};
        List bazelSymlinkEndings = CollectionsKt.listOf((Object[])objectArray);
        SimpleFileVisitor<Path> visitor2 = new SimpleFileVisitor<Path>((List<String>)bazelSymlinkEndings, (List<Path>)symlinksToExclude){
            final /* synthetic */ List<String> $bazelSymlinkEndings;
            final /* synthetic */ List<Path> $symlinksToExclude;
            {
                this.$bazelSymlinkEndings = $bazelSymlinkEndings;
                this.$symlinksToExclude = $symlinksToExclude;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                boolean bl;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Iterable $this$none$iv = this.$bazelSymlinkEndings;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.endsWith$default((String)PathsKt.getName((Path)file), (String)it, (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return FileVisitResult.CONTINUE;
                }
                Path resolved = file.toRealPath(new LinkOption[0]);
                if (Intrinsics.areEqual((Object)resolved, (Object)file)) {
                    return FileVisitResult.CONTINUE;
                }
                Intrinsics.checkNotNull((Object)resolved);
                if (!StringsKt.contains$default((CharSequence)PathsKt.getInvariantSeparatorsPathString((Path)resolved), (CharSequence)"execroot/_main", (boolean)false, (int)2, null)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                this.$symlinksToExclude.add(file);
                return FileVisitResult.SKIP_SUBTREE;
            }
        };
        Files.walkFileTree(workspaceRoot, SetsKt.emptySet(), bazelSymlinksScanMaxDepth, (FileVisitor<? super Path>)visitor2);
        return symlinksToExclude;
    }
}

