/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bazel.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.AllPackagesBeneath;
import org.jetbrains.bazel.label.AllRuleTargets;
import org.jetbrains.bazel.label.AllRuleTargetsAndFiles;
import org.jetbrains.bazel.label.AmbiguousEmptyTarget;
import org.jetbrains.bazel.label.Apparent;
import org.jetbrains.bazel.label.Canonical;
import org.jetbrains.bazel.label.Main;
import org.jetbrains.bazel.label.Package;
import org.jetbrains.bazel.label.PackageType;
import org.jetbrains.bazel.label.RelativeLabel;
import org.jetbrains.bazel.label.RepoType;
import org.jetbrains.bazel.label.ResolvedLabel;
import org.jetbrains.bazel.label.SingleTarget;
import org.jetbrains.bazel.label.SyntheticLabel;
import org.jetbrains.bazel.label.TargetType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017J\b\u0010\u0016\u001a\u00020\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010\u0082\u0001\u0003\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/bazel/label/Label;", "", "packagePath", "Lorg/jetbrains/bazel/label/PackageType;", "getPackagePath", "()Lorg/jetbrains/bazel/label/PackageType;", "target", "Lorg/jetbrains/bazel/label/TargetType;", "getTarget", "()Lorg/jetbrains/bazel/label/TargetType;", "targetName", "", "getTargetName", "()Ljava/lang/String;", "isMainWorkspace", "", "()Z", "isRelative", "isSynthetic", "isWildcard", "isRecursive", "isApparent", "toShortString", "Companion", "Lorg/jetbrains/bazel/label/RelativeLabel;", "Lorg/jetbrains/bazel/label/ResolvedLabel;", "Lorg/jetbrains/bazel/label/SyntheticLabel;", "commons_src_main_kotlin_org_jetbrains_bazel_label-label"})
public interface Label {
    @NotNull
    public static final Companion Companion = org.jetbrains.bazel.label.Label$Companion.$$INSTANCE;

    @NotNull
    public PackageType getPackagePath();

    @NotNull
    public TargetType getTarget();

    @NotNull
    public String getTargetName();

    public boolean isMainWorkspace();

    public boolean isRelative();

    public boolean isSynthetic();

    public boolean isWildcard();

    public boolean isRecursive();

    public boolean isApparent();

    @NotNull
    public String toShortString();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/bazel/label/Label$Companion;", "", "<init>", "()V", "synthetic", "Lorg/jetbrains/bazel/label/Label;", "targetName", "", "parse", "value", "parseOrNull", "commons_src_main_kotlin_org_jetbrains_bazel_label-label"})
    @SourceDebugExtension(value={"SMAP\nLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Label.kt\norg/jetbrains/bazel/label/Label$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n774#2:285\n865#2,2:286\n1#3:288\n*S KotlinDebug\n*F\n+ 1 Label.kt\norg/jetbrains/bazel/label/Label$Companion\n*L\n224#1:285\n224#1:286,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Label synthetic(@NotNull String targetName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            return new SyntheticLabel(new SingleTarget(StringsKt.removeSuffix((String)targetName, (CharSequence)"[synthetic]")));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Label parse(@NotNull String value) {
            TargetType target;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (StringsKt.endsWith$default((String)value, (String)"[synthetic]", (boolean)false, (int)2, null)) {
                return this.synthetic(value);
            }
            char[] cArray = new char[]{'@'};
            String normalized = StringsKt.trimStart((String)value, (char[])cArray);
            String repoName = StringsKt.substringBefore((String)normalized, (String)"//", (String)"");
            String pathAndName = StringsKt.substringAfter$default((String)normalized, (String)"//", null, (int)2, null);
            String packagePath = StringsKt.substringBefore$default((String)pathAndName, (String)":", null, (int)2, null);
            String[] stringArray = new String[]{"/"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)packagePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List packageSegments = (List)destination$iv$iv;
            PackageType packageType = Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)packageSegments), (Object)"...") ? (PackageType)new AllPackagesBeneath(CollectionsKt.dropLast((List)packageSegments, (int)1)) : (PackageType)new Package(packageSegments);
            String targetName = StringsKt.substringAfter((String)pathAndName, (String)":", (String)StringsKt.substringAfterLast$default((String)packagePath, (String)"/", null, (int)2, null));
            TargetType targetType = Intrinsics.areEqual((Object)targetName, (Object)"*") ? (TargetType)AllRuleTargetsAndFiles.INSTANCE : (Intrinsics.areEqual((Object)targetName, (Object)"all-targets") ? (TargetType)AllRuleTargetsAndFiles.INSTANCE : (Intrinsics.areEqual((Object)targetName, (Object)"all") ? (TargetType)AllRuleTargets.INSTANCE : (Intrinsics.areEqual((Object)targetName, (Object)"...") ? (TargetType)AllRuleTargets.INSTANCE : (target = StringsKt.contains$default((CharSequence)pathAndName, (CharSequence)":", (boolean)false, (int)2, null) ? (TargetType)new SingleTarget(targetName) : (TargetType)AmbiguousEmptyTarget.INSTANCE))));
            if (!StringsKt.contains$default((CharSequence)value, (CharSequence)"//", (boolean)false, (int)2, null)) {
                return new RelativeLabel(packageType, target);
            }
            RepoType repo = ((CharSequence)repoName).length() == 0 ? (RepoType)Main.INSTANCE : (StringsKt.startsWith$default((String)value, (String)"@@", (boolean)false, (int)2, null) ? (RepoType)new Canonical(repoName) : (RepoType)new Apparent(repoName));
            return new ResolvedLabel(repo, packageType, target);
        }

        @Nullable
        public final Label parseOrNull(@Nullable String value) {
            Label label;
            try {
                Label label2;
                String string = value;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    label2 = $$INSTANCE.parse(it);
                } else {
                    label2 = null;
                }
                label = label2;
            }
            catch (Exception exception) {
                label = null;
            }
            return label;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public static String getTargetName(@NotNull Label $this) {
            String string;
            if (!($this.getTarget() instanceof AmbiguousEmptyTarget)) {
                string = $this.getTarget().toString();
                return string;
            }
            PackageType packageType = $this.getPackagePath();
            if (packageType instanceof Package) {
                PackageType packageType2 = $this.getPackagePath();
                Intrinsics.checkNotNull((Object)packageType2, (String)"null cannot be cast to non-null type org.jetbrains.bazel.label.Package");
                string = ((Package)packageType2).name();
                return string;
            }
            if (!(packageType instanceof AllPackagesBeneath)) throw new NoWhenBranchMatchedException();
            return "...";
        }

        public static boolean isMainWorkspace(@NotNull Label $this) {
            ResolvedLabel resolvedLabel = $this instanceof ResolvedLabel ? (ResolvedLabel)$this : null;
            return (resolvedLabel != null ? resolvedLabel.getRepo() : null) instanceof Main || $this instanceof SyntheticLabel;
        }

        public static boolean isRelative(@NotNull Label $this) {
            return $this instanceof RelativeLabel;
        }

        public static boolean isSynthetic(@NotNull Label $this) {
            return $this instanceof SyntheticLabel;
        }

        public static boolean isWildcard(@NotNull Label $this) {
            return $this.getTarget() instanceof AllRuleTargetsAndFiles || $this.getTarget() instanceof AllRuleTargets || $this.getPackagePath() instanceof AllPackagesBeneath;
        }

        public static boolean isRecursive(@NotNull Label $this) {
            return $this.getPackagePath() instanceof AllPackagesBeneath;
        }

        public static boolean isApparent(@NotNull Label $this) {
            ResolvedLabel resolvedLabel = $this instanceof ResolvedLabel ? (ResolvedLabel)$this : null;
            return (resolvedLabel != null ? resolvedLabel.getRepo() : null) instanceof Apparent;
        }
    }
}

