/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bazel.label;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.AllPackagesBeneath;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bazel.label.LabelKt;
import org.jetbrains.bazel.label.Package;
import org.jetbrains.bazel.label.PackageType;
import org.jetbrains.bazel.label.RepoType;
import org.jetbrains.bazel.label.ResolvedLabel;
import org.jetbrains.bazel.label.TargetType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/bazel/label/RelativeLabel;", "Lorg/jetbrains/bazel/label/Label;", "packagePath", "Lorg/jetbrains/bazel/label/PackageType;", "target", "Lorg/jetbrains/bazel/label/TargetType;", "<init>", "(Lorg/jetbrains/bazel/label/PackageType;Lorg/jetbrains/bazel/label/TargetType;)V", "getPackagePath", "()Lorg/jetbrains/bazel/label/PackageType;", "getTarget", "()Lorg/jetbrains/bazel/label/TargetType;", "toString", "", "toShortString", "resolve", "Lorg/jetbrains/bazel/label/ResolvedLabel;", "base", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "commons_src_main_kotlin_org_jetbrains_bazel_label-label"})
public final class RelativeLabel
implements Label {
    @NotNull
    private final PackageType packagePath;
    @NotNull
    private final TargetType target;

    public RelativeLabel(@NotNull PackageType packagePath, @NotNull TargetType target) {
        Intrinsics.checkNotNullParameter((Object)packagePath, (String)"packagePath");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.packagePath = packagePath;
        this.target = target;
    }

    @Override
    @NotNull
    public PackageType getPackagePath() {
        return this.packagePath;
    }

    @Override
    @NotNull
    public TargetType getTarget() {
        return this.target;
    }

    @NotNull
    public String toString() {
        return LabelKt.access$joinPackagePathAndTarget(this.getPackagePath(), this.getTarget());
    }

    @Override
    @NotNull
    public String toShortString() {
        return this.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ResolvedLabel resolve(@NotNull ResolvedLabel base) {
        PackageType packageType;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        RepoType repo = base.getRepo();
        List mergedPath = CollectionsKt.plus((Collection)base.getPackagePath().getPathSegments(), (Iterable)this.getPackagePath().getPathSegments());
        PackageType packageType2 = base.getPackagePath();
        if (packageType2 instanceof Package) {
            PackageType packageType3 = this.getPackagePath();
            if (packageType3 instanceof Package) {
                packageType = new Package(mergedPath);
            } else {
                if (!(packageType3 instanceof AllPackagesBeneath)) throw new NoWhenBranchMatchedException();
                packageType = new AllPackagesBeneath(mergedPath);
            }
        } else {
            if (!(packageType2 instanceof AllPackagesBeneath)) throw new NoWhenBranchMatchedException();
            throw new IllegalStateException("Cannot resolve a relative label with respect to a wildcard package".toString());
        }
        PackageType packagePath = packageType;
        TargetType target = this.getTarget();
        return new ResolvedLabel(repo, packagePath, target);
    }

    @NotNull
    public final PackageType component1() {
        return this.packagePath;
    }

    @NotNull
    public final TargetType component2() {
        return this.target;
    }

    @NotNull
    public final RelativeLabel copy(@NotNull PackageType packagePath, @NotNull TargetType target) {
        Intrinsics.checkNotNullParameter((Object)packagePath, (String)"packagePath");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new RelativeLabel(packagePath, target);
    }

    public static /* synthetic */ RelativeLabel copy$default(RelativeLabel relativeLabel, PackageType packageType, TargetType targetType, int n, Object object) {
        if ((n & 1) != 0) {
            packageType = relativeLabel.packagePath;
        }
        if ((n & 2) != 0) {
            targetType = relativeLabel.target;
        }
        return relativeLabel.copy(packageType, targetType);
    }

    public int hashCode() {
        int result2 = this.packagePath.hashCode();
        result2 = result2 * 31 + this.target.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelativeLabel)) {
            return false;
        }
        RelativeLabel relativeLabel = (RelativeLabel)other;
        if (!Intrinsics.areEqual((Object)this.packagePath, (Object)relativeLabel.packagePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.target, (Object)relativeLabel.target);
    }

    @Override
    @NotNull
    public String getTargetName() {
        return Label.DefaultImpls.getTargetName(this);
    }

    @Override
    public boolean isMainWorkspace() {
        return Label.DefaultImpls.isMainWorkspace(this);
    }

    @Override
    public boolean isRelative() {
        return Label.DefaultImpls.isRelative(this);
    }

    @Override
    public boolean isSynthetic() {
        return Label.DefaultImpls.isSynthetic(this);
    }

    @Override
    public boolean isWildcard() {
        return Label.DefaultImpls.isWildcard(this);
    }

    @Override
    public boolean isRecursive() {
        return Label.DefaultImpls.isRecursive(this);
    }

    @Override
    public boolean isApparent() {
        return Label.DefaultImpls.isApparent(this);
    }
}

