/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bazel.label;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.AmbiguousEmptyTarget;
import org.jetbrains.bazel.label.Apparent;
import org.jetbrains.bazel.label.Canonical;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bazel.label.LabelKt;
import org.jetbrains.bazel.label.Main;
import org.jetbrains.bazel.label.Package;
import org.jetbrains.bazel.label.PackageType;
import org.jetbrains.bazel.label.RepoType;
import org.jetbrains.bazel.label.SingleTarget;
import org.jetbrains.bazel.label.TargetType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/jetbrains/bazel/label/ResolvedLabel;", "Lorg/jetbrains/bazel/label/Label;", "repo", "Lorg/jetbrains/bazel/label/RepoType;", "packagePath", "Lorg/jetbrains/bazel/label/PackageType;", "target", "Lorg/jetbrains/bazel/label/TargetType;", "<init>", "(Lorg/jetbrains/bazel/label/RepoType;Lorg/jetbrains/bazel/label/PackageType;Lorg/jetbrains/bazel/label/TargetType;)V", "getRepo", "()Lorg/jetbrains/bazel/label/RepoType;", "getPackagePath", "()Lorg/jetbrains/bazel/label/PackageType;", "getTarget", "()Lorg/jetbrains/bazel/label/TargetType;", "repoName", "", "getRepoName", "()Ljava/lang/String;", "toBazelPath", "Ljava/nio/file/Path;", "toString", "toShortString", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "commons_src_main_kotlin_org_jetbrains_bazel_label-label"})
@SourceDebugExtension(value={"SMAP\nLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Label.kt\norg/jetbrains/bazel/label/ResolvedLabel\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,284:1\n37#2:285\n36#2,3:286\n37#2:289\n36#2,3:290\n*S KotlinDebug\n*F\n+ 1 Label.kt\norg/jetbrains/bazel/label/ResolvedLabel\n*L\n123#1:285\n123#1:286,3\n125#1:289\n125#1:290,3\n*E\n"})
public final class ResolvedLabel
implements Label {
    @NotNull
    private final RepoType repo;
    @NotNull
    private final PackageType packagePath;
    @NotNull
    private final TargetType target;

    public ResolvedLabel(@NotNull RepoType repo, @NotNull PackageType packagePath, @NotNull TargetType target) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)packagePath, (String)"packagePath");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.repo = repo;
        this.packagePath = packagePath;
        this.target = target;
    }

    @NotNull
    public final RepoType getRepo() {
        return this.repo;
    }

    @Override
    @NotNull
    public PackageType getPackagePath() {
        return this.packagePath;
    }

    @Override
    @NotNull
    public TargetType getTarget() {
        return this.target;
    }

    @NotNull
    public final String getRepoName() {
        return this.repo.getRepoName();
    }

    @NotNull
    public final Path toBazelPath() {
        Path path2;
        if (!(this.getPackagePath() instanceof Package)) {
            throw new IllegalStateException("Cannot convert wildcard package to path".toString());
        }
        RepoType repoType = this.repo;
        if (repoType instanceof Main) {
            Path path3 = Paths.get(((Package)this.getPackagePath()).toString(), new String[0]);
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else if (repoType instanceof Canonical) {
            String string = "external";
            String[] stringArray = new SpreadBuilder(2);
            stringArray.add((Object)((Canonical)this.repo).getRepoName());
            Collection $this$toTypedArray$iv = ((Package)this.getPackagePath()).getPathSegments();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray.addSpread((Object)thisCollection$iv.toArray(new String[0]));
            stringArray = (String[])stringArray.toArray((Object[])new String[stringArray.size()]);
            Path path4 = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        } else if (repoType instanceof Apparent) {
            String string = "external";
            String[] stringArray = new SpreadBuilder(2);
            stringArray.add((Object)((Apparent)this.repo).getRepoName());
            Collection $this$toTypedArray$iv = ((Package)this.getPackagePath()).getPathSegments();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray.addSpread((Object)thisCollection$iv.toArray(new String[0]));
            stringArray = (String[])stringArray.toArray((Object[])new String[stringArray.size()]);
            Path path5 = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
            path2 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return path2;
    }

    @NotNull
    public String toString() {
        return this.repo + "//" + LabelKt.access$joinPackagePathAndTarget(this.getPackagePath(), this.getTarget());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public String toShortString() {
        block3: {
            block2: {
                repoPart = this.repo instanceof Main == false ? this.repo.toString() : "";
                packagePart = this.getPackagePath().toString();
                if (!(this.getTarget() instanceof AmbiguousEmptyTarget)) break block2;
                v0 = "";
                break block3;
            }
            if (!(this.getTarget() instanceof SingleTarget)) ** GOTO lbl-1000
            var4_3 = this.getPackagePath();
            v1 = var4_3 instanceof Package != false ? (Package)var4_3 : null;
            if (Intrinsics.areEqual((Object)((SingleTarget)this.getTarget()).getTargetName(), (Object)(v1 != null ? v1.name() : null))) {
                v0 = "";
            } else lbl-1000:
            // 2 sources

            {
                v0 = ":" + this.getTarget();
            }
        }
        targetPart = v0;
        return repoPart + "//" + packagePart + targetPart;
    }

    @NotNull
    public final RepoType component1() {
        return this.repo;
    }

    @NotNull
    public final PackageType component2() {
        return this.packagePath;
    }

    @NotNull
    public final TargetType component3() {
        return this.target;
    }

    @NotNull
    public final ResolvedLabel copy(@NotNull RepoType repo, @NotNull PackageType packagePath, @NotNull TargetType target) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)packagePath, (String)"packagePath");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new ResolvedLabel(repo, packagePath, target);
    }

    public static /* synthetic */ ResolvedLabel copy$default(ResolvedLabel resolvedLabel, RepoType repoType, PackageType packageType, TargetType targetType, int n, Object object) {
        if ((n & 1) != 0) {
            repoType = resolvedLabel.repo;
        }
        if ((n & 2) != 0) {
            packageType = resolvedLabel.packagePath;
        }
        if ((n & 4) != 0) {
            targetType = resolvedLabel.target;
        }
        return resolvedLabel.copy(repoType, packageType, targetType);
    }

    public int hashCode() {
        int result2 = this.repo.hashCode();
        result2 = result2 * 31 + this.packagePath.hashCode();
        result2 = result2 * 31 + this.target.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvedLabel)) {
            return false;
        }
        ResolvedLabel resolvedLabel = (ResolvedLabel)other;
        if (!Intrinsics.areEqual((Object)this.repo, (Object)resolvedLabel.repo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.packagePath, (Object)resolvedLabel.packagePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.target, (Object)resolvedLabel.target);
    }

    @Override
    @NotNull
    public String getTargetName() {
        return Label.DefaultImpls.getTargetName(this);
    }

    @Override
    public boolean isMainWorkspace() {
        return Label.DefaultImpls.isMainWorkspace(this);
    }

    @Override
    public boolean isRelative() {
        return Label.DefaultImpls.isRelative(this);
    }

    @Override
    public boolean isSynthetic() {
        return Label.DefaultImpls.isSynthetic(this);
    }

    @Override
    public boolean isWildcard() {
        return Label.DefaultImpls.isWildcard(this);
    }

    @Override
    public boolean isRecursive() {
        return Label.DefaultImpls.isRecursive(this);
    }

    @Override
    public boolean isApparent() {
        return Label.DefaultImpls.isApparent(this);
    }
}

