/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.bazelrunner;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.commons.utils.OsFamily;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommandExecutionDescriptor;
import org.jetbrains.bsp.bazel.bazelrunner.HasAdditionalBazelOptions;
import org.jetbrains.bsp.bazel.bazelrunner.HasEnvironment;
import org.jetbrains.bsp.bazel.bazelrunner.HasMultipleTargets;
import org.jetbrains.bsp.bazel.bazelrunner.HasProgramArguments;
import org.jetbrains.bsp.bazel.bazelrunner.HasSingleTarget;
import org.jetbrains.bsp.bazel.bazelrunner.HasWorkingDirectory;
import org.jetbrains.bsp.bazel.bazelrunner.params.BazelFlag;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfo;
import org.jetbrains.bsp.bazel.workspacecontext.TargetsSpec;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b&\u0018\u00002\u00020\u0001:\u0011\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH&J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006%"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "getBazelBinary", "()Ljava/lang/String;", "startupOptions", "", "getStartupOptions", "()Ljava/util/List;", "options", "getOptions", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "useBes", "", "besOutputFile", "Ljava/nio/file/Path;", "Run", "Build", "Test", "Coverage", "MobileInstall", "Query", "CQuery", "SimpleCommand", "Version", "Info", "Clean", "ShutDown", "ModGraph", "ModPath", "ModShowRepo", "ModDumpRepoMapping", "FileQuery", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
public abstract class BazelCommand {
    @NotNull
    private final String bazelBinary;
    @NotNull
    private final List<String> startupOptions;
    @NotNull
    private final List<String> options;

    public BazelCommand(@NotNull String bazelBinary) {
        Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
        this.bazelBinary = bazelBinary;
        this.startupOptions = new ArrayList();
        Object[] objectArray = new String[]{BazelFlag.toolTag()};
        this.options = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public final String getBazelBinary() {
        return this.bazelBinary;
    }

    @NotNull
    public final List<String> getStartupOptions() {
        return this.startupOptions;
    }

    @NotNull
    public final List<String> getOptions() {
        return this.options;
    }

    @NotNull
    public abstract BazelCommandExecutionDescriptor buildExecutionDescriptor();

    public final void useBes(@NotNull Path besOutputFile) {
        Intrinsics.checkNotNullParameter((Object)besOutputFile, (String)"besOutputFile");
        Object[] objectArray = new String[]{"--build_event_binary_file=" + besOutputFile.toAbsolutePath(), "--bes_outerr_buffer_size=10", "--build_event_publish_all_actions"};
        this.options.addAll(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001bB\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Build;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasEnvironment;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasMultipleTargets;", "bazelInfo", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "bazelBinary", "", "<init>", "(Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;Ljava/lang/String;)V", "targets", "", "Lorg/jetbrains/bazel/label/Label;", "getTargets", "()Ljava/util/List;", "excludedTargets", "getExcludedTargets", "environment", "", "getEnvironment", "()Ljava/util/Map;", "inheritedEnvironment", "getInheritedEnvironment", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "prepareTargetPatternFile", "Ljava/nio/file/Path;", "Companion", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    @SourceDebugExtension(value={"SMAP\nBazelCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelCommand.kt\norg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Build\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n126#2:346\n153#2,3:347\n1557#3:350\n1628#3,3:351\n1557#3:355\n1628#3,3:356\n1#4:354\n*S KotlinDebug\n*F\n+ 1 BazelCommand.kt\norg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Build\n*L\n138#1:346\n138#1:347,3\n139#1:350\n139#1:351,3\n168#1:355\n168#1:356,3\n*E\n"})
    public static final class Build
    extends BazelCommand
    implements HasEnvironment,
    HasMultipleTargets {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final BazelInfo bazelInfo;
        @NotNull
        private final List<Label> targets;
        @NotNull
        private final List<Label> excludedTargets;
        @NotNull
        private final Map<String, String> environment;
        @NotNull
        private final List<String> inheritedEnvironment;
        @NotNull
        private static final Logger log;

        public Build(@Nullable BazelInfo bazelInfo, @NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary);
            this.bazelInfo = bazelInfo;
            this.targets = new ArrayList();
            this.excludedTargets = new ArrayList();
            this.environment = new LinkedHashMap();
            this.inheritedEnvironment = new ArrayList();
        }

        @Override
        @NotNull
        public List<Label> getTargets() {
            return this.targets;
        }

        @Override
        @NotNull
        public List<Label> getExcludedTargets() {
            return this.excludedTargets;
        }

        @Override
        @NotNull
        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        @NotNull
        public List<String> getInheritedEnvironment() {
            return this.inheritedEnvironment;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BazelCommandExecutionDescriptor buildExecutionDescriptor() {
            Collection collection;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Function0 finishCallback2 = buildExecutionDescriptor.finishCallback.1.INSTANCE;
            Object object2 = new String[]{this.getBazelBinary()};
            List commandLine = CollectionsKt.mutableListOf((Object[])object2);
            commandLine.addAll((Collection)this.getStartupOptions());
            commandLine.add("build");
            commandLine.addAll((Collection)this.getOptions());
            object2 = this.getEnvironment();
            List list = commandLine;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                object = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)object.getKey();
                String value = (String)object.getValue();
                collection.add("--action_env=" + key + "=" + value);
            }
            list.addAll((List)destination$iv$iv);
            $this$map$iv = this.getInheritedEnvironment();
            list = commandLine;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add("--action_env=" + (String)it);
            }
            list.addAll((List)destination$iv$iv);
            if (this.bazelInfo == null) {
                commandLine.addAll((Collection)this.targetCommandLine());
            } else {
                Path targetPatternFile = this.prepareTargetPatternFile(this.bazelInfo);
                commandLine.add("--target_pattern_file=" + targetPatternFile);
                finishCallback2 = (Function0)new Function0<Unit>(targetPatternFile){
                    final /* synthetic */ Path $targetPatternFile;
                    {
                        this.$targetPatternFile = $targetPatternFile;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            Files.deleteIfExists(this.$targetPatternFile);
                        }
                        catch (IOException e) {
                            Build.Companion.getLog().warn("Failed to delete target pattern file", (Throwable)e);
                        }
                    }
                };
            }
            return new BazelCommandExecutionDescriptor(commandLine, (Function0<Unit>)finishCallback2);
        }

        @NotNull
        public final Path prepareTargetPatternFile(@NotNull BazelInfo bazelInfo) {
            Intrinsics.checkNotNullParameter((Object)bazelInfo, (String)"bazelInfo");
            Path targetPatternFile = null;
            try {
                Label it;
                Collection collection;
                OpenOption[] $this$mapTo$iv$iv;
                Path path2;
                Path targetsDir = bazelInfo.dotBazelBsp().resolve("targets");
                Files.createDirectories(targetsDir, new FileAttribute[0]);
                Path it2 = path2 = Files.createTempFile(targetsDir, "targets-", "", new FileAttribute[0]);
                boolean bl = false;
                it2.toFile().deleteOnExit();
                targetPatternFile = path2;
                OpenOption[] $this$map$iv = (OpenOption[])this.getTargets();
                boolean $i$f$map = false;
                OpenOption[] openOptionArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    Label label = (Label)t;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.toString());
                }
                $this$map$iv = this.getExcludedTargets();
                collection = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    it = (Label)t;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add("-" + it);
                }
                List targetsList = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                Path path3 = targetPatternFile;
                Intrinsics.checkNotNull((Object)path3);
                Charset charset = Charsets.UTF_8;
                $this$mapTo$iv$iv = new OpenOption[]{StandardOpenOption.WRITE};
                Intrinsics.checkNotNullExpressionValue((Object)Files.write(path3, (Iterable<? extends CharSequence>)targetsList, charset, Arrays.copyOf($this$mapTo$iv$iv, $this$mapTo$iv$iv.length)), (String)"write(...)");
            }
            catch (IOException e) {
                Path path2 = targetPatternFile;
                if (path2 != null) {
                    Path it = path2;
                    boolean bl = false;
                    try {
                        boolean bl4 = Files.deleteIfExists(it);
                    }
                    catch (IOException deleteException) {
                        throw new IllegalStateException("Couldn't delete file after creation failure", deleteException);
                    }
                }
                throw new IllegalStateException("Couldn't create target pattern file", e);
            }
            Path path5 = targetPatternFile;
            Intrinsics.checkNotNull((Object)path5);
            return path5;
        }

        @Override
        public void addTargetsFromSpec(@NotNull TargetsSpec targetsSpec) {
            HasMultipleTargets.DefaultImpls.addTargetsFromSpec(this, targetsSpec);
        }

        @Override
        @NotNull
        public List<String> targetCommandLine() {
            return HasMultipleTargets.DefaultImpls.targetCommandLine(this);
        }

        static {
            Logger logger = LogManager.getLogger(BazelCommand.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            log = logger;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Build$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Logger getLog() {
                return log;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$CQuery;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasMultipleTargets;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "targets", "", "Lorg/jetbrains/bazel/label/Label;", "getTargets", "()Ljava/util/List;", "excludedTargets", "getExcludedTargets", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class CQuery
    extends BazelCommand
    implements HasMultipleTargets {
        @NotNull
        private final List<Label> targets;
        @NotNull
        private final List<Label> excludedTargets;

        public CQuery(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary);
            this.targets = new ArrayList();
            this.excludedTargets = new ArrayList();
        }

        @Override
        @NotNull
        public List<Label> getTargets() {
            return this.targets;
        }

        @Override
        @NotNull
        public List<Label> getExcludedTargets() {
            return this.excludedTargets;
        }

        @Override
        @NotNull
        public BazelCommandExecutionDescriptor buildExecutionDescriptor() {
            Object[] objectArray = new String[]{this.getBazelBinary()};
            List commandLine = CollectionsKt.mutableListOf((Object[])objectArray);
            commandLine.addAll((Collection)this.getStartupOptions());
            commandLine.add("cquery");
            commandLine.addAll((Collection)this.getOptions());
            commandLine.addAll((Collection)this.targetCommandLine());
            return new BazelCommandExecutionDescriptor(commandLine, null, 2, null);
        }

        @Override
        public void addTargetsFromSpec(@NotNull TargetsSpec targetsSpec) {
            HasMultipleTargets.DefaultImpls.addTargetsFromSpec(this, targetsSpec);
        }

        @Override
        @NotNull
        public List<String> targetCommandLine() {
            return HasMultipleTargets.DefaultImpls.targetCommandLine(this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Clean;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class Clean
    extends SimpleCommand {
        public Clean(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary, CollectionsKt.listOf((Object)"clean"));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Coverage;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasEnvironment;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasMultipleTargets;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasProgramArguments;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "targets", "", "Lorg/jetbrains/bazel/label/Label;", "getTargets", "()Ljava/util/List;", "excludedTargets", "getExcludedTargets", "environment", "", "getEnvironment", "()Ljava/util/Map;", "inheritedEnvironment", "getInheritedEnvironment", "programArguments", "getProgramArguments", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    @SourceDebugExtension(value={"SMAP\nBazelCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelCommand.kt\norg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Coverage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n126#2:346\n153#2,3:347\n1557#3:350\n1628#3,3:351\n1557#3:354\n1628#3,3:355\n*S KotlinDebug\n*F\n+ 1 BazelCommand.kt\norg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Coverage\n*L\n235#1:346\n235#1:347,3\n236#1:350\n236#1:351,3\n237#1:354\n237#1:355,3\n*E\n"})
    public static final class Coverage
    extends BazelCommand
    implements HasEnvironment,
    HasMultipleTargets,
    HasProgramArguments {
        @NotNull
        private final List<Label> targets;
        @NotNull
        private final List<Label> excludedTargets;
        @NotNull
        private final Map<String, String> environment;
        @NotNull
        private final List<String> inheritedEnvironment;
        @NotNull
        private final List<String> programArguments;

        public Coverage(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary);
            this.targets = new ArrayList();
            this.excludedTargets = new ArrayList();
            this.environment = new LinkedHashMap();
            this.inheritedEnvironment = new ArrayList();
            this.programArguments = new ArrayList();
        }

        @Override
        @NotNull
        public List<Label> getTargets() {
            return this.targets;
        }

        @Override
        @NotNull
        public List<Label> getExcludedTargets() {
            return this.excludedTargets;
        }

        @Override
        @NotNull
        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        @NotNull
        public List<String> getInheritedEnvironment() {
            return this.inheritedEnvironment;
        }

        @Override
        @NotNull
        public List<String> getProgramArguments() {
            return this.programArguments;
        }

        @Override
        @NotNull
        public BazelCommandExecutionDescriptor buildExecutionDescriptor() {
            String it;
            Collection collection;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object2 = new String[]{this.getBazelBinary()};
            List commandLine = CollectionsKt.mutableListOf((Object[])object2);
            commandLine.addAll((Collection)this.getStartupOptions());
            commandLine.add("coverage");
            commandLine.addAll((Collection)this.getOptions());
            object2 = this.getEnvironment();
            List list = commandLine;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                object = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)object.getKey();
                String value = (String)object.getValue();
                collection.add("--test_env=" + key + "=" + value);
            }
            list.addAll((List)destination$iv$iv);
            $this$map$iv = this.getInheritedEnvironment();
            list = commandLine;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                object = (String)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add("--test_env=" + it);
            }
            list.addAll((List)destination$iv$iv);
            $this$map$iv = this.getProgramArguments();
            list = commandLine;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add("--test_arg=" + it);
            }
            list.addAll((List)destination$iv$iv);
            commandLine.addAll((Collection)this.targetCommandLine());
            return new BazelCommandExecutionDescriptor(commandLine, null, 2, null);
        }

        @Override
        public void addTargetsFromSpec(@NotNull TargetsSpec targetsSpec) {
            HasMultipleTargets.DefaultImpls.addTargetsFromSpec(this, targetsSpec);
        }

        @Override
        @NotNull
        public List<String> targetCommandLine() {
            return HasMultipleTargets.DefaultImpls.targetCommandLine(this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$FileQuery;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "filePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class FileQuery
    extends SimpleCommand {
        public FileQuery(@NotNull String bazelBinary, @NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Object[] objectArray = new String[]{"query", filePath};
            super(bazelBinary, CollectionsKt.listOf((Object[])objectArray));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Info;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class Info
    extends SimpleCommand {
        public Info(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary, CollectionsKt.listOf((Object)"info"));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$MobileInstall;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasSingleTarget;", "bazelBinary", "", "target", "Lorg/jetbrains/bazel/label/Label;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/bazel/label/Label;)V", "getTarget", "()Lorg/jetbrains/bazel/label/Label;", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class MobileInstall
    extends BazelCommand
    implements HasSingleTarget {
        @NotNull
        private final Label target;

        public MobileInstall(@NotNull String bazelBinary, @NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(bazelBinary);
            this.target = target;
        }

        @Override
        @NotNull
        public Label getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public BazelCommandExecutionDescriptor buildExecutionDescriptor() {
            Object[] objectArray = new String[]{this.getBazelBinary()};
            List commandLine = CollectionsKt.mutableListOf((Object[])objectArray);
            commandLine.addAll((Collection)this.getStartupOptions());
            commandLine.add("mobile-install");
            commandLine.addAll((Collection)this.getOptions());
            commandLine.add(this.getTarget().toString());
            return new BazelCommandExecutionDescriptor(commandLine, null, 2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$ModDumpRepoMapping;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class ModDumpRepoMapping
    extends SimpleCommand {
        public ModDumpRepoMapping(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            Object[] objectArray = new String[]{"mod", "dump_repo_mapping"};
            super(bazelBinary, CollectionsKt.listOf((Object[])objectArray));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$ModGraph;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class ModGraph
    extends SimpleCommand {
        public ModGraph(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            Object[] objectArray = new String[]{"mod", "graph"};
            super(bazelBinary, CollectionsKt.listOf((Object[])objectArray));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$ModPath;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class ModPath
    extends SimpleCommand {
        public ModPath(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            Object[] objectArray = new String[]{"mod", "path"};
            super(bazelBinary, CollectionsKt.listOf((Object[])objectArray));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$ModShowRepo;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class ModShowRepo
    extends SimpleCommand {
        public ModShowRepo(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            Object[] objectArray = new String[]{"mod", "show_repo"};
            super(bazelBinary, CollectionsKt.listOf((Object[])objectArray));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Query;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasMultipleTargets;", "bazelBinary", "", "allowManualTargetsSync", "", "<init>", "(Ljava/lang/String;Z)V", "targets", "", "Lorg/jetbrains/bazel/label/Label;", "getTargets", "()Ljava/util/List;", "excludedTargets", "getExcludedTargets", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "queryString", "excludeManualTargetsQueryString", "targetString", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class Query
    extends BazelCommand
    implements HasMultipleTargets {
        private final boolean allowManualTargetsSync;
        @NotNull
        private final List<Label> targets;
        @NotNull
        private final List<Label> excludedTargets;

        public Query(@NotNull String bazelBinary, boolean allowManualTargetsSync) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary);
            this.allowManualTargetsSync = allowManualTargetsSync;
            this.targets = new ArrayList();
            this.excludedTargets = new ArrayList();
        }

        @Override
        @NotNull
        public List<Label> getTargets() {
            return this.targets;
        }

        @Override
        @NotNull
        public List<Label> getExcludedTargets() {
            return this.excludedTargets;
        }

        @Override
        @NotNull
        public BazelCommandExecutionDescriptor buildExecutionDescriptor() {
            Object[] objectArray = new String[]{this.getBazelBinary()};
            List commandLine = CollectionsKt.mutableListOf((Object[])objectArray);
            commandLine.addAll((Collection)this.getStartupOptions());
            commandLine.add("query");
            commandLine.addAll((Collection)this.getOptions());
            commandLine.add(this.queryString(this.allowManualTargetsSync));
            return new BazelCommandExecutionDescriptor(commandLine, null, 2, null);
        }

        @NotNull
        public final String queryString(boolean allowManualTargetsSync) {
            if (this.getTargets().isEmpty()) {
                return "";
            }
            String includesString = CollectionsKt.joinToString$default((Iterable)this.getTargets(), (CharSequence)" + ", null, null, (int)0, null, null, (int)62, null);
            String excludesString = CollectionsKt.joinToString$default((Iterable)this.getExcludedTargets(), (CharSequence)" - ", null, null, (int)0, null, null, (int)62, null);
            String targetString = ((CharSequence)excludesString).length() == 0 ? includesString : includesString + " - " + excludesString;
            return allowManualTargetsSync ? targetString : this.excludeManualTargetsQueryString(targetString);
        }

        private final String excludeManualTargetsQueryString(String targetString) {
            return OsFamily.Companion.inferFromSystem() == OsFamily.WINDOWS ? "attr('tags', '^((?!manual).)*$', " + targetString + ")" : "attr(\"tags\", \"^((?!manual).)*$\", " + targetString + ")";
        }

        @Override
        public void addTargetsFromSpec(@NotNull TargetsSpec targetsSpec) {
            HasMultipleTargets.DefaultImpls.addTargetsFromSpec(this, targetsSpec);
        }

        @Override
        @NotNull
        public List<String> targetCommandLine() {
            return HasMultipleTargets.DefaultImpls.targetCommandLine(this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012\u00a8\u0006#"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Run;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasProgramArguments;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasEnvironment;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasSingleTarget;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasWorkingDirectory;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasAdditionalBazelOptions;", "bazelBinary", "", "target", "Lorg/jetbrains/bazel/label/Label;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/bazel/label/Label;)V", "getTarget", "()Lorg/jetbrains/bazel/label/Label;", "programArguments", "", "getProgramArguments", "()Ljava/util/List;", "environment", "", "getEnvironment", "()Ljava/util/Map;", "inheritedEnvironment", "getInheritedEnvironment", "workingDirectory", "Ljava/nio/file/Path;", "getWorkingDirectory", "()Ljava/nio/file/Path;", "setWorkingDirectory", "(Ljava/nio/file/Path;)V", "additionalBazelOptions", "getAdditionalBazelOptions", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class Run
    extends BazelCommand
    implements HasProgramArguments,
    HasEnvironment,
    HasSingleTarget,
    HasWorkingDirectory,
    HasAdditionalBazelOptions {
        @NotNull
        private final Label target;
        @NotNull
        private final List<String> programArguments;
        @NotNull
        private final Map<String, String> environment;
        @NotNull
        private final List<String> inheritedEnvironment;
        @Nullable
        private Path workingDirectory;
        @NotNull
        private final List<String> additionalBazelOptions;

        public Run(@NotNull String bazelBinary, @NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(bazelBinary);
            this.target = target;
            this.programArguments = new ArrayList();
            this.environment = new LinkedHashMap();
            this.inheritedEnvironment = new ArrayList();
            this.additionalBazelOptions = new ArrayList();
        }

        @Override
        @NotNull
        public Label getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public List<String> getProgramArguments() {
            return this.programArguments;
        }

        @Override
        @NotNull
        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        @NotNull
        public List<String> getInheritedEnvironment() {
            return this.inheritedEnvironment;
        }

        @Override
        @Nullable
        public Path getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        public void setWorkingDirectory(@Nullable Path path2) {
            this.workingDirectory = path2;
        }

        @Override
        @NotNull
        public List<String> getAdditionalBazelOptions() {
            return this.additionalBazelOptions;
        }

        @Override
        @NotNull
        public BazelCommandExecutionDescriptor buildExecutionDescriptor() {
            List commandLine = new ArrayList();
            commandLine.add(this.getBazelBinary());
            commandLine.addAll((Collection)this.getStartupOptions());
            commandLine.add("run");
            commandLine.addAll((Collection)this.getOptions());
            commandLine.addAll((Collection)this.getAdditionalBazelOptions());
            commandLine.add(this.getTarget().toString());
            if (!((Collection)this.getProgramArguments()).isEmpty()) {
                commandLine.add("--");
                commandLine.addAll((Collection)this.getProgramArguments());
            }
            return new BazelCommandExecutionDescriptor(commandLine, null, 2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$ShutDown;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class ShutDown
    extends SimpleCommand {
        public ShutDown(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary, CollectionsKt.listOf((Object)"shutdown"));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "bazelBinary", "", "command", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getCommand", "()Ljava/util/List;", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static abstract class SimpleCommand
    extends BazelCommand {
        @NotNull
        private final List<String> command;

        public SimpleCommand(@NotNull String bazelBinary, @NotNull List<String> command2) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            Intrinsics.checkNotNullParameter(command2, (String)"command");
            super(bazelBinary);
            this.command = command2;
        }

        @NotNull
        public final List<String> getCommand() {
            return this.command;
        }

        @Override
        @NotNull
        public BazelCommandExecutionDescriptor buildExecutionDescriptor() {
            Object[] objectArray = new String[]{this.getBazelBinary()};
            List commandLine = CollectionsKt.mutableListOf((Object[])objectArray);
            commandLine.addAll((Collection)this.getStartupOptions());
            commandLine.addAll((Collection)this.command);
            commandLine.addAll((Collection)this.getOptions());
            return new BazelCommandExecutionDescriptor(commandLine, null, 2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Test;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasEnvironment;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasMultipleTargets;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasProgramArguments;", "Lorg/jetbrains/bsp/bazel/bazelrunner/HasAdditionalBazelOptions;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "targets", "", "Lorg/jetbrains/bazel/label/Label;", "getTargets", "()Ljava/util/List;", "excludedTargets", "getExcludedTargets", "environment", "", "getEnvironment", "()Ljava/util/Map;", "inheritedEnvironment", "getInheritedEnvironment", "programArguments", "getProgramArguments", "additionalBazelOptions", "getAdditionalBazelOptions", "buildExecutionDescriptor", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommandExecutionDescriptor;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    @SourceDebugExtension(value={"SMAP\nBazelCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelCommand.kt\norg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Test\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n126#2:346\n153#2,3:347\n1557#3:350\n1628#3,3:351\n1557#3:354\n1628#3,3:355\n*S KotlinDebug\n*F\n+ 1 BazelCommand.kt\norg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Test\n*L\n209#1:346\n209#1:347,3\n210#1:350\n210#1:351,3\n211#1:354\n211#1:355,3\n*E\n"})
    public static final class Test
    extends BazelCommand
    implements HasEnvironment,
    HasMultipleTargets,
    HasProgramArguments,
    HasAdditionalBazelOptions {
        @NotNull
        private final List<Label> targets;
        @NotNull
        private final List<Label> excludedTargets;
        @NotNull
        private final Map<String, String> environment;
        @NotNull
        private final List<String> inheritedEnvironment;
        @NotNull
        private final List<String> programArguments;
        @NotNull
        private final List<String> additionalBazelOptions;

        public Test(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary);
            this.targets = new ArrayList();
            this.excludedTargets = new ArrayList();
            this.environment = new LinkedHashMap();
            this.inheritedEnvironment = new ArrayList();
            this.programArguments = new ArrayList();
            this.additionalBazelOptions = new ArrayList();
        }

        @Override
        @NotNull
        public List<Label> getTargets() {
            return this.targets;
        }

        @Override
        @NotNull
        public List<Label> getExcludedTargets() {
            return this.excludedTargets;
        }

        @Override
        @NotNull
        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        @NotNull
        public List<String> getInheritedEnvironment() {
            return this.inheritedEnvironment;
        }

        @Override
        @NotNull
        public List<String> getProgramArguments() {
            return this.programArguments;
        }

        @Override
        @NotNull
        public List<String> getAdditionalBazelOptions() {
            return this.additionalBazelOptions;
        }

        @Override
        @NotNull
        public BazelCommandExecutionDescriptor buildExecutionDescriptor() {
            String it;
            Collection collection;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object2 = new String[]{this.getBazelBinary()};
            List commandLine = CollectionsKt.mutableListOf((Object[])object2);
            commandLine.addAll((Collection)this.getStartupOptions());
            commandLine.add("test");
            commandLine.addAll((Collection)this.getOptions());
            commandLine.addAll((Collection)this.getAdditionalBazelOptions());
            object2 = this.getEnvironment();
            List list = commandLine;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                object = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)object.getKey();
                String value = (String)object.getValue();
                collection.add("--test_env=" + key + "=" + value);
            }
            list.addAll((List)destination$iv$iv);
            $this$map$iv = this.getInheritedEnvironment();
            list = commandLine;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                object = (String)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add("--test_env=" + it);
            }
            list.addAll((List)destination$iv$iv);
            $this$map$iv = this.getProgramArguments();
            list = commandLine;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add("--test_arg=" + it);
            }
            list.addAll((List)destination$iv$iv);
            commandLine.addAll((Collection)this.targetCommandLine());
            return new BazelCommandExecutionDescriptor(commandLine, null, 2, null);
        }

        @Override
        public void addTargetsFromSpec(@NotNull TargetsSpec targetsSpec) {
            HasMultipleTargets.DefaultImpls.addTargetsFromSpec(this, targetsSpec);
        }

        @Override
        @NotNull
        public List<String> targetCommandLine() {
            return HasMultipleTargets.DefaultImpls.targetCommandLine(this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$Version;", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelCommand$SimpleCommand;", "bazelBinary", "", "<init>", "(Ljava/lang/String;)V", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class Version
    extends SimpleCommand {
        public Version(@NotNull String bazelBinary) {
            Intrinsics.checkNotNullParameter((Object)bazelBinary, (String)"bazelBinary");
            super(bazelBinary, CollectionsKt.listOf((Object)"version"));
        }
    }
}

