/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.bazelrunner;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelInfoResolver;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcessResult;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfo;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfoKt;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelRelease;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelInfoResolver;", "", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "<init>", "(Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;)V", "resolveBazelInfo", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "bazelInfoFromBazel", "parseBazelInfo", "bazelProcessResult", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelProcessResult;", "Companion", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
@SourceDebugExtension(value={"SMAP\nBazelInfoResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelInfoResolver.kt\norg/jetbrains/bsp/bazel/bazelrunner/BazelInfoResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1611#2,9:81\n1863#2:90\n1864#2:93\n1620#2:94\n1#3:91\n1#3:92\n*S KotlinDebug\n*F\n+ 1 BazelInfoResolver.kt\norg/jetbrains/bsp/bazel/bazelrunner/BazelInfoResolver\n*L\n36#1:81,9\n36#1:90\n36#1:93\n36#1:94\n36#1:92\n*E\n"})
public final class BazelInfoResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BazelRunner bazelRunner;
    @NotNull
    private static final Regex InfoLinePattern = new Regex("([\\w-]+): (.*)");

    public BazelInfoResolver(@NotNull BazelRunner bazelRunner) {
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        this.bazelRunner = bazelRunner;
    }

    @NotNull
    public final BazelInfo resolveBazelInfo(@NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        return this.bazelInfoFromBazel(cancelChecker);
    }

    private final BazelInfo bazelInfoFromBazel(CancelChecker cancelChecker) {
        BazelCommand command2 = BazelRunner.buildBazelCommand$default(this.bazelRunner, null, bazelInfoFromBazel.command.1.INSTANCE, 1, null);
        BazelProcessResult processResult = BazelRunner.runBazelCommand$default(this.bazelRunner, command2, null, false, null, false, 22, null).waitAndGetResult(cancelChecker, true);
        return this.parseBazelInfo(processResult);
    }

    /*
     * WARNING - void declaration
     */
    private final BazelInfo parseBazelInfo(BazelProcessResult bazelProcessResult) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = bazelProcessResult.getStdoutLines();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line = (String)element$iv$iv;
            boolean bl2 = false;
            if (InfoLinePattern.matchEntire((CharSequence)line) != null) {
                MatchResult it;
                boolean bl3 = false;
                pair = TuplesKt.to(it.getGroupValues().get(1), it.getGroupValues().get(2));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map outputMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        BazelRelease bazelRelease = BazelRelease.Companion.fromReleaseString(BazelInfoResolver.parseBazelInfo$extract(outputMap, this, bazelProcessResult, "release"));
        if (bazelRelease == null) {
            BazelRelease bazelRelease2;
            Path path2 = this.bazelRunner.getWorkspaceRoot();
            if (path2 != null) {
                Path it = path2;
                boolean bl = false;
                bazelRelease2 = BazelRelease.Companion.fromBazelVersionFile(it);
            } else {
                bazelRelease2 = null;
            }
            bazelRelease = BazelInfoKt.orLatestSupported(bazelRelease2);
        }
        BazelRelease bazelReleaseVersion = bazelRelease;
        String starlarkSemantics = BazelInfoResolver.parseBazelInfo$extract(outputMap, this, bazelProcessResult, "starlark-semantics");
        boolean isBzlModEnabled = StringsKt.contains$default((CharSequence)starlarkSemantics, (CharSequence)"enable_bzlmod=true", (boolean)false, (int)2, null) ? true : (StringsKt.contains$default((CharSequence)starlarkSemantics, (CharSequence)"enable_bzlmod=false", (boolean)false, (int)2, null) ? false : bazelReleaseVersion.getMajor() >= 7);
        boolean isWorkspaceEnabled = StringsKt.contains$default((CharSequence)starlarkSemantics, (CharSequence)"enable_workspace=true", (boolean)false, (int)2, null) ? true : (StringsKt.contains$default((CharSequence)starlarkSemantics, (CharSequence)"enable_workspace=false", (boolean)false, (int)2, null) ? false : bazelReleaseVersion.getMajor() <= 7);
        String string = BazelInfoResolver.parseBazelInfo$extract(outputMap, this, bazelProcessResult, "execution_root");
        Path path3 = Paths.get(BazelInfoResolver.parseBazelInfo$extract(outputMap, this, bazelProcessResult, "output_base"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        Path path4 = Paths.get(BazelInfoResolver.parseBazelInfo$extract(outputMap, this, bazelProcessResult, "workspace"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        return new BazelInfo(string, path3, path4, bazelReleaseVersion, isBzlModEnabled, isWorkspaceEnabled);
    }

    private static final String parseBazelInfo$extract(Map<String, String> outputMap, BazelInfoResolver this$0, BazelProcessResult $bazelProcessResult, String name) {
        String string = outputMap.get(name);
        if (string == null) {
            throw new IllegalStateException(("Failed to resolve " + name + " from bazel info in " + this$0.bazelRunner.getWorkspaceRoot() + ". Bazel Info output: '" + CollectionsKt.joinToString$default((Iterable)$bazelProcessResult.getStderrLines(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "'").toString());
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelInfoResolver$Companion;", "", "<init>", "()V", "InfoLinePattern", "Lkotlin/text/Regex;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

