/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.bazelrunner;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcessResult;
import org.jetbrains.bsp.bazel.bazelrunner.outputs.AsyncOutputProcessor;
import org.jetbrains.bsp.bazel.bazelrunner.outputs.OutputHandler;
import org.jetbrains.bsp.bazel.bazelrunner.outputs.OutputProcessor;
import org.jetbrains.bsp.bazel.bazelrunner.outputs.SyncOutputProcessor;
import org.jetbrains.bsp.bazel.commons.BazelStatus;
import org.jetbrains.bsp.bazel.commons.Format;
import org.jetbrains.bsp.bazel.commons.Stopwatch;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB=\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelProcess;", "", "process", "Ljava/lang/Process;", "logger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "serverPidFuture", "Ljava/util/concurrent/CompletableFuture;", "", "finishCallback", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/Process;Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;Ljava/util/concurrent/CompletableFuture;Lkotlin/jvm/functions/Function0;)V", "getProcess", "()Ljava/lang/Process;", "waitAndGetResult", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelProcessResult;", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "ensureAllOutputRead", "", "logCompletion", "exitCode", "", "duration", "Ljava/time/Duration;", "Companion", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
public final class BazelProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Process process;
    @Nullable
    private final BspClientLogger logger;
    @Nullable
    private final CompletableFuture<Long> serverPidFuture;
    @NotNull
    private final Function0<Unit> finishCallback;
    private static final Logger LOGGER = LogManager.getLogger(BazelProcess.class);

    public BazelProcess(@NotNull Process process, @Nullable BspClientLogger logger, @Nullable CompletableFuture<Long> serverPidFuture, @NotNull Function0<Unit> finishCallback2) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter(finishCallback2, (String)"finishCallback");
        this.process = process;
        this.logger = logger;
        this.serverPidFuture = serverPidFuture;
        this.finishCallback = finishCallback2;
    }

    public /* synthetic */ BazelProcess(Process process, BspClientLogger bspClientLogger, CompletableFuture completableFuture, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bspClientLogger = null;
        }
        if ((n & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        this(process, bspClientLogger, completableFuture, (Function0<Unit>)function0);
    }

    @NotNull
    public final Process getProcess() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final BazelProcessResult waitAndGetResult(@NotNull CancelChecker cancelChecker, boolean ensureAllOutputRead) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        try {
            OutputProcessor outputProcessor2;
            Stopwatch stopwatch = Stopwatch.Companion.start();
            if (this.logger != null) {
                if (ensureAllOutputRead) {
                    var5_4 = new OutputHandler[2];
                    var6_6 = this.logger;
                    var5_4[0] = new OutputHandler((BspClientLogger)var6_6){
                        final /* synthetic */ BspClientLogger $tmp0;
                        {
                            this.$tmp0 = $tmp0;
                        }

                        public final void onNextLine(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            this.$tmp0.message(p0);
                        }

                        public final Function<?> getFunctionDelegate() {
                            return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, BspClientLogger.class, "message", "message(Ljava/lang/String;)V", 0);
                        }

                        public final boolean equals(Object other) {
                            return other instanceof OutputHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                        }

                        public final int hashCode() {
                            return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                        }
                    };
                    var6_6 = LOGGER;
                    var5_4[1] = new OutputHandler((Logger)var6_6){
                        final /* synthetic */ Logger $tmp0;
                        {
                            this.$tmp0 = $tmp0;
                        }

                        public final void onNextLine(String p0) {
                            this.$tmp0.info(p0);
                        }

                        public final Function<?> getFunctionDelegate() {
                            return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Logger.class, "info", "info(Ljava/lang/String;)V", 0);
                        }

                        public final boolean equals(Object other) {
                            return other instanceof OutputHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                        }

                        public final int hashCode() {
                            return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                        }
                    };
                    outputProcessor2 = new SyncOutputProcessor(this.process, var5_4);
                } else {
                    var5_4 = new OutputHandler[2];
                    var6_6 = this.logger;
                    var5_4[0] = new OutputHandler((BspClientLogger)var6_6){
                        final /* synthetic */ BspClientLogger $tmp0;
                        {
                            this.$tmp0 = $tmp0;
                        }

                        public final void onNextLine(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            this.$tmp0.message(p0);
                        }

                        public final Function<?> getFunctionDelegate() {
                            return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, BspClientLogger.class, "message", "message(Ljava/lang/String;)V", 0);
                        }

                        public final boolean equals(Object other) {
                            return other instanceof OutputHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                        }

                        public final int hashCode() {
                            return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                        }
                    };
                    var6_6 = LOGGER;
                    var5_4[1] = new OutputHandler((Logger)var6_6){
                        final /* synthetic */ Logger $tmp0;
                        {
                            this.$tmp0 = $tmp0;
                        }

                        public final void onNextLine(String p0) {
                            this.$tmp0.info(p0);
                        }

                        public final Function<?> getFunctionDelegate() {
                            return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Logger.class, "info", "info(Ljava/lang/String;)V", 0);
                        }

                        public final boolean equals(Object other) {
                            return other instanceof OutputHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                        }

                        public final int hashCode() {
                            return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                        }
                    };
                    outputProcessor2 = new AsyncOutputProcessor(this.process, var5_4);
                }
            } else if (ensureAllOutputRead) {
                var5_4 = new OutputHandler[1];
                var6_6 = LOGGER;
                var5_4[0] = new OutputHandler((Logger)var6_6){
                    final /* synthetic */ Logger $tmp0;
                    {
                        this.$tmp0 = $tmp0;
                    }

                    public final void onNextLine(String p0) {
                        this.$tmp0.info(p0);
                    }

                    public final Function<?> getFunctionDelegate() {
                        return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Logger.class, "info", "info(Ljava/lang/String;)V", 0);
                    }

                    public final boolean equals(Object other) {
                        return other instanceof OutputHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                    }

                    public final int hashCode() {
                        return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                    }
                };
                outputProcessor2 = new SyncOutputProcessor(this.process, var5_4);
            } else {
                var5_4 = new OutputHandler[1];
                var6_6 = LOGGER;
                var5_4[0] = new OutputHandler((Logger)var6_6){
                    final /* synthetic */ Logger $tmp0;
                    {
                        this.$tmp0 = $tmp0;
                    }

                    public final void onNextLine(String p0) {
                        this.$tmp0.info(p0);
                    }

                    public final Function<?> getFunctionDelegate() {
                        return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Logger.class, "info", "info(Ljava/lang/String;)V", 0);
                    }

                    public final boolean equals(Object other) {
                        return other instanceof OutputHandler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                    }

                    public final int hashCode() {
                        return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                    }
                };
                outputProcessor2 = new AsyncOutputProcessor(this.process, var5_4);
            }
            OutputProcessor outputProcessor3 = outputProcessor2;
            int exitCode = outputProcessor3.waitForExit(cancelChecker, this.serverPidFuture, this.logger);
            Duration duration = stopwatch.stop();
            this.logCompletion(exitCode, duration);
            BazelProcessResult bazelProcessResult = new BazelProcessResult(outputProcessor3.getStdoutCollector(), outputProcessor3.getStderrCollector(), BazelStatus.Companion.fromExitCode(exitCode));
            return bazelProcessResult;
        }
        finally {
            this.finishCallback.invoke();
        }
    }

    public static /* synthetic */ BazelProcessResult waitAndGetResult$default(BazelProcess bazelProcess, CancelChecker cancelChecker, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return bazelProcess.waitAndGetResult(cancelChecker, bl);
    }

    private final void logCompletion(int exitCode, Duration duration) {
        block0: {
            BspClientLogger bspClientLogger = this.logger;
            if (bspClientLogger == null) break block0;
            Object[] objectArray = new Object[]{Format.INSTANCE.duration(duration), exitCode};
            bspClientLogger.message("Command completed in %s (exit code %d)", objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/BazelProcess$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/Logger;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

