/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.bazelrunner;

import com.google.gson.Gson;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcessResult;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.bazelrunner.ModuleOutputParser;
import org.jetbrains.bsp.bazel.bazelrunner.ShowRepoResult;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/ModuleResolver;", "", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "moduleOutputParser", "Lorg/jetbrains/bsp/bazel/bazelrunner/ModuleOutputParser;", "<init>", "(Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;Lorg/jetbrains/bsp/bazel/bazelrunner/ModuleOutputParser;)V", "resolveModule", "Lorg/jetbrains/bsp/bazel/bazelrunner/ShowRepoResult;", "moduleName", "", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "getRepoMapping", "", "canonicalRepoName", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner-bazelrunner"})
public final class ModuleResolver {
    @NotNull
    private final BazelRunner bazelRunner;
    @NotNull
    private final ModuleOutputParser moduleOutputParser;
    @NotNull
    private final Gson gson;

    public ModuleResolver(@NotNull BazelRunner bazelRunner, @NotNull ModuleOutputParser moduleOutputParser) {
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Intrinsics.checkNotNullParameter((Object)moduleOutputParser, (String)"moduleOutputParser");
        this.bazelRunner = bazelRunner;
        this.moduleOutputParser = moduleOutputParser;
        this.gson = new Gson();
    }

    @NotNull
    public final ShowRepoResult resolveModule(@NotNull String moduleName, @NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        BazelCommand command2 = BazelRunner.buildBazelCommand$default(this.bazelRunner, null, (Function1)new Function1<BazelRunner.CommandBuilder, BazelCommand>(moduleName){
            final /* synthetic */ String $moduleName;
            {
                this.$moduleName = $moduleName;
                super(1);
            }

            public final BazelCommand invoke(BazelRunner.CommandBuilder $this$buildBazelCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$buildBazelCommand, (String)"$this$buildBazelCommand");
                return $this$buildBazelCommand.showRepo((Function1<? super BazelCommand.ModShowRepo, Unit>)((Function1)new Function1<BazelCommand.ModShowRepo, Unit>(this.$moduleName){
                    final /* synthetic */ String $moduleName;
                    {
                        this.$moduleName = $moduleName;
                        super(1);
                    }

                    public final void invoke(BazelCommand.ModShowRepo $this$showRepo) {
                        Intrinsics.checkNotNullParameter((Object)$this$showRepo, (String)"$this$showRepo");
                        $this$showRepo.getOptions().add(this.$moduleName);
                    }
                }));
            }
        }, 1, null);
        BazelProcessResult processResult = BazelRunner.runBazelCommand$default(this.bazelRunner, command2, null, false, null, false, 22, null).waitAndGetResult(cancelChecker, true);
        return this.moduleOutputParser.parseShowRepoResult(processResult);
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @NotNull
    public final Map<String, String> getRepoMapping(@NotNull String canonicalRepoName, @NotNull CancelChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)canonicalRepoName, (String)"canonicalRepoName");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        if (StringsKt.startsWith$default((CharSequence)canonicalRepoName, (char)'@', (boolean)false, (int)2, null)) {
            throw new IllegalStateException(("Canonical repo name cannot contain '@' characters: " + canonicalRepoName).toString());
        }
        BazelCommand command2 = BazelRunner.buildBazelCommand$default(this.bazelRunner, null, (Function1)new Function1<BazelRunner.CommandBuilder, BazelCommand>(canonicalRepoName){
            final /* synthetic */ String $canonicalRepoName;
            {
                this.$canonicalRepoName = $canonicalRepoName;
                super(1);
            }

            public final BazelCommand invoke(BazelRunner.CommandBuilder $this$buildBazelCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$buildBazelCommand, (String)"$this$buildBazelCommand");
                return $this$buildBazelCommand.dumpRepoMapping((Function1<? super BazelCommand.ModDumpRepoMapping, Unit>)((Function1)new Function1<BazelCommand.ModDumpRepoMapping, Unit>(this.$canonicalRepoName){
                    final /* synthetic */ String $canonicalRepoName;
                    {
                        this.$canonicalRepoName = $canonicalRepoName;
                        super(1);
                    }

                    public final void invoke(BazelCommand.ModDumpRepoMapping $this$dumpRepoMapping) {
                        Intrinsics.checkNotNullParameter((Object)$this$dumpRepoMapping, (String)"$this$dumpRepoMapping");
                        $this$dumpRepoMapping.getOptions().add(this.$canonicalRepoName);
                    }
                }));
            }
        }, 1, null);
        BazelProcessResult processResult = BazelRunner.runBazelCommand$default(this.bazelRunner, command2, null, false, null, false, 22, null).waitAndGetResult(cancelChecker, true);
        if (processResult.isNotSuccess()) {
            throw new IllegalStateException(("dumpRepoMapping failed with output: " + processResult.getStdout()).toString());
        }
        String output = processResult.getStdout();
        Object object = this.gson.fromJson(output, Map.class);
        Map map = object instanceof Map ? (Map)object : null;
        if (map == null) {
            throw new IllegalStateException(("Failed to parse repo mapping from bazel. Bazel output:\n" + output).toString());
        }
        return map;
    }
}

