/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.bazelrunner.outputs;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.bazelrunner.outputs.OutputCollector;
import org.jetbrains.bsp.bazel.bazelrunner.outputs.OutputHandler;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH$J)\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010 J(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\b\u0010(\u001a\u0004\u0018\u00010)J\u0019\u0010*\u001a\u0004\u0018\u00010'*\b\u0012\u0004\u0012\u00020'0&H\u0002\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u001e\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006,"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/outputs/OutputProcessor;", "", "process", "Ljava/lang/Process;", "loggers", "", "Lorg/jetbrains/bsp/bazel/bazelrunner/outputs/OutputHandler;", "<init>", "(Ljava/lang/Process;[Lorg/jetbrains/bsp/bazel/bazelrunner/outputs/OutputHandler;)V", "stdoutCollector", "Lorg/jetbrains/bsp/bazel/bazelrunner/outputs/OutputCollector;", "getStdoutCollector", "()Lorg/jetbrains/bsp/bazel/bazelrunner/outputs/OutputCollector;", "stderrCollector", "getStderrCollector", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/ExecutorService;", "runningProcessors", "", "Ljava/util/concurrent/Future;", "getRunningProcessors", "()Ljava/util/List;", "shutdown", "", "isRunning", "", "start", "inputStream", "Ljava/io/InputStream;", "handlers", "(Ljava/io/InputStream;[Lorg/jetbrains/bsp/bazel/bazelrunner/outputs/OutputHandler;)V", "waitForExit", "", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "serverPidFuture", "Ljava/util/concurrent/CompletableFuture;", "", "logger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "getOrNull", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Long;", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner_outputs-outputs"})
@SourceDebugExtension(value={"SMAP\nOutputProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutputProcessor.kt\norg/jetbrains/bsp/bazel/bazelrunner/outputs/OutputProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public abstract class OutputProcessor {
    @NotNull
    private final Process process;
    @NotNull
    private final OutputCollector stdoutCollector;
    @NotNull
    private final OutputCollector stderrCollector;
    private final ExecutorService executorService;
    @NotNull
    private final List<Future<?>> runningProcessors;

    public OutputProcessor(@NotNull Process process, OutputHandler ... loggers) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)loggers, (String)"loggers");
        this.process = process;
        this.stdoutCollector = new OutputCollector();
        this.stderrCollector = new OutputCollector();
        this.executorService = Executors.newCachedThreadPool();
        this.runningProcessors = new ArrayList();
        InputStream inputStream2 = this.process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)this.stdoutCollector);
        spreadBuilder.addSpread((Object)loggers);
        this.start(inputStream2, (OutputHandler[])spreadBuilder.toArray((Object[])new OutputHandler[spreadBuilder.size()]));
        InputStream inputStream3 = this.process.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"getErrorStream(...)");
        spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)this.stderrCollector);
        spreadBuilder.addSpread((Object)loggers);
        this.start(inputStream3, (OutputHandler[])spreadBuilder.toArray((Object[])new OutputHandler[spreadBuilder.size()]));
    }

    @NotNull
    public final OutputCollector getStdoutCollector() {
        return this.stdoutCollector;
    }

    @NotNull
    public final OutputCollector getStderrCollector() {
        return this.stderrCollector;
    }

    @NotNull
    protected final List<Future<?>> getRunningProcessors() {
        return this.runningProcessors;
    }

    protected void shutdown() {
        this.executorService.shutdown();
    }

    protected abstract boolean isRunning();

    protected final void start(@NotNull InputStream inputStream2, OutputHandler ... handlers) {
        Future<?> future;
        Intrinsics.checkNotNullParameter((Object)inputStream2, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)handlers, (String)"handlers");
        Runnable runnable2 = new Runnable(inputStream2, this, handlers){
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ OutputProcessor this$0;
            final /* synthetic */ OutputHandler[] $handlers;
            {
                this.$inputStream = $inputStream;
                this.this$0 = $receiver;
                this.$handlers = $handlers;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                try {
                    Closeable closeable = new BufferedReader(new InputStreamReader(this.$inputStream, Charsets.UTF_8));
                    OutputProcessor outputProcessor2 = this.this$0;
                    OutputHandler[] outputHandlerArray = this.$handlers;
                    Throwable throwable = null;
                    try {
                        BufferedReader reader2 = (BufferedReader)closeable;
                        boolean bl = false;
                        String prevLine = null;
                        while (!Thread.currentThread().isInterrupted()) {
                            String string;
                            if (reader2.readLine() == null) {
                                return;
                            }
                            String line = string;
                            if (Intrinsics.areEqual((Object)line, prevLine)) continue;
                            prevLine = line;
                            if (!outputProcessor2.isRunning()) break;
                            OutputHandler[] $this$forEach$iv = outputHandlerArray;
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int i = 0; i < n; ++i) {
                                OutputHandler element$iv;
                                OutputHandler it = element$iv = $this$forEach$iv[i];
                                boolean bl2 = false;
                                it.onNextLine(line);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    throw new RuntimeException(e);
                }
            }
        };
        Future<?> it = future = this.executorService.submit(runnable2);
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        this.runningProcessors.add(it);
    }

    public final int waitForExit(@NotNull CancelChecker cancelChecker, @Nullable CompletableFuture<Long> serverPidFuture, @Nullable BspClientLogger logger) {
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        boolean isFinished = false;
        while (!isFinished) {
            Long l;
            isFinished = this.process.waitFor(500L, TimeUnit.MILLISECONDS);
            if (!cancelChecker.isCanceled()) continue;
            this.process.destroy();
            if (serverPidFuture != null && (l = this.getOrNull(serverPidFuture)) != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                Runtime.getRuntime().exec("kill -SIGINT " + it).waitFor();
                continue;
            }
            BspClientLogger bspClientLogger = logger;
            if (bspClientLogger == null) continue;
            bspClientLogger.error("Could not cancel the task. Bazel server needs to be interrupted manually.");
        }
        int exitCode = this.process.waitFor();
        this.shutdown();
        return exitCode;
    }

    private final Long getOrNull(CompletableFuture<Long> $this$getOrNull) {
        Long l;
        try {
            l = $this$getOrNull.get(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            l = null;
        }
        return l;
    }
}

