/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.bazelrunner.utils;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelRelease;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\u0005J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003JE\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "", "execRoot", "", "outputBase", "Ljava/nio/file/Path;", "workspaceRoot", "release", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelRelease;", "isBzlModEnabled", "", "isWorkspaceEnabled", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelRelease;ZZ)V", "getExecRoot", "()Ljava/lang/String;", "getOutputBase", "()Ljava/nio/file/Path;", "getWorkspaceRoot", "getRelease", "()Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelRelease;", "()Z", "shouldUseInjectRepository", "dotBazelBsp", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner_utils-utils"})
public final class BazelInfo {
    @NotNull
    private final String execRoot;
    @NotNull
    private final Path outputBase;
    @NotNull
    private final Path workspaceRoot;
    @NotNull
    private final BazelRelease release;
    private final boolean isBzlModEnabled;
    private final boolean isWorkspaceEnabled;

    public BazelInfo(@NotNull String execRoot, @NotNull Path outputBase, @NotNull Path workspaceRoot, @NotNull BazelRelease release, boolean isBzlModEnabled, boolean isWorkspaceEnabled) {
        Intrinsics.checkNotNullParameter((Object)execRoot, (String)"execRoot");
        Intrinsics.checkNotNullParameter((Object)outputBase, (String)"outputBase");
        Intrinsics.checkNotNullParameter((Object)workspaceRoot, (String)"workspaceRoot");
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        this.execRoot = execRoot;
        this.outputBase = outputBase;
        this.workspaceRoot = workspaceRoot;
        this.release = release;
        this.isBzlModEnabled = isBzlModEnabled;
        this.isWorkspaceEnabled = isWorkspaceEnabled;
    }

    @NotNull
    public final String getExecRoot() {
        return this.execRoot;
    }

    @NotNull
    public final Path getOutputBase() {
        return this.outputBase;
    }

    @NotNull
    public final Path getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    @NotNull
    public final BazelRelease getRelease() {
        return this.release;
    }

    public final boolean isBzlModEnabled() {
        return this.isBzlModEnabled;
    }

    public final boolean isWorkspaceEnabled() {
        return this.isWorkspaceEnabled;
    }

    public final boolean shouldUseInjectRepository() {
        return this.isBzlModEnabled && this.release.getMajor() >= 8;
    }

    @NotNull
    public final Path dotBazelBsp() {
        Path path2 = this.workspaceRoot.resolve(".bazelbsp");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @NotNull
    public final String component1() {
        return this.execRoot;
    }

    @NotNull
    public final Path component2() {
        return this.outputBase;
    }

    @NotNull
    public final Path component3() {
        return this.workspaceRoot;
    }

    @NotNull
    public final BazelRelease component4() {
        return this.release;
    }

    public final boolean component5() {
        return this.isBzlModEnabled;
    }

    public final boolean component6() {
        return this.isWorkspaceEnabled;
    }

    @NotNull
    public final BazelInfo copy(@NotNull String execRoot, @NotNull Path outputBase, @NotNull Path workspaceRoot, @NotNull BazelRelease release, boolean isBzlModEnabled, boolean isWorkspaceEnabled) {
        Intrinsics.checkNotNullParameter((Object)execRoot, (String)"execRoot");
        Intrinsics.checkNotNullParameter((Object)outputBase, (String)"outputBase");
        Intrinsics.checkNotNullParameter((Object)workspaceRoot, (String)"workspaceRoot");
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        return new BazelInfo(execRoot, outputBase, workspaceRoot, release, isBzlModEnabled, isWorkspaceEnabled);
    }

    public static /* synthetic */ BazelInfo copy$default(BazelInfo bazelInfo, String string, Path path2, Path path3, BazelRelease bazelRelease, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            string = bazelInfo.execRoot;
        }
        if ((n & 2) != 0) {
            path2 = bazelInfo.outputBase;
        }
        if ((n & 4) != 0) {
            path3 = bazelInfo.workspaceRoot;
        }
        if ((n & 8) != 0) {
            bazelRelease = bazelInfo.release;
        }
        if ((n & 0x10) != 0) {
            bl = bazelInfo.isBzlModEnabled;
        }
        if ((n & 0x20) != 0) {
            bl2 = bazelInfo.isWorkspaceEnabled;
        }
        return bazelInfo.copy(string, path2, path3, bazelRelease, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "BazelInfo(execRoot=" + this.execRoot + ", outputBase=" + this.outputBase + ", workspaceRoot=" + this.workspaceRoot + ", release=" + this.release + ", isBzlModEnabled=" + this.isBzlModEnabled + ", isWorkspaceEnabled=" + this.isWorkspaceEnabled + ")";
    }

    public int hashCode() {
        int result2 = this.execRoot.hashCode();
        result2 = result2 * 31 + ((Object)this.outputBase).hashCode();
        result2 = result2 * 31 + ((Object)this.workspaceRoot).hashCode();
        result2 = result2 * 31 + this.release.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isBzlModEnabled);
        result2 = result2 * 31 + Boolean.hashCode(this.isWorkspaceEnabled);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BazelInfo)) {
            return false;
        }
        BazelInfo bazelInfo = (BazelInfo)other;
        if (!Intrinsics.areEqual((Object)this.execRoot, (Object)bazelInfo.execRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outputBase, (Object)bazelInfo.outputBase)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workspaceRoot, (Object)bazelInfo.workspaceRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.release, (Object)bazelInfo.release)) {
            return false;
        }
        if (this.isBzlModEnabled != bazelInfo.isBzlModEnabled) {
            return false;
        }
        return this.isWorkspaceEnabled == bazelInfo.isWorkspaceEnabled;
    }
}

