/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.bazelrunner.utils;

import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelRelease;", "", "major", "", "<init>", "(I)V", "getMajor", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner_utils-utils"})
public final class BazelRelease {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    @NotNull
    private static final BazelRelease LATEST_SUPPORTED_MAJOR = new BazelRelease(6);
    @NotNull
    private static final Regex BAZEL_VERSION_MAJOR_REGEX = new Regex("^\\d+");
    @NotNull
    private static final Regex VERSION_REGEX = new Regex("(?<=release )\\d+(?=[0-9.]*)");

    public BazelRelease(int major) {
        this.major = major;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int component1() {
        return this.major;
    }

    @NotNull
    public final BazelRelease copy(int major) {
        return new BazelRelease(major);
    }

    public static /* synthetic */ BazelRelease copy$default(BazelRelease bazelRelease, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = bazelRelease.major;
        }
        return bazelRelease.copy(n);
    }

    @NotNull
    public String toString() {
        return "BazelRelease(major=" + this.major + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.major);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BazelRelease)) {
            return false;
        }
        BazelRelease bazelRelease = (BazelRelease)other;
        return this.major == bazelRelease.major;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0002R\u0014\u0010\r\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelRelease$Companion;", "", "<init>", "()V", "fromReleaseString", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelRelease;", "versionString", "", "fromBazelVersionFile", "workspacePath", "Ljava/nio/file/Path;", "toBazelRelease", "Lkotlin/text/MatchResult;", "LATEST_SUPPORTED_MAJOR", "getLATEST_SUPPORTED_MAJOR$server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner_utils_utils", "()Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelRelease;", "BAZEL_VERSION_MAJOR_REGEX", "Lkotlin/text/Regex;", "VERSION_REGEX", "server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner_utils-utils"})
    @SourceDebugExtension(value={"SMAP\nBazelInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelInfo.kt\norg/jetbrains/bsp/bazel/bazelrunner/utils/BazelRelease$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BazelRelease fromReleaseString(@NotNull String versionString) {
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            MatchResult matchResult = Regex.find$default((Regex)VERSION_REGEX, (CharSequence)versionString, (int)0, (int)2, null);
            return matchResult != null ? this.toBazelRelease(matchResult) : null;
        }

        @Nullable
        public final BazelRelease fromBazelVersionFile(@NotNull Path workspacePath) {
            Path path2;
            Intrinsics.checkNotNullParameter((Object)workspacePath, (String)"workspacePath");
            Path it = path2 = workspacePath.resolve(".bazelversion");
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Path path3 = Files.isReadable(it) ? path2 : null;
            String string = path3 != null ? PathsKt.readText$default((Path)path3, null, (int)1, null) : null;
            if (string == null) {
                string = "";
            }
            String versionString = string;
            MatchResult matchResult = Regex.find$default((Regex)BAZEL_VERSION_MAJOR_REGEX, (CharSequence)versionString, (int)0, (int)2, null);
            return matchResult != null ? this.toBazelRelease(matchResult) : null;
        }

        private final BazelRelease toBazelRelease(MatchResult $this$toBazelRelease) {
            return new BazelRelease(Integer.parseInt($this$toBazelRelease.getValue()));
        }

        @NotNull
        public final BazelRelease getLATEST_SUPPORTED_MAJOR$server_bazelrunner_src_main_kotlin_org_jetbrains_bsp_bazel_bazelrunner_utils_utils() {
            return LATEST_SUPPORTED_MAJOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

