/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.commons;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/bsp/bazel/commons/Format;", "", "<init>", "()V", "duration", "", "Ljava/time/Duration;", "server_commons_src_main_kotlin_org_jetbrains_bsp_bazel_commons-commons"})
public final class Format {
    @NotNull
    public static final Format INSTANCE = new Format();

    private Format() {
    }

    @NotNull
    public final String duration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        if (duration.toSeconds() == 0L) {
            return duration.toMillis() + "ms";
        }
        if (duration.toMinutes() == 0L) {
            DecimalFormat df = new DecimalFormat("0.#", DecimalFormatSymbols.getInstance(Locale.US));
            return df.format((double)duration.toMillis() / (double)1000) + "s";
        }
        String minutes = duration.toMinutes() + "m";
        if (duration.toSecondsPart() > 0 || duration.toMillisPart() > 0) {
            double millisAsSeconds = (double)duration.toMillisPart() / (double)1000;
            double seconds = millisAsSeconds + (double)duration.toSecondsPart();
            return minutes + " " + MathKt.roundToInt((double)seconds) + "s";
        }
        return minutes;
    }
}

