/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.install;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.server.bsp.utils.FileUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0004J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002J#\u0010\u000e\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u0002H\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J \u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0018\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/bsp/bazel/install/EnvironmentCreator;", "", "projectRootDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "create", "", "createDotBsp", "discoveryDetails", "Lch/epfl/scala/bsp4j/BspConnectionDetails;", "createDotBazelBsp", "createBspDiscoveryDetailsFile", "dotBspDir", "writeJsonToFile", "T", "destinationPath", "data", "(Ljava/nio/file/Path;Ljava/lang/Object;)V", "createDotBazelBspFiles", "dotBazelBspDir", "copyAspects", "createEmptyBuildFile", "copyAspectsFromResources", "aspectsJarPath", "", "copyFileTree", "source", "destination", "copyUsingRelativePath", "sourcePrefix", "deleteExtraFileUsingRelativePath", "destinationPrefix", "createDir", "rootDir", "name", "server_install_src_main_kotlin_org_jetbrains_bsp_bazel_install-install"})
public abstract class EnvironmentCreator {
    @NotNull
    private final Path projectRootDir;

    public EnvironmentCreator(@NotNull Path projectRootDir) {
        Intrinsics.checkNotNullParameter((Object)projectRootDir, (String)"projectRootDir");
        this.projectRootDir = projectRootDir;
    }

    public abstract void create();

    protected final void createDotBsp(@NotNull BspConnectionDetails discoveryDetails) {
        Intrinsics.checkNotNullParameter((Object)discoveryDetails, (String)"discoveryDetails");
        Path dir = this.createDir(this.projectRootDir, ".bsp");
        this.createBspDiscoveryDetailsFile(dir, discoveryDetails);
    }

    @NotNull
    protected final Path createDotBazelBsp() {
        Path bazelBspDir = this.createDir(this.projectRootDir, ".bazelbsp");
        this.createDotBazelBspFiles(bazelBspDir);
        return bazelBspDir;
    }

    private final void createBspDiscoveryDetailsFile(Path dotBspDir, BspConnectionDetails discoveryDetails) {
        Path destinationBspDiscoveryFilePath = dotBspDir.resolve("bazelbsp.json");
        Intrinsics.checkNotNull((Object)destinationBspDiscoveryFilePath);
        this.writeJsonToFile(destinationBspDiscoveryFilePath, discoveryDetails);
    }

    private final <T> void writeJsonToFile(Path destinationPath, T data) {
        String fileContent = new GsonBuilder().setPrettyPrinting().create().toJson(data);
        Files.writeString(destinationPath, (CharSequence)fileContent, new OpenOption[0]);
    }

    private final void createDotBazelBspFiles(Path dotBazelBspDir) {
        this.copyAspects(dotBazelBspDir);
        this.createEmptyBuildFile(dotBazelBspDir);
    }

    private final void copyAspects(Path dotBazelBspDir) {
        Path destinationAspectsPath = dotBazelBspDir.resolve("aspects");
        Intrinsics.checkNotNull((Object)destinationAspectsPath);
        this.copyAspectsFromResources("/aspects", destinationAspectsPath);
    }

    private final void createEmptyBuildFile(Path dotBazelBspDir) {
        Path destinationBuildFilePath = dotBazelBspDir.resolve("BUILD");
        Path destinationWorkspaceFilePath = dotBazelBspDir.resolve("WORKSPACE");
        destinationBuildFilePath.toFile().createNewFile();
        destinationWorkspaceFilePath.toFile().createNewFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyAspectsFromResources(String aspectsJarPath, Path destinationPath) {
        URL uRL = this.getClass().getResource(aspectsJarPath);
        if (uRL != null) {
            URL it = uRL;
            boolean bl = false;
            Closeable closeable = FileSystems.newFileSystem(it.toURI(), MapsKt.emptyMap());
            Throwable throwable = null;
            try {
                FileSystem fileSystem = (FileSystem)closeable;
                boolean bl2 = false;
                Path path2 = fileSystem.getPath(aspectsJarPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
                this.copyFileTree(path2, destinationPath);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            throw new IllegalStateException("Missing aspects resource".toString());
        }
    }

    private final void copyFileTree(Path source, Path destination) {
        Function1 function1 = (Function1)new Function1<Path, Unit>(this, source, destination){
            final /* synthetic */ EnvironmentCreator this$0;
            final /* synthetic */ Path $source;
            final /* synthetic */ Path $destination;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                this.$destination = $destination;
                super(1);
            }

            public final void invoke(Path it) {
                Intrinsics.checkNotNull((Object)it);
                EnvironmentCreator.access$copyUsingRelativePath(this.this$0, this.$source, it, this.$destination);
            }
        };
        Files.walk(source, new FileVisitOption[0]).forEach(new Consumer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void accept(Object p0) {
                this.function.invoke(p0);
            }
        });
        function1 = (Function1)new Function1<Path, Unit>(this, source, destination){
            final /* synthetic */ EnvironmentCreator this$0;
            final /* synthetic */ Path $source;
            final /* synthetic */ Path $destination;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                this.$destination = $destination;
                super(1);
            }

            public final void invoke(Path it) {
                Intrinsics.checkNotNull((Object)it);
                EnvironmentCreator.access$deleteExtraFileUsingRelativePath(this.this$0, this.$source, it, this.$destination);
            }
        };
        Files.walk(destination, new FileVisitOption[0]).forEach(new /* invalid duplicate definition of identical inner class */);
    }

    private final void copyUsingRelativePath(Path sourcePrefix, Path source, Path destination) {
        String sourceRelativePath = ((Object)sourcePrefix.relativize(source)).toString();
        Path destinationAbsolutePath = destination.resolve(sourceRelativePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(source, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Intrinsics.checkNotNull((Object)destinationAbsolutePath);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(destinationAbsolutePath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Files.deleteIfExists(destinationAbsolutePath);
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory(destinationAbsolutePath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectory(...)");
            }
        } else {
            Intrinsics.checkNotNull((Object)destinationAbsolutePath);
            FileUtils.INSTANCE.writeIfDifferent(destinationAbsolutePath, PathsKt.readText$default((Path)source, null, (int)1, null));
        }
    }

    private final void deleteExtraFileUsingRelativePath(Path source, Path destination, Path destinationPrefix) {
        String destinationRelativePath = ((Object)destinationPrefix.relativize(destination)).toString();
        Path sourceAbsolutePath = source.resolve(destinationRelativePath);
        if (Intrinsics.areEqual((Object)destinationRelativePath, (Object)"extensions.bzl")) {
            return;
        }
        Intrinsics.checkNotNull((Object)sourceAbsolutePath);
        Path templateAbsolutePath = sourceAbsolutePath.resolveSibling(PathsKt.getName((Path)sourceAbsolutePath) + ".template");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(sourceAbsolutePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Intrinsics.checkNotNull((Object)templateAbsolutePath);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.notExists(templateAbsolutePath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                PathsKt.deleteRecursively((Path)destination);
            }
        }
    }

    private final Path createDir(Path rootDir, String name) {
        Path dir = rootDir.resolve(name);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        Intrinsics.checkNotNull((Object)dir);
        return dir;
    }

    public static final /* synthetic */ void access$copyUsingRelativePath(EnvironmentCreator $this, Path sourcePrefix, Path source, Path destination) {
        $this.copyUsingRelativePath(sourcePrefix, source, destination);
    }

    public static final /* synthetic */ void access$deleteExtraFileUsingRelativePath(EnvironmentCreator $this, Path source, Path destination, Path destinationPrefix) {
        $this.deleteExtraFileUsingRelativePath(source, destination, destinationPrefix);
    }
}

