/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.install;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.install.BazelBspEnvironmentCreator;
import org.jetbrains.bsp.bazel.install.BspConnectionDetailsCreator;
import org.jetbrains.bsp.bazel.install.InstallationContextProvider;
import org.jetbrains.bsp.bazel.install.cli.CliOptions;
import org.jetbrains.bsp.bazel.install.cli.CliOptionsProvider;
import org.jetbrains.bsp.bazel.install.installationcontext.InstallationContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bsp/bazel/install/Install;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "runInstall", "cliOptions", "Lorg/jetbrains/bsp/bazel/install/cli/CliOptions;", "createEnvironment", "printSuccess", "workspaceRootDir", "Ljava/nio/file/Path;", "server_install_src_main_kotlin_org_jetbrains_bsp_bazel_install-install"})
public final class Install {
    @NotNull
    public static final Install INSTANCE = new Install();

    private Install() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        CliOptionsProvider cliOptionsProvider = new CliOptionsProvider(args);
        CliOptions cliOptions = cliOptionsProvider.getOptions();
        if (cliOptions.getHelpCliOptions().isHelpOptionUsed()) {
            cliOptions.getHelpCliOptions().getPrintHelp().invoke();
        } else {
            INSTANCE.runInstall(cliOptions);
        }
    }

    private final void runInstall(CliOptions cliOptions) {
        InstallationContextProvider.INSTANCE.generateAndSaveProjectViewFileIfNeeded(cliOptions);
        this.createEnvironment(cliOptions);
        this.printSuccess(cliOptions.getWorkspaceRootDir());
    }

    private final void createEnvironment(CliOptions cliOptions) {
        InstallationContext installationContext = InstallationContextProvider.INSTANCE.createInstallationContext(cliOptions);
        BspConnectionDetails bspConnectionDetails = new BspConnectionDetailsCreator(installationContext, true).create();
        BazelBspEnvironmentCreator environmentCreator = new BazelBspEnvironmentCreator(cliOptions.getWorkspaceRootDir(), bspConnectionDetails);
        environmentCreator.create();
    }

    private final void printSuccess(Path workspaceRootDir) {
        Path absoluteDirWhereServerWasInstalledIn = workspaceRootDir.toAbsolutePath().normalize();
        System.out.println((Object)("Bazel BSP server installed in '" + absoluteDirWhereServerWasInstalledIn + "'."));
    }
}

