/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.install;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.install.ProjectViewCLiOptionsProvider;
import org.jetbrains.bsp.bazel.install.cli.CliOptions;
import org.jetbrains.bsp.bazel.install.installationcontext.InstallationContext;
import org.jetbrains.bsp.bazel.install.installationcontext.InstallationContextDebuggerAddressEntity;
import org.jetbrains.bsp.bazel.install.installationcontext.InstallationContextJavaPathEntity;
import org.jetbrains.bsp.bazel.install.installationcontext.InstallationContextJavaPathEntityMapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/bsp/bazel/install/InstallationContextProvider;", "", "<init>", "()V", "generateAndSaveProjectViewFileIfNeeded", "", "cliOptions", "Lorg/jetbrains/bsp/bazel/install/cli/CliOptions;", "createInstallationContext", "Lorg/jetbrains/bsp/bazel/install/installationcontext/InstallationContext;", "calculateGeneratedProjectViewPath", "Ljava/nio/file/Path;", "isFileExisted", "", "server_install_src_main_kotlin_org_jetbrains_bsp_bazel_install-install"})
@SourceDebugExtension(value={"SMAP\nInstallationContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallationContextProvider.kt\norg/jetbrains/bsp/bazel/install/InstallationContextProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class InstallationContextProvider {
    @NotNull
    public static final InstallationContextProvider INSTANCE = new InstallationContextProvider();

    private InstallationContextProvider() {
    }

    public final void generateAndSaveProjectViewFileIfNeeded(@NotNull CliOptions cliOptions) {
        Intrinsics.checkNotNullParameter((Object)cliOptions, (String)"cliOptions");
        Path generatedProjectViewFilePath = this.calculateGeneratedProjectViewPath(cliOptions);
        if (!this.isFileExisted(generatedProjectViewFilePath) || cliOptions.getProjectViewCliOptions() != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(generatedProjectViewFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                ProjectViewCLiOptionsProvider.INSTANCE.generateProjectViewAndSave(cliOptions, generatedProjectViewFilePath);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final InstallationContext createInstallationContext(@NotNull CliOptions cliOptions) {
        InstallationContextDebuggerAddressEntity installationContextDebuggerAddressEntity;
        InstallationContextJavaPathEntity installationContextJavaPathEntity;
        Intrinsics.checkNotNullParameter((Object)cliOptions, (String)"cliOptions");
        Path path2 = cliOptions.getJavaPath();
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            installationContextJavaPathEntity = new InstallationContextJavaPathEntity(it);
        } else {
            installationContextJavaPathEntity = InstallationContextJavaPathEntityMapper.INSTANCE.default();
        }
        String string = cliOptions.getDebuggerAddress();
        if (string != null) {
            void it;
            String string2 = string;
            InstallationContextJavaPathEntity installationContextJavaPathEntity2 = installationContextJavaPathEntity;
            boolean bl = false;
            installationContextDebuggerAddressEntity = new InstallationContextDebuggerAddressEntity((String)it);
            installationContextJavaPathEntity = installationContextJavaPathEntity2;
        } else {
            installationContextDebuggerAddressEntity = null;
        }
        Path path3 = cliOptions.getBazelWorkspaceRootDir();
        Path path4 = this.calculateGeneratedProjectViewPath(cliOptions);
        InstallationContextDebuggerAddressEntity installationContextDebuggerAddressEntity2 = installationContextDebuggerAddressEntity;
        InstallationContextJavaPathEntity installationContextJavaPathEntity3 = installationContextJavaPathEntity;
        return new InstallationContext(installationContextJavaPathEntity3, installationContextDebuggerAddressEntity2, path4, path3);
    }

    private final Path calculateGeneratedProjectViewPath(CliOptions cliOptions) {
        Path path2 = cliOptions.getProjectViewFilePath();
        if (path2 == null) {
            Path path3 = cliOptions.getWorkspaceRootDir().resolve(".bazelproject");
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        }
        return path2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFileExisted(Path $this$isFileExisted) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$isFileExisted, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile($this$isFileExisted, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        return true;
    }
}

