/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.install;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.install.LauncherArgumentCreator;
import org.jetbrains.bsp.bazel.install.installationcontext.InstallationContext;
import org.jetbrains.bsp.bazel.install.installationcontext.InstallationContextDebuggerAddressEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/bsp/bazel/install/LauncherArgumentCreator;", "", "installationContext", "Lorg/jetbrains/bsp/bazel/install/installationcontext/InstallationContext;", "<init>", "(Lorg/jetbrains/bsp/bazel/install/installationcontext/InstallationContext;)V", "javaBinaryArgv", "", "classpathArgv", "readSystemProperty", "name", "mapClasspathToAbsolutePaths", "systemPropertyClasspath", "debuggerConnectionArgv", "projectViewFilePathArgv", "bazelWorkspaceRootDir", "server_install_src_main_kotlin_org_jetbrains_bsp_bazel_install-install"})
@SourceDebugExtension(value={"SMAP\nLauncherArgumentCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LauncherArgumentCreator.kt\norg/jetbrains/bsp/bazel/install/LauncherArgumentCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1557#2:35\n1628#2,3:36\n1557#2:39\n1628#2,3:40\n1557#2:43\n1628#2,3:44\n1#3:47\n*S KotlinDebug\n*F\n+ 1 LauncherArgumentCreator.kt\norg/jetbrains/bsp/bazel/install/LauncherArgumentCreator\n*L\n19#1:35\n19#1:36,3\n20#1:39\n20#1:40,3\n21#1:43\n21#1:44,3\n*E\n"})
public final class LauncherArgumentCreator {
    @NotNull
    private final InstallationContext installationContext;

    public LauncherArgumentCreator(@NotNull InstallationContext installationContext) {
        Intrinsics.checkNotNullParameter((Object)installationContext, (String)"installationContext");
        this.installationContext = installationContext;
    }

    @NotNull
    public final String javaBinaryArgv() {
        return ((Object)this.installationContext.getJavaPath().getValue()).toString();
    }

    @NotNull
    public final String classpathArgv() {
        return this.mapClasspathToAbsolutePaths(this.readSystemProperty("java.class.path"));
    }

    private final String readSystemProperty(String name) {
        String string = System.getProperty(name);
        if (string == null) {
            throw new NoSuchElementException("Could not read " + name + " system property");
        }
        return string;
    }

    private final String mapClasspathToAbsolutePaths(String systemPropertyClasspath) {
        Path p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{File.pathSeparator};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)systemPropertyClasspath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Paths.get((String)((Object)p0), new String[0]));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toAbsolutePath());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.normalize());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, (Function1)mapClasspathToAbsolutePaths.4.INSTANCE, (int)30, null);
    }

    @Nullable
    public final String debuggerConnectionArgv() {
        String string;
        String string2;
        InstallationContextDebuggerAddressEntity installationContextDebuggerAddressEntity = this.installationContext.getDebuggerAddress();
        if (installationContextDebuggerAddressEntity != null && (string2 = installationContextDebuggerAddressEntity.getValue()) != null) {
            String it = string2;
            boolean bl = false;
            string = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + it;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String projectViewFilePathArgv() {
        return ((Object)this.installationContext.getProjectViewFilePath()).toString();
    }

    @NotNull
    public final String bazelWorkspaceRootDir() {
        return ((Object)this.installationContext.getBazelWorkspaceRootDir()).toString();
    }
}

