/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.install.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.install.cli.CliOptions;
import org.jetbrains.bsp.bazel.install.cli.HelpCliOptions;
import org.jetbrains.bsp.bazel.install.cli.ProjectViewCliOptions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0011\u0018\u0000 62\u00020\u0001:\u00016B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040&*\b\u0012\u0004\u0012\u00020\u00040&H\u0002J\u0018\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010-\u001a\u00020\u0010H\u0002J\b\u0010.\u001a\u00020\u0010H\u0002J\u0018\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u00100\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u00101\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u00102\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u00103\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u00104\u001a\u0004\u0018\u00010#2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010$J\u0012\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/bsp/bazel/install/cli/CliOptionsProvider;", "", "args", "", "", "<init>", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "cliParserOptions", "Lorg/apache/commons/cli/Options;", "getOptions", "Lorg/jetbrains/bsp/bazel/install/cli/CliOptions;", "createCliOptions", "cmd", "Lorg/apache/commons/cli/CommandLine;", "workspaceRootDir", "Ljava/nio/file/Path;", "projectViewFilePath", "createHelpCliOptions", "Lorg/jetbrains/bsp/bazel/install/cli/HelpCliOptions;", "bazelWorkspaceRootDir", "isHelpOptionUsed", "", "printHelp", "", "createProjectViewCliOptions", "Lorg/jetbrains/bsp/bazel/install/cli/ProjectViewCliOptions;", "isAnyGenerationFlagSet", "javaPath", "bazelBinary", "getOptionValueAndMapToAbsolutePath", "shortOpt", "debuggerAddress", "allowManualTargetsSync", "importDepth", "", "(Lorg/apache/commons/cli/CommandLine;)Ljava/lang/Integer;", "enabledRules", "", "ideJavaHomeOverride", "targets", "excludedTargets", "splitTargets", "buildFlags", "syncFlags", "calculateCurrentAbsoluteDirectory", "calculateCurrentDir", "directories", "excludedDirectories", "deriveTargetsFlag", "produceTraceLogFlag", "shardSyncEnabled", "getTargetShardSize", "getShardApproach", "Companion", "server_install_src_main_kotlin_org_jetbrains_bsp_bazel_install_cli-cli"})
@SourceDebugExtension(value={"SMAP\nCliOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliOptionsProvider.kt\norg/jetbrains/bsp/bazel/install/cli/CliOptionsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,405:1\n1#2:406\n1368#3:407\n1454#3,5:408\n*S KotlinDebug\n*F\n+ 1 CliOptionsProvider.kt\norg/jetbrains/bsp/bazel/install/cli/CliOptionsProvider\n*L\n351#1:407\n351#1:408,5\n*E\n"})
public final class CliOptionsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] args;
    @NotNull
    private final Options cliParserOptions;
    @NotNull
    private static final String HELP_SHORT_OPT = "h";
    @NotNull
    private static final String WORKSPACE_ROOT_DIR_SHORT_OPT = "d";
    @NotNull
    private static final String PROJECT_VIEW_FILE_PATH_SHORT_OPT = "p";
    @NotNull
    private static final String TARGETS_SHORT_OPT = "t";
    @NotNull
    private static final String EXCLUDED_TARGETS_LONG_OPT = "excluded-targets";
    @NotNull
    private static final String BUILD_FLAGS_SHORT_OPT = "f";
    @NotNull
    private static final String SYNC_FLAGS_SHORT_OPT = "s";
    @NotNull
    private static final String BAZEL_BINARY_SHORT_OPT = "b";
    @NotNull
    private static final String DEBUGGER_ADDRESS_SHORT_OPT = "x";
    @NotNull
    private static final String JAVA_PATH_SHORT_OPT = "j";
    @NotNull
    private static final String BUILD_MANUAL_TARGETS_OPT = "m";
    @NotNull
    private static final String ENABLED_RULES_LONG_OPT = "enabled-rules";
    @NotNull
    private static final String IDE_JAVA_HOME_OVERRIDE_LONG_OPT = "ide-java-home-override";
    @NotNull
    private static final String DIRECTORIES_SHORT_OPT = "r";
    @NotNull
    private static final String EXCLUDED_DIRECTORIES_LONG_OPT = "excluded-directories";
    @NotNull
    private static final String DERIVE_TARGETS_FLAG_SHORT_OPT = "v";
    @NotNull
    private static final String IMPORT_DEPTH_SHORT_OPT = "i";
    @NotNull
    private static final String BAZEL_WORKSPACE_ROOT_DIR_OPT = "w";
    @NotNull
    private static final String PRODUCE_TRACE_LOG_OPT = "l";
    @NotNull
    private static final String SHARD_SYNC_LONG_OPT = "shard-sync";
    @NotNull
    private static final String TARGET_SHARD_SIZE_LONG_OPT = "target-shard-size";
    @NotNull
    private static final String SHARD_APPROACH_LONG_OPT = "shard-approach";
    @NotNull
    public static final String INSTALLER_BINARY_NAME = "bazelbsp-install";

    public CliOptionsProvider(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.args = args;
        this.cliParserOptions = new Options();
        Option helpOption = Option.builder((String)HELP_SHORT_OPT).longOpt("help").desc("Show help.").build();
        this.cliParserOptions.addOption(helpOption);
        Option workspaceRootDirectoryOption = Option.builder((String)WORKSPACE_ROOT_DIR_SHORT_OPT).longOpt("directory").hasArg().argName("path").desc("Path to directory where bazel bsp server should be setup. Current directory will be used by default.").build();
        this.cliParserOptions.addOption(workspaceRootDirectoryOption);
        Option projectViewFilePathOption = Option.builder((String)PROJECT_VIEW_FILE_PATH_SHORT_OPT).longOpt("project-view-file").hasArg().argName("path").desc("Path to project view file. OR The path of the new project view file which will be generated using generation flags.").build();
        this.cliParserOptions.addOption(projectViewFilePathOption);
        Option targetsOption = Option.builder((String)TARGETS_SHORT_OPT).longOpt("targets").hasArgs().argName("targets").desc("Add targets to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#targets").build();
        this.cliParserOptions.addOption(targetsOption);
        Option excludedTargetsOption = Option.builder().longOpt(EXCLUDED_TARGETS_LONG_OPT).hasArgs().argName("excluded targets").desc("Add excluded targets to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#targets").build();
        this.cliParserOptions.addOption(excludedTargetsOption);
        Option buildFlagsOption = Option.builder((String)BUILD_FLAGS_SHORT_OPT).longOpt("build-flags").hasArgs().argName("flags").desc("Add build flags to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#build_flags").build();
        this.cliParserOptions.addOption(buildFlagsOption);
        Option syncFlagsOption = Option.builder((String)SYNC_FLAGS_SHORT_OPT).longOpt("sync-flags").hasArgs().argName("flags").desc("Add sync flags to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#sync_flags").build();
        this.cliParserOptions.addOption(syncFlagsOption);
        Option bazelBinaryOption = Option.builder((String)BAZEL_BINARY_SHORT_OPT).longOpt("bazel-binary").hasArg().argName("path").desc("Add bazel path to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#bazel_binary").build();
        this.cliParserOptions.addOption(bazelBinaryOption);
        Option debuggerAddressOption = Option.builder((String)DEBUGGER_ADDRESS_SHORT_OPT).longOpt("debugger-address").hasArg().argName("address").desc("Add debugger address to the server invocation.").build();
        this.cliParserOptions.addOption(debuggerAddressOption);
        Option javaPathOption = Option.builder((String)JAVA_PATH_SHORT_OPT).longOpt("java-path").hasArg().argName("path").desc("Add java path to the server invocation.").build();
        this.cliParserOptions.addOption(javaPathOption);
        Option manualTargetsOption = Option.builder((String)BUILD_MANUAL_TARGETS_OPT).longOpt("allow-manual-targets-sync").desc("Add build manual target to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#allow_manual_targets_sync").build();
        this.cliParserOptions.addOption(manualTargetsOption);
        Option directoriesOption = Option.builder((String)DIRECTORIES_SHORT_OPT).longOpt("directories").hasArgs().argName("directories").desc("Add directories to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#directories").build();
        this.cliParserOptions.addOption(directoriesOption);
        Option excludedDirectoriesOption = Option.builder().longOpt(EXCLUDED_DIRECTORIES_LONG_OPT).hasArgs().argName("excluded directories").desc("Add excluded directories to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#directories").build();
        this.cliParserOptions.addOption(excludedDirectoriesOption);
        Option deriveTargetsFromDirectoriesOption = Option.builder((String)DERIVE_TARGETS_FLAG_SHORT_OPT).longOpt("derive-targets-from-directories").desc("Add derive_targets_from_directories to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#derive_targets_from_directories").build();
        this.cliParserOptions.addOption(deriveTargetsFromDirectoriesOption);
        Option importDepthOption = Option.builder((String)IMPORT_DEPTH_SHORT_OPT).longOpt("import-depth").hasArg().argName("value").desc("Add import depth to to the generated project view file, you can read more about it here: https://github.com/JetBrains/hirschgarten/blob/main/server/executioncontext/projectview/README.md#import_depth").build();
        this.cliParserOptions.addOption(importDepthOption);
        Option bazelWorkspaceRootDirOption = Option.builder((String)BAZEL_WORKSPACE_ROOT_DIR_OPT).longOpt("bazel-workspace").hasArg().desc("Add path to Bazel project's root directory. By default, it is the same as --directory (-d)").build();
        this.cliParserOptions.addOption(bazelWorkspaceRootDirOption);
        Option produceTraceLogOption = Option.builder((String)PRODUCE_TRACE_LOG_OPT).longOpt("produce-trace-log").desc("Server will create trace log file.").build();
        this.cliParserOptions.addOption(produceTraceLogOption);
        Option enabledRulesOption = Option.builder().longOpt(ENABLED_RULES_LONG_OPT).hasArgs().desc("Add manually enabled rules to override the automatic rules detection mechanism").build();
        this.cliParserOptions.addOption(enabledRulesOption);
        Option shardSyncOption = Option.builder().longOpt(SHARD_SYNC_LONG_OPT).hasArg().desc("Enable shard sync").build();
        this.cliParserOptions.addOption(shardSyncOption);
        Option targetShardSizeOption = Option.builder().longOpt(TARGET_SHARD_SIZE_LONG_OPT).hasArg().desc("Target shard size").build();
        this.cliParserOptions.addOption(targetShardSizeOption);
        Option shardApproachOption = Option.builder().longOpt(SHARD_APPROACH_LONG_OPT).hasArg().desc("Shard approach").build();
        this.cliParserOptions.addOption(shardApproachOption);
    }

    @NotNull
    public final CliOptions getOptions() {
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(this.cliParserOptions, this.args, false);
        Intrinsics.checkNotNullExpressionValue((Object)commandLine, (String)"parse(...)");
        return this.createCliOptions(commandLine);
    }

    private final CliOptions createCliOptions(CommandLine cmd) {
        return new CliOptions(this.javaPath(cmd), this.debuggerAddress(cmd), this.createHelpCliOptions(cmd), this.workspaceRootDir(cmd), this.projectViewFilePath(cmd), this.createProjectViewCliOptions(cmd), this.bazelWorkspaceRootDir(cmd));
    }

    private final Path workspaceRootDir(CommandLine cmd) {
        Path path2 = this.getOptionValueAndMapToAbsolutePath(cmd, WORKSPACE_ROOT_DIR_SHORT_OPT);
        if (path2 == null) {
            path2 = this.calculateCurrentAbsoluteDirectory();
        }
        return path2;
    }

    private final Path projectViewFilePath(CommandLine cmd) {
        return this.getOptionValueAndMapToAbsolutePath(cmd, PROJECT_VIEW_FILE_PATH_SHORT_OPT);
    }

    private final HelpCliOptions createHelpCliOptions(CommandLine cmd) {
        return new HelpCliOptions(this.isHelpOptionUsed(cmd), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                CliOptionsProvider.access$printHelp((CliOptionsProvider)this.receiver);
            }
        }));
    }

    private final Path bazelWorkspaceRootDir(CommandLine cmd) {
        Path path2 = this.getOptionValueAndMapToAbsolutePath(cmd, BAZEL_WORKSPACE_ROOT_DIR_OPT);
        if (path2 == null) {
            path2 = this.workspaceRootDir(cmd);
        }
        return path2;
    }

    private final boolean isHelpOptionUsed(CommandLine cmd) {
        return cmd.hasOption(HELP_SHORT_OPT);
    }

    private final void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(160);
        formatter.printHelp(INSTALLER_BINARY_NAME, null, this.cliParserOptions, "If any generation flag (-b, -f, -j, -t, -x,-m ,-r, -v, -i, -enabled-rules) is used, the installer will generate a new project view file with these sections. If --project_view_file (-p) flag is used as well, the new project view file will be created under this location (it will override the existing file if exists). Otherwise the new file `projectview.bazelproject` will be created.", true);
    }

    private final ProjectViewCliOptions createProjectViewCliOptions(CommandLine cmd) {
        return this.isAnyGenerationFlagSet(cmd) ? new ProjectViewCliOptions(this.bazelBinary(cmd), this.targets(cmd), this.excludedTargets(cmd), this.buildFlags(cmd), this.syncFlags(cmd), this.allowManualTargetsSync(cmd), this.directories(cmd), this.excludedDirectories(cmd), this.deriveTargetsFlag(cmd), this.importDepth(cmd), this.produceTraceLogFlag(cmd), this.enabledRules(cmd), this.ideJavaHomeOverride(cmd), this.shardSyncEnabled(cmd), this.getTargetShardSize(cmd), this.getShardApproach(cmd)) : null;
    }

    private final boolean isAnyGenerationFlagSet(CommandLine cmd) {
        return cmd.hasOption(TARGETS_SHORT_OPT) | cmd.hasOption(EXCLUDED_TARGETS_LONG_OPT) | cmd.hasOption(BAZEL_BINARY_SHORT_OPT) | cmd.hasOption(BUILD_FLAGS_SHORT_OPT) | cmd.hasOption(SYNC_FLAGS_SHORT_OPT) | cmd.hasOption(BUILD_MANUAL_TARGETS_OPT) | cmd.hasOption(DIRECTORIES_SHORT_OPT) | cmd.hasOption(EXCLUDED_DIRECTORIES_LONG_OPT) | cmd.hasOption(DERIVE_TARGETS_FLAG_SHORT_OPT) | cmd.hasOption(IMPORT_DEPTH_SHORT_OPT) | cmd.hasOption(PRODUCE_TRACE_LOG_OPT) | cmd.hasOption(ENABLED_RULES_LONG_OPT) | cmd.hasOption(SHARD_SYNC_LONG_OPT);
    }

    private final Path javaPath(CommandLine cmd) {
        return this.getOptionValueAndMapToAbsolutePath(cmd, JAVA_PATH_SHORT_OPT);
    }

    private final Path bazelBinary(CommandLine cmd) {
        return this.getOptionValueAndMapToAbsolutePath(cmd, BAZEL_BINARY_SHORT_OPT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Path getOptionValueAndMapToAbsolutePath(CommandLine cmd, String shortOpt) {
        String string = cmd.getOptionValue(shortOpt);
        if (string == null) return null;
        String p0 = string;
        boolean bl = false;
        Path path2 = Paths.get(p0, new String[0]);
        if (path2 == null) return null;
        Path it = path2;
        boolean bl2 = false;
        Path path3 = this.calculateCurrentAbsoluteDirectory().resolve(it);
        if (path3 == null) return null;
        Path p02 = path3;
        boolean bl3 = false;
        Path path4 = p02.normalize();
        return path4;
    }

    private final String debuggerAddress(CommandLine cmd) {
        return cmd.getOptionValue(DEBUGGER_ADDRESS_SHORT_OPT);
    }

    private final boolean allowManualTargetsSync(CommandLine cmd) {
        return cmd.hasOption(BUILD_MANUAL_TARGETS_OPT);
    }

    private final Integer importDepth(CommandLine cmd) {
        String string = cmd.getOptionValue(IMPORT_DEPTH_SHORT_OPT);
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }

    private final List<String> enabledRules(CommandLine cmd) {
        Object[] objectArray = cmd.getOptionValues(ENABLED_RULES_LONG_OPT);
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    private final Path ideJavaHomeOverride(CommandLine cmd) {
        return this.getOptionValueAndMapToAbsolutePath(cmd, IDE_JAVA_HOME_OVERRIDE_LONG_OPT);
    }

    private final List<String> targets(CommandLine cmd) {
        Object object = cmd.getOptionValues(TARGETS_SHORT_OPT);
        return object != null && (object = ArraysKt.toList((Object[])object)) != null ? this.splitTargets((List<String>)object) : null;
    }

    private final List<String> excludedTargets(CommandLine cmd) {
        Object object = cmd.getOptionValues(EXCLUDED_TARGETS_LONG_OPT);
        return object != null && (object = ArraysKt.toList((Object[])object)) != null ? this.splitTargets((List<String>)object) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitTargets(List<String> $this$splitTargets) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$splitTargets;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> buildFlags(CommandLine cmd) {
        Object[] objectArray = cmd.getOptionValues(BUILD_FLAGS_SHORT_OPT);
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    private final List<String> syncFlags(CommandLine cmd) {
        Object[] objectArray = cmd.getOptionValues(SYNC_FLAGS_SHORT_OPT);
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    private final Path calculateCurrentAbsoluteDirectory() {
        Path path2 = this.calculateCurrentDir().toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        return path2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Path calculateCurrentDir() {
        Path path2;
        String string = System.getenv("BUILD_WORKING_DIRECTORY");
        if (string != null) {
            String it = string;
            boolean bl = false;
            Path path3 = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            Path path4 = path3;
            if (path4 != null) {
                path2 = path4;
                return path2;
            }
        }
        Path path5 = Paths.get("", new String[0]);
        path2 = path5;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
        return path2;
    }

    private final List<String> directories(CommandLine cmd) {
        Object[] objectArray = cmd.getOptionValues(DIRECTORIES_SHORT_OPT);
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    private final List<String> excludedDirectories(CommandLine cmd) {
        Object[] objectArray = cmd.getOptionValues(EXCLUDED_DIRECTORIES_LONG_OPT);
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    private final boolean deriveTargetsFlag(CommandLine cmd) {
        return cmd.hasOption(DERIVE_TARGETS_FLAG_SHORT_OPT);
    }

    private final boolean produceTraceLogFlag(CommandLine cmd) {
        return cmd.hasOption(PRODUCE_TRACE_LOG_OPT);
    }

    private final boolean shardSyncEnabled(CommandLine cmd) {
        String string = cmd.getOptionValue(SHARD_SYNC_LONG_OPT);
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    private final Integer getTargetShardSize(CommandLine cmd) {
        String string = cmd.getOptionValue(TARGET_SHARD_SIZE_LONG_OPT);
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }

    private final String getShardApproach(CommandLine cmd) {
        return cmd.getOptionValue(SHARD_APPROACH_LONG_OPT);
    }

    public static final /* synthetic */ void access$printHelp(CliOptionsProvider $this) {
        $this.printHelp();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/bsp/bazel/install/cli/CliOptionsProvider$Companion;", "", "<init>", "()V", "HELP_SHORT_OPT", "", "WORKSPACE_ROOT_DIR_SHORT_OPT", "PROJECT_VIEW_FILE_PATH_SHORT_OPT", "TARGETS_SHORT_OPT", "EXCLUDED_TARGETS_LONG_OPT", "BUILD_FLAGS_SHORT_OPT", "SYNC_FLAGS_SHORT_OPT", "BAZEL_BINARY_SHORT_OPT", "DEBUGGER_ADDRESS_SHORT_OPT", "JAVA_PATH_SHORT_OPT", "BUILD_MANUAL_TARGETS_OPT", "ENABLED_RULES_LONG_OPT", "IDE_JAVA_HOME_OVERRIDE_LONG_OPT", "DIRECTORIES_SHORT_OPT", "EXCLUDED_DIRECTORIES_LONG_OPT", "DERIVE_TARGETS_FLAG_SHORT_OPT", "IMPORT_DEPTH_SHORT_OPT", "BAZEL_WORKSPACE_ROOT_DIR_OPT", "PRODUCE_TRACE_LOG_OPT", "SHARD_SYNC_LONG_OPT", "TARGET_SHARD_SIZE_LONG_OPT", "SHARD_APPROACH_LONG_OPT", "INSTALLER_BINARY_NAME", "server_install_src_main_kotlin_org_jetbrains_bsp_bazel_install_cli-cli"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

