/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.logger;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.LogMessageParams;
import ch.epfl.scala.bsp4j.MessageType;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.commons.Format;
import org.jetbrains.bsp.bazel.logger.BspClientLoggerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J+\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000e\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005J+\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000e\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u001f\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "", "bspClient", "Lch/epfl/scala/bsp4j/BuildClient;", "originId", "", "<init>", "(Lch/epfl/scala/bsp4j/BuildClient;Ljava/lang/String;)V", "error", "", "errorMessage", "message", "format", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "warn", "log", "messageType", "Lch/epfl/scala/bsp4j/MessageType;", "logDuration", "description", "duration", "Ljava/time/Duration;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "server_logger_src_main_kotlin_org_jetbrains_bsp_bazel_logger-logger"})
@SourceDebugExtension(value={"SMAP\nBspClientLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BspClientLogger.kt\norg/jetbrains/bsp/bazel/logger/BspClientLogger\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,46:1\n108#2:47\n80#2,22:48\n*S KotlinDebug\n*F\n+ 1 BspClientLogger.kt\norg/jetbrains/bsp/bazel/logger/BspClientLogger\n*L\n33#1:47\n33#1:48,22\n*E\n"})
public final class BspClientLogger {
    @NotNull
    private final BuildClient bspClient;
    @Nullable
    private final String originId;

    public BspClientLogger(@NotNull BuildClient bspClient, @Nullable String originId) {
        Intrinsics.checkNotNullParameter((Object)bspClient, (String)"bspClient");
        this.bspClient = bspClient;
        this.originId = originId;
    }

    public /* synthetic */ BspClientLogger(BuildClient buildClient, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(buildClient, string);
    }

    public final void error(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.log(MessageType.ERROR, errorMessage);
    }

    public final void message(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        this.message(string);
    }

    public final void message(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log(MessageType.LOG, message);
    }

    public final void warn(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        this.warn(string);
    }

    public final void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log(MessageType.WARNING, message);
    }

    private final void log(MessageType messageType, String message) {
        String $this$trim$iv = message;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) {
            LogMessageParams params = new LogMessageParams(messageType, message);
            params.setOriginId(this.originId);
            this.bspClient.onBuildLogMessage(params);
        }
    }

    public final void logDuration(@NotNull String description, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        if (duration.compareTo(BspClientLoggerKt.access$getLOG_OPERATION_THRESHOLD$p()) >= 0) {
            Object[] objectArray = new Object[]{description, Format.INSTANCE.duration(duration)};
            this.message("Task '%s' completed in %s", objectArray);
        }
    }

    private final BuildClient component1() {
        return this.bspClient;
    }

    private final String component2() {
        return this.originId;
    }

    @NotNull
    public final BspClientLogger copy(@NotNull BuildClient bspClient, @Nullable String originId) {
        Intrinsics.checkNotNullParameter((Object)bspClient, (String)"bspClient");
        return new BspClientLogger(bspClient, originId);
    }

    public static /* synthetic */ BspClientLogger copy$default(BspClientLogger bspClientLogger, BuildClient buildClient, String string, int n, Object object) {
        if ((n & 1) != 0) {
            buildClient = bspClientLogger.bspClient;
        }
        if ((n & 2) != 0) {
            string = bspClientLogger.originId;
        }
        return bspClientLogger.copy(buildClient, string);
    }

    @NotNull
    public String toString() {
        return "BspClientLogger(bspClient=" + this.bspClient + ", originId=" + this.originId + ")";
    }

    public int hashCode() {
        int result2 = this.bspClient.hashCode();
        result2 = result2 * 31 + (this.originId == null ? 0 : this.originId.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BspClientLogger)) {
            return false;
        }
        BspClientLogger bspClientLogger = (BspClientLogger)other;
        if (!Intrinsics.areEqual((Object)this.bspClient, (Object)bspClientLogger.bspClient)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.originId, (Object)bspClientLogger.originId);
    }
}

