/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.logger;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TaskFinishParams;
import ch.epfl.scala.bsp4j.TaskId;
import ch.epfl.scala.bsp4j.TaskStartParams;
import ch.epfl.scala.bsp4j.TestFinish;
import ch.epfl.scala.bsp4j.TestReport;
import ch.epfl.scala.bsp4j.TestStart;
import ch.epfl.scala.bsp4j.TestStatus;
import ch.epfl.scala.bsp4j.TestTask;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bazel.label.LabelKt;
import org.jetbrains.bsp.protocol.JUnitStyleTestCaseData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012JD\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0001J\u0018\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u0012J)\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/bsp/bazel/logger/BspClientTestNotifier;", "", "bspClient", "Lch/epfl/scala/bsp4j/BuildClient;", "originId", "", "<init>", "(Lch/epfl/scala/bsp4j/BuildClient;Ljava/lang/String;)V", "passedTests", "", "failedTests", "ignoredTests", "cancelledTests", "skippedTests", "startTest", "", "displayName", "taskId", "Lch/epfl/scala/bsp4j/TaskId;", "finishTest", "status", "Lch/epfl/scala/bsp4j/TestStatus;", "message", "dataKind", "data", "beginTestTarget", "targetIdentifier", "Lorg/jetbrains/bazel/label/Label;", "endTestTarget", "time", "", "(Lorg/jetbrains/bazel/label/Label;Lch/epfl/scala/bsp4j/TaskId;Ljava/lang/Long;)V", "server_logger_src_main_kotlin_org_jetbrains_bsp_bazel_logger-logger"})
@SourceDebugExtension(value={"SMAP\nBspClientTestNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BspClientTestNotifier.kt\norg/jetbrains/bsp/bazel/logger/BspClientTestNotifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class BspClientTestNotifier {
    @NotNull
    private final BuildClient bspClient;
    @NotNull
    private final String originId;
    private int passedTests;
    private int failedTests;
    private int ignoredTests;
    private int cancelledTests;
    private int skippedTests;

    public BspClientTestNotifier(@NotNull BuildClient bspClient, @NotNull String originId) {
        Intrinsics.checkNotNullParameter((Object)bspClient, (String)"bspClient");
        Intrinsics.checkNotNullParameter((Object)originId, (String)"originId");
        this.bspClient = bspClient;
        this.originId = originId;
    }

    public final void startTest(@Nullable String displayName, @NotNull TaskId taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        TestStart testStart = new TestStart(displayName);
        TaskStartParams taskStartParams = new TaskStartParams(taskId);
        taskStartParams.setOriginId(this.originId);
        taskStartParams.setDataKind("test-start");
        taskStartParams.setData((Object)testStart);
        this.bspClient.onBuildTaskStart(taskStartParams);
    }

    public final void finishTest(@Nullable String displayName, @NotNull TaskId taskId, @Nullable TestStatus status, @Nullable String message, @Nullable String dataKind, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        TestFinish testFinish = new TestFinish(displayName, status);
        if (message != null) {
            testFinish.setMessage(message);
        }
        if (dataKind != null && data != null) {
            testFinish.setDataKind(dataKind);
            testFinish.setData(data);
        }
        if (data instanceof JUnitStyleTestCaseData) {
            TestStatus testStatus = status;
            switch (testStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[testStatus.ordinal()]) {
                case 1: {
                    int n = this.passedTests;
                    this.passedTests = n + 1;
                    break;
                }
                case 2: {
                    int n = this.failedTests;
                    this.failedTests = n + 1;
                    break;
                }
                case 3: {
                    int n = this.ignoredTests;
                    this.ignoredTests = n + 1;
                    break;
                }
                case 4: {
                    int n = this.cancelledTests;
                    this.cancelledTests = n + 1;
                    break;
                }
                case 5: {
                    int n = this.skippedTests;
                    this.skippedTests = n + 1;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        TaskFinishParams taskFinishParams = new TaskFinishParams(taskId, StatusCode.OK);
        taskFinishParams.setOriginId(this.originId);
        taskFinishParams.setDataKind("test-finish");
        taskFinishParams.setData((Object)testFinish);
        this.bspClient.onBuildTaskFinish(taskFinishParams);
    }

    public static /* synthetic */ void finishTest$default(BspClientTestNotifier bspClientTestNotifier, String string, TaskId taskId, TestStatus testStatus, String string2, String string3, Object object, int n, Object object2) {
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            object = null;
        }
        bspClientTestNotifier.finishTest(string, taskId, testStatus, string2, string3, object);
    }

    public final void beginTestTarget(@Nullable Label targetIdentifier, @NotNull TaskId taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Label label = targetIdentifier;
        TestTask testingBegin = new TestTask((BuildTargetIdentifier)(label != null ? LabelKt.toBspIdentifier(label) : null));
        TaskStartParams taskStartParams = new TaskStartParams(taskId);
        taskStartParams.setOriginId(this.originId);
        taskStartParams.setDataKind("test-task");
        taskStartParams.setData((Object)testingBegin);
        this.bspClient.onBuildTaskStart(taskStartParams);
    }

    public final void endTestTarget(@Nullable Label targetIdentifier, @NotNull TaskId taskId, @Nullable Long time) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Label label = targetIdentifier;
        TestReport testReport = new TestReport((BuildTargetIdentifier)(label != null ? LabelKt.toBspIdentifier(label) : null), Integer.valueOf(this.passedTests), Integer.valueOf(this.failedTests), Integer.valueOf(this.ignoredTests), Integer.valueOf(this.cancelledTests), Integer.valueOf(this.skippedTests));
        Long l = time;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            testReport.setTime(Long.valueOf(it));
        }
        TaskFinishParams taskFinishParams = new TaskFinishParams(taskId, StatusCode.OK);
        taskFinishParams.setOriginId(this.originId);
        taskFinishParams.setDataKind("test-report");
        taskFinishParams.setData((Object)testReport);
        this.bspClient.onBuildTaskFinish(taskFinishParams);
    }

    public static /* synthetic */ void endTestTarget$default(BspClientTestNotifier bspClientTestNotifier, Label label, TaskId taskId, Long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = null;
        }
        bspClientTestNotifier.endTestTarget(label, taskId, l);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestStatus.values().length];
            try {
                nArray[TestStatus.PASSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.IGNORED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.CANCELLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.SKIPPED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

