/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.projectview.generator;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.projectview.generator.ProjectViewGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewAllowManualTargetsSyncSectionGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewBazelBinarySectionGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewBuildFlagsSectionGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewDeriveTargetsFromDirectoriesSectionGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewDirectoriesSectionGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewEnabledRulesSectionGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewImportDepthSectionGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewSyncFlagsSectionGenerator;
import org.jetbrains.bsp.bazel.projectview.generator.sections.ProjectViewTargetsSectionGenerator;
import org.jetbrains.bsp.bazel.projectview.model.ProjectView;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewSection;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/bsp/bazel/projectview/generator/DefaultProjectViewGenerator;", "Lorg/jetbrains/bsp/bazel/projectview/generator/ProjectViewGenerator;", "<init>", "()V", "generatePrettyStringAndSaveInFile", "", "projectView", "Lorg/jetbrains/bsp/bazel/projectview/model/ProjectView;", "filePath", "Ljava/nio/file/Path;", "generatePrettyString", "", "server_executioncontext_projectview_src_main_kotlin_org_jetbrains_bsp_bazel_projectview_generator-generator"})
public final class DefaultProjectViewGenerator
implements ProjectViewGenerator {
    @NotNull
    public static final DefaultProjectViewGenerator INSTANCE = new DefaultProjectViewGenerator();

    private DefaultProjectViewGenerator() {
    }

    @Override
    public void generatePrettyStringAndSaveInFile(@NotNull ProjectView projectView, @NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)projectView, (String)"projectView");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        Files.writeString(filePath, (CharSequence)this.generatePrettyString(projectView), new OpenOption[0]);
    }

    @Override
    @NotNull
    public String generatePrettyString(@NotNull ProjectView projectView) {
        Intrinsics.checkNotNullParameter((Object)projectView, (String)"projectView");
        Object[] objectArray = new String[]{ProjectViewTargetsSectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getTargets()), ProjectViewBazelBinarySectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getBazelBinary()), ProjectViewBuildFlagsSectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getBuildFlags()), ProjectViewSyncFlagsSectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getSyncFlags()), ProjectViewAllowManualTargetsSyncSectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getAllowManualTargetsSync()), ProjectViewDirectoriesSectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getDirectories()), ProjectViewDeriveTargetsFromDirectoriesSectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getDeriveTargetsFromDirectories()), ProjectViewImportDepthSectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getImportDepth()), ProjectViewEnabledRulesSectionGenerator.INSTANCE.generatePrettyString((ProjectViewSection)projectView.getEnabledRules())};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"\n\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
    }
}

