/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.projectview.parser;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.commons.StringSanitizerKt;
import org.jetbrains.bsp.bazel.projectview.model.ProjectView;
import org.jetbrains.bsp.bazel.projectview.model.sections.AndroidMinSdkSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.EnableNativeAndroidRulesSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ExperimentalAddTransitiveCompileTimeJarsSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ExperimentalNoPruneTransitiveCompileTimeJarsPatternsSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ExperimentalTransitiveCompileTimeJarsTargetKindsSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewAllowManualTargetsSyncSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewBazelBinarySection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewBuildFlagsSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewDeriveTargetsFromDirectoriesSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewDirectoriesSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewEnabledRulesSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewIdeJavaHomeOverrideSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewImportDepthSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewSyncFlagsSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewTargetsSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ShardSyncSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.ShardingApproachSection;
import org.jetbrains.bsp.bazel.projectview.model.sections.TargetShardSizeSection;
import org.jetbrains.bsp.bazel.projectview.parser.DefaultProjectViewParser;
import org.jetbrains.bsp.bazel.projectview.parser.ProjectViewParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.AndroidMinSdkSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.EnableNativeAndroidRulesParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ExperimentalAddTransitiveCompileTimeJarsParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ExperimentalNoPruneTransitiveCompileTimeJarsPatternsSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ExperimentalTransitiveCompileTimeJarsTargetKindsSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewAllowManualTargetsSyncSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewBazelBinarySectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewBuildFlagsSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewDeriveTargetsFromDirectoriesSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewDirectoriesSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewEnabledRulesSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewIdeJavaHomeOverrideSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewImportDepthSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewSyncFlagsSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewTargetsSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ShardSyncParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ShardingApproachParser;
import org.jetbrains.bsp.bazel.projectview.parser.sections.TargetShardSizeParser;
import org.jetbrains.bsp.bazel.projectview.parser.splitter.ProjectViewRawSections;
import org.jetbrains.bsp.bazel.projectview.parser.splitter.ProjectViewSectionSplitter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/bsp/bazel/projectview/parser/DefaultProjectViewParser;", "Lorg/jetbrains/bsp/bazel/projectview/parser/ProjectViewParser;", "workspaceRoot", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/Logger;", "parse", "Lorg/jetbrains/bsp/bazel/projectview/model/ProjectView;", "projectViewFileContent", "", "findImportedProjectViews", "", "rawSections", "Lorg/jetbrains/bsp/bazel/projectview/parser/splitter/ProjectViewRawSections;", "findTryImportedProjectViews", "toProjectViewPath", "projectViewPathStr", "Companion", "server_executioncontext_projectview_src_main_kotlin_org_jetbrains_bsp_bazel_projectview_parser-parser"})
public class DefaultProjectViewParser
implements ProjectViewParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path workspaceRoot;
    private final Logger log;
    @NotNull
    private static final String IMPORT_STATEMENT = "import";
    @NotNull
    private static final String TRY_IMPORT_STATEMENT = "try_import";

    public DefaultProjectViewParser(@Nullable Path workspaceRoot) {
        this.workspaceRoot = workspaceRoot;
        this.log = LogManager.getLogger(DefaultProjectViewParser.class);
    }

    public /* synthetic */ DefaultProjectViewParser(Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path2 = null;
        }
        this(path2);
    }

    @Override
    @NotNull
    public ProjectView parse(@NotNull String projectViewFileContent) {
        Intrinsics.checkNotNullParameter((Object)projectViewFileContent, (String)"projectViewFileContent");
        this.log.trace("Parsing project view for the content: '{}'", (Object)StringSanitizerKt.escapeNewLines(projectViewFileContent));
        ProjectViewRawSections rawSections = ProjectViewSectionSplitter.INSTANCE.getRawSectionsForFileContent(projectViewFileContent);
        return new ProjectView.Builder(CollectionsKt.plus((Collection)this.findImportedProjectViews(rawSections), (Iterable)this.findTryImportedProjectViews(rawSections)), (ProjectViewTargetsSection)ProjectViewTargetsSectionParser.INSTANCE.parse(rawSections), (ProjectViewBazelBinarySection)ProjectViewBazelBinarySectionParser.INSTANCE.parse(rawSections), (ProjectViewBuildFlagsSection)ProjectViewBuildFlagsSectionParser.INSTANCE.parse(rawSections), (ProjectViewSyncFlagsSection)ProjectViewSyncFlagsSectionParser.INSTANCE.parse(rawSections), (ProjectViewAllowManualTargetsSyncSection)ProjectViewAllowManualTargetsSyncSectionParser.INSTANCE.parse(rawSections), (ProjectViewDirectoriesSection)ProjectViewDirectoriesSectionParser.INSTANCE.parse(rawSections), (ProjectViewDeriveTargetsFromDirectoriesSection)ProjectViewDeriveTargetsFromDirectoriesSectionParser.INSTANCE.parse(rawSections), (ProjectViewImportDepthSection)ProjectViewImportDepthSectionParser.INSTANCE.parse(rawSections), (ProjectViewEnabledRulesSection)ProjectViewEnabledRulesSectionParser.INSTANCE.parse(rawSections), (ProjectViewIdeJavaHomeOverrideSection)ProjectViewIdeJavaHomeOverrideSectionParser.INSTANCE.parse(rawSections), (ExperimentalAddTransitiveCompileTimeJarsSection)ExperimentalAddTransitiveCompileTimeJarsParser.INSTANCE.parse(rawSections), (ExperimentalTransitiveCompileTimeJarsTargetKindsSection)ExperimentalTransitiveCompileTimeJarsTargetKindsSectionParser.INSTANCE.parse(rawSections), (ExperimentalNoPruneTransitiveCompileTimeJarsPatternsSection)ExperimentalNoPruneTransitiveCompileTimeJarsPatternsSectionParser.INSTANCE.parse(rawSections), (EnableNativeAndroidRulesSection)EnableNativeAndroidRulesParser.INSTANCE.parse(rawSections), (AndroidMinSdkSection)AndroidMinSdkSectionParser.INSTANCE.parse(rawSections), (ShardSyncSection)ShardSyncParser.INSTANCE.parse(rawSections), (TargetShardSizeSection)TargetShardSizeParser.INSTANCE.parse(rawSections), (ShardingApproachSection)ShardingApproachParser.INSTANCE.parse(rawSections)).build();
    }

    private final List<ProjectView> findImportedProjectViews(ProjectViewRawSections rawSections) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)rawSections.getAllWithName(IMPORT_STATEMENT)), (Function1)findImportedProjectViews.1.INSTANCE), (Function1)findImportedProjectViews.2.INSTANCE), (Function1)((Function1)new Function1<String, Path>((Object)this){

            public final Path invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DefaultProjectViewParser.access$toProjectViewPath((DefaultProjectViewParser)this.receiver, p0);
            }
        })), (Function1)((Function1)new Function1<Path, Unit>(this){
            final /* synthetic */ DefaultProjectViewParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DefaultProjectViewParser.access$getLog$p(this.this$0).debug("Parsing imported file {}.", (Object)it);
            }
        })), (Function1)((Function1)new Function1<Path, ProjectView>((Object)this){

            public final ProjectView invoke(Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DefaultProjectViewParser)this.receiver).parse(p0);
            }
        })));
    }

    private final List<ProjectView> findTryImportedProjectViews(ProjectViewRawSections rawSections) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)rawSections.getAllWithName(TRY_IMPORT_STATEMENT)), (Function1)findTryImportedProjectViews.1.INSTANCE), (Function1)findTryImportedProjectViews.2.INSTANCE), (Function1)((Function1)new Function1<String, Path>((Object)this){

            public final Path invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DefaultProjectViewParser.access$toProjectViewPath((DefaultProjectViewParser)this.receiver, p0);
            }
        })), (Function1)((Function1)new Function1<Path, Unit>(this){
            final /* synthetic */ DefaultProjectViewParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DefaultProjectViewParser.access$getLog$p(this.this$0).debug("Parsing try_imported file {}.", (Object)it);
            }
        })), (Function1)((Function1)new Function1<Path, ProjectView>((Object)this){

            public final ProjectView invoke(Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DefaultProjectViewParser)this.receiver).tryParse(p0);
            }
        })));
    }

    private final Path toProjectViewPath(String projectViewPathStr) {
        Path path2;
        Path path3 = Paths.get(projectViewPathStr, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        Path currentPath = path3;
        if (currentPath.isAbsolute()) {
            path2 = currentPath;
        } else if (this.workspaceRoot != null) {
            Path path4 = this.workspaceRoot.resolve(currentPath);
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        } else {
            path2 = currentPath;
        }
        return path2;
    }

    @Override
    @NotNull
    public ProjectView parse(@NotNull Path projectViewFilePath) {
        return ProjectViewParser.DefaultImpls.parse(this, projectViewFilePath);
    }

    @Override
    @Nullable
    public ProjectView tryParse(@NotNull Path projectViewFilePath) {
        return ProjectViewParser.DefaultImpls.tryParse(this, projectViewFilePath);
    }

    public DefaultProjectViewParser() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Path access$toProjectViewPath(DefaultProjectViewParser $this, String projectViewPathStr) {
        return $this.toProjectViewPath(projectViewPathStr);
    }

    public static final /* synthetic */ Logger access$getLog$p(DefaultProjectViewParser $this) {
        return $this.log;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/bsp/bazel/projectview/parser/DefaultProjectViewParser$Companion;", "", "<init>", "()V", "IMPORT_STATEMENT", "", "TRY_IMPORT_STATEMENT", "server_executioncontext_projectview_src_main_kotlin_org_jetbrains_bsp_bazel_projectview_parser-parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

