/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.projectview.parser.sections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.projectview.model.sections.ProjectViewListSection;
import org.jetbrains.bsp.bazel.projectview.parser.sections.ProjectViewSectionParser;
import org.jetbrains.bsp.bazel.projectview.parser.splitter.ProjectViewRawSection;
import org.jetbrains.bsp.bazel.projectview.parser.splitter.ProjectViewRawSections;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\n\b&\u0018\u0000  *\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001 B\u0011\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u001d\u0010\u000b\u001a\u0004\u0018\u00018\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u0006H$\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u0004\u0018\u00018\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001f\u001a\u00028\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H$\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lorg/jetbrains/bsp/bazel/projectview/parser/sections/ProjectViewListSectionParser;", "V", "T", "Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewListSection;", "Lorg/jetbrains/bsp/bazel/projectview/parser/sections/ProjectViewSectionParser;", "sectionName", "", "<init>", "(Ljava/lang/String;)V", "getSectionName", "()Ljava/lang/String;", "parse", "rawSections", "Lorg/jetbrains/bsp/bazel/projectview/parser/splitter/ProjectViewRawSections;", "(Lorg/jetbrains/bsp/bazel/projectview/parser/splitter/ProjectViewRawSections;)Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewListSection;", "parseAllSectionsAndMerge", "concatSectionsItems", "section1", "section2", "(Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewListSection;Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewListSection;)Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewListSection;", "sectionBody", "(Ljava/lang/String;)Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewListSection;", "splitSectionEntries", "", "allEntries", "(Ljava/util/List;)Lorg/jetbrains/bsp/bazel/projectview/model/sections/ProjectViewListSection;", "mapRawValues", "rawValue", "(Ljava/lang/String;)Ljava/lang/Object;", "createInstanceOrNull", "values", "createInstance", "Companion", "server_executioncontext_projectview_src_main_kotlin_org_jetbrains_bsp_bazel_projectview_parser_sections-sections"})
@SourceDebugExtension(value={"SMAP\nProjectViewListSectionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectViewListSectionParser.kt\norg/jetbrains/bsp/bazel/projectview/parser/sections/ProjectViewListSectionParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,105:1\n1#2:106\n1#2:117\n1611#3,9:107\n1863#3:116\n1864#3:118\n1620#3:119\n2737#3,7:120\n1557#3:130\n1628#3,3:131\n3829#4:127\n4344#4,2:128\n*S KotlinDebug\n*F\n+ 1 ProjectViewListSectionParser.kt\norg/jetbrains/bsp/bazel/projectview/parser/sections/ProjectViewListSectionParser\n*L\n35#1:117\n35#1:107,9\n35#1:116\n35#1:118\n35#1:119\n36#1:120,7\n49#1:130\n49#1:131,3\n46#1:127\n46#1:128,2\n*E\n"})
public abstract class ProjectViewListSectionParser<V, T extends ProjectViewListSection<V>>
extends ProjectViewSectionParser<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sectionName;
    private static final Logger log = LogManager.getLogger(ProjectViewListSectionParser.class);
    private static final Pattern WHITESPACE_CHAR_REGEX = Pattern.compile("[ \n\t]+");

    protected ProjectViewListSectionParser(@NotNull String sectionName) {
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        this.sectionName = sectionName;
    }

    @Override
    @NotNull
    public String getSectionName() {
        return this.sectionName;
    }

    @Override
    @Nullable
    public T parse(@NotNull ProjectViewRawSections rawSections) {
        T t;
        Intrinsics.checkNotNullParameter((Object)rawSections, (String)"rawSections");
        try {
            T t2;
            T t3 = this.parseAllSectionsAndMerge(rawSections);
            if (t3 != null) {
                T t4;
                T it = t4 = t3;
                boolean bl = false;
                log.debug("Parsed '{}' section. Result:\n{}", (Object)this.getSectionName(), it);
                t2 = t4;
            } else {
                t2 = null;
            }
            t = t2;
        }
        catch (Exception e) {
            log.error("Failed to parse '" + this.getSectionName() + "' section.", (Throwable)e);
            t = null;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private final T parseAllSectionsAndMerge(ProjectViewRawSections rawSections) {
        Object v0;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = rawSections.getAllWithName(this.getSectionName());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProjectViewListSection it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProjectViewRawSection it = (ProjectViewRawSection)element$iv$iv;
            boolean bl2 = false;
            if ((ProjectViewListSection)this.parse(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$reduceOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                ProjectViewListSection $i$f$mapNotNullTo2 = (ProjectViewListSection)iterator$iv.next();
                ProjectViewListSection p0 = (ProjectViewListSection)accumulator$iv;
                boolean bl = false;
                accumulator$iv = this.concatSectionsItems(p0, p1);
            }
            v0 = accumulator$iv;
        }
        return (T)((ProjectViewListSection)v0);
    }

    @NotNull
    protected T concatSectionsItems(@NotNull T section1, @NotNull T section2) {
        Intrinsics.checkNotNullParameter(section1, (String)"section1");
        Intrinsics.checkNotNullParameter(section2, (String)"section2");
        return this.createInstance(CollectionsKt.plus((Collection)((ProjectViewListSection)section1).getValues(), (Iterable)((ProjectViewListSection)section2).getValues()));
    }

    @Override
    @Nullable
    protected T parse(@NotNull String sectionBody) {
        Intrinsics.checkNotNullParameter((Object)sectionBody, (String)"sectionBody");
        List<String> allEntries = this.splitSectionEntries(sectionBody);
        return this.parse(allEntries);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitSectionEntries(String sectionBody) {
        void $this$filterTo$iv$iv;
        String[] stringArray = WHITESPACE_CHAR_REGEX.split(sectionBody);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"split(...)");
        Object[] $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected T parse(@NotNull List<String> allEntries) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(allEntries, (String)"allEntries");
        Iterable $this$map$iv = allEntries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapRawValues((String)it));
        }
        List values = (List)destination$iv$iv;
        return this.createInstanceOrNull(values);
    }

    protected abstract V mapRawValues(@NotNull String var1);

    private final T createInstanceOrNull(List<? extends V> values) {
        T t;
        Collection collection;
        Collection collection2 = values;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = collection2;
        }
        List list = (List)collection;
        if (list != null) {
            List it = list;
            boolean bl = false;
            t = this.createInstance(values);
        } else {
            t = null;
        }
        return t;
    }

    @NotNull
    protected abstract T createInstance(@NotNull List<? extends V> var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/bsp/bazel/projectview/parser/sections/ProjectViewListSectionParser$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/Logger;", "WHITESPACE_CHAR_REGEX", "Ljava/util/regex/Pattern;", "Ljava/util/regex/Pattern;", "server_executioncontext_projectview_src_main_kotlin_org_jetbrains_bsp_bazel_projectview_parser_sections-sections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

