/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.projectview.parser.splitter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.projectview.parser.splitter.ProjectViewRawSection;
import org.jetbrains.bsp.bazel.projectview.parser.splitter.ProjectViewRawSections;
import org.jetbrains.bsp.bazel.projectview.parser.splitter.ProjectViewSectionSplitter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0010\u001a\u00020\rH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/bsp/bazel/projectview/parser/splitter/ProjectViewSectionSplitter;", "", "<init>", "()V", "SECTION_HEADER_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "SECTION_HEADER_NAME_GROUP_ID", "", "COMMENT_LINE_REGEX", "Lkotlin/text/Regex;", "COMMENT_LINE_REPLACEMENT", "", "getRawSectionsForFileContent", "Lorg/jetbrains/bsp/bazel/projectview/parser/splitter/ProjectViewRawSections;", "fileContent", "removeLinesWithComments", "findRawSections", "", "Lorg/jetbrains/bsp/bazel/projectview/parser/splitter/ProjectViewRawSection;", "findSectionsHeadersNames", "findSectionsBodiesAndSkipFirstEmptyEntry", "server_executioncontext_projectview_src_main_kotlin_org_jetbrains_bsp_bazel_projectview_parser_splitter-splitter"})
@SourceDebugExtension(value={"SMAP\nProjectViewSectionSplitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectViewSectionSplitter.kt\norg/jetbrains/bsp/bazel/projectview/parser/splitter/ProjectViewSectionSplitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n3436#2,7:71\n*S KotlinDebug\n*F\n+ 1 ProjectViewSectionSplitter.kt\norg/jetbrains/bsp/bazel/projectview/parser/splitter/ProjectViewSectionSplitter\n*L\n55#1:71,7\n*E\n"})
public final class ProjectViewSectionSplitter {
    @NotNull
    public static final ProjectViewSectionSplitter INSTANCE = new ProjectViewSectionSplitter();
    private static final Pattern SECTION_HEADER_REGEX = Pattern.compile("((^[^:\\-/*\\s]+)([: ]))", 8);
    private static final int SECTION_HEADER_NAME_GROUP_ID = 2;
    @NotNull
    private static final Regex COMMENT_LINE_REGEX = new Regex("#(.)*(\\n|\\z)");
    @NotNull
    private static final String COMMENT_LINE_REPLACEMENT = "\n";

    private ProjectViewSectionSplitter() {
    }

    @NotNull
    public final ProjectViewRawSections getRawSectionsForFileContent(@NotNull String fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        String fileContentWithoutComments = this.removeLinesWithComments(fileContent);
        List<ProjectViewRawSection> rawSections = this.findRawSections(fileContentWithoutComments);
        return new ProjectViewRawSections(rawSections);
    }

    private final String removeLinesWithComments(String fileContent) {
        CharSequence charSequence = fileContent;
        Regex regex = COMMENT_LINE_REGEX;
        String string = COMMENT_LINE_REPLACEMENT;
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProjectViewRawSection> findRawSections(String fileContent) {
        void $this$zip$iv;
        List<String> sectionHeadersNames = this.findSectionsHeadersNames(fileContent);
        List<String> sectionBodies = this.findSectionsBodiesAndSkipFirstEmptyEntry(fileContent);
        Iterable iterable = sectionHeadersNames;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = ((Iterable)sectionBodies).iterator();
        ArrayList<ProjectViewRawSection> list$iv = new ArrayList<ProjectViewRawSection>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)sectionBodies, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void sectionBody;
            void sectionName;
            String string = (String)second$iv.next();
            String string2 = (String)first$iv.next();
            ArrayList<ProjectViewRawSection> arrayList = list$iv;
            boolean bl = false;
            arrayList.add(new ProjectViewRawSection((String)sectionName, (String)sectionBody));
        }
        return list$iv;
    }

    private final List<String> findSectionsHeadersNames(String fileContent) {
        Function1 function1 = findSectionsHeadersNames.1.INSTANCE;
        List<String> list = SECTION_HEADER_REGEX.matcher(fileContent).results().map(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        }).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    private final List<String> findSectionsBodiesAndSkipFirstEmptyEntry(String fileContent) {
        String[] stringArray = SECTION_HEADER_REGEX.split(fileContent);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"split(...)");
        return CollectionsKt.drop((Iterable)ArraysKt.toList((Object[])stringArray), (int)1);
    }
}

