/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server;

import ch.epfl.scala.bsp4j.BuildClientCapabilities;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelInfoResolver;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcessResult;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.bazelrunner.utils.BazelInfo;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.server.BazelBspServer;
import org.jetbrains.bsp.bazel.server.benchmark.TelemetryConfig;
import org.jetbrains.bsp.bazel.server.benchmark.TelemetryKt;
import org.jetbrains.bsp.bazel.server.bsp.BazelBspServerLifetime;
import org.jetbrains.bsp.bazel.server.bsp.BazelServices;
import org.jetbrains.bsp.bazel.server.bsp.BspIntegrationData;
import org.jetbrains.bsp.bazel.server.bsp.BspRequestsRunner;
import org.jetbrains.bsp.bazel.server.bsp.BspServerApi;
import org.jetbrains.bsp.bazel.server.bsp.TelemetryContextPropagatingLauncherBuilder;
import org.jetbrains.bsp.bazel.server.bsp.info.BspInfo;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelBspAspectsManager;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelBspCompilationManager;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelBspLanguageExtensionsGenerator;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelLabelExpander;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelToolchainManager;
import org.jetbrains.bsp.bazel.server.bsp.utils.InternalAspectsResolver;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.bazel.server.sync.AdditionalAndroidBuildTargetsProvider;
import org.jetbrains.bsp.bazel.server.sync.BazelProjectMapper;
import org.jetbrains.bsp.bazel.server.sync.BspProjectMapper;
import org.jetbrains.bsp.bazel.server.sync.ExecuteService;
import org.jetbrains.bsp.bazel.server.sync.MavenCoordinatesResolver;
import org.jetbrains.bsp.bazel.server.sync.ProjectProvider;
import org.jetbrains.bsp.bazel.server.sync.ProjectResolver;
import org.jetbrains.bsp.bazel.server.sync.ProjectSyncService;
import org.jetbrains.bsp.bazel.server.sync.TargetInfoReader;
import org.jetbrains.bsp.bazel.server.sync.TargetTagsResolver;
import org.jetbrains.bsp.bazel.server.sync.firstPhase.FirstPhaseProjectResolver;
import org.jetbrains.bsp.bazel.server.sync.firstPhase.FirstPhaseTargetToBspMapper;
import org.jetbrains.bsp.bazel.server.sync.languages.LanguagePluginsService;
import org.jetbrains.bsp.bazel.server.sync.languages.android.AndroidLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.android.KotlinAndroidModulesMerger;
import org.jetbrains.bsp.bazel.server.sync.languages.cpp.CppLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.go.GoLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JavaLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JdkResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.java.JdkVersionResolver;
import org.jetbrains.bsp.bazel.server.sync.languages.kotlin.KotlinLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.python.PythonLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.rust.RustLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.scala.ScalaLanguagePlugin;
import org.jetbrains.bsp.bazel.server.sync.languages.thrift.ThriftLanguagePlugin;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContextProvider;
import org.jetbrains.bsp.protocol.FeatureFlags;
import org.jetbrains.bsp.protocol.InitializeBuildData;
import org.jetbrains.bsp.protocol.JoinedBuildClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ@\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002JP\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/bsp/bazel/server/BazelBspServer;", "", "bspInfo", "Lorg/jetbrains/bsp/bazel/server/bsp/info/BspInfo;", "workspaceContextProvider", "Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContextProvider;", "workspaceRoot", "Ljava/nio/file/Path;", "telemetryConfig", "Lorg/jetbrains/bsp/bazel/server/benchmark/TelemetryConfig;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/bsp/info/BspInfo;Lorg/jetbrains/bsp/bazel/workspacecontext/WorkspaceContextProvider;Ljava/nio/file/Path;Lorg/jetbrains/bsp/bazel/server/benchmark/TelemetryConfig;)V", "gson", "Lcom/google/gson/Gson;", "bspServerData", "Lorg/jetbrains/bsp/bazel/server/bsp/BazelServices;", "initializeBuildParams", "Lch/epfl/scala/bsp4j/InitializeBuildParams;", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "compilationManager", "Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelBspCompilationManager;", "bazelInfo", "Lorg/jetbrains/bsp/bazel/bazelrunner/utils/BazelInfo;", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "createBazelInfo", "createLanguagePluginsService", "Lorg/jetbrains/bsp/bazel/server/sync/languages/LanguagePluginsService;", "createProjectProvider", "Lorg/jetbrains/bsp/bazel/server/sync/ProjectProvider;", "languagePluginsService", "featureFlags", "Lorg/jetbrains/bsp/protocol/FeatureFlags;", "buildServer", "Lorg/eclipse/lsp4j/jsonrpc/Launcher;", "Lorg/jetbrains/bsp/protocol/JoinedBuildClient;", "bspIntegrationData", "Lorg/jetbrains/bsp/bazel/server/bsp/BspIntegrationData;", "verifyBazelVersion", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server-server"})
public final class BazelBspServer {
    @NotNull
    private final BspInfo bspInfo;
    @NotNull
    private final WorkspaceContextProvider workspaceContextProvider;
    @NotNull
    private final Path workspaceRoot;
    @NotNull
    private final TelemetryConfig telemetryConfig;
    @NotNull
    private final Gson gson;

    public BazelBspServer(@NotNull BspInfo bspInfo, @NotNull WorkspaceContextProvider workspaceContextProvider, @NotNull Path workspaceRoot, @NotNull TelemetryConfig telemetryConfig) {
        Intrinsics.checkNotNullParameter((Object)bspInfo, (String)"bspInfo");
        Intrinsics.checkNotNullParameter((Object)workspaceContextProvider, (String)"workspaceContextProvider");
        Intrinsics.checkNotNullParameter((Object)workspaceRoot, (String)"workspaceRoot");
        Intrinsics.checkNotNullParameter((Object)telemetryConfig, (String)"telemetryConfig");
        this.bspInfo = bspInfo;
        this.workspaceContextProvider = workspaceContextProvider;
        this.workspaceRoot = workspaceRoot;
        this.telemetryConfig = telemetryConfig;
        this.gson = new Gson();
    }

    private final BazelServices bspServerData(InitializeBuildParams initializeBuildParams, BspClientLogger bspClientLogger, BazelRunner bazelRunner, BazelBspCompilationManager compilationManager, BazelInfo bazelInfo, WorkspaceContextProvider workspaceContextProvider, BazelPathsResolver bazelPathsResolver) {
        Object object = initializeBuildParams.getData();
        InitializeBuildData initializeBuildData = (InitializeBuildData)this.gson.fromJson((JsonElement)(object instanceof JsonObject ? (JsonObject)object : null), InitializeBuildData.class);
        if (initializeBuildData == null) {
            initializeBuildData = new InitializeBuildData(null, null, null, 7, null);
        }
        InitializeBuildData initializeBuildData2 = initializeBuildData;
        TelemetryConfig telemetryConfig = TelemetryConfig.copy$default(this.telemetryConfig, bspClientLogger, null, initializeBuildData2.getOpenTelemetryEndpoint(), 2, null);
        TelemetryKt.setupTelemetry(telemetryConfig);
        LanguagePluginsService languagePluginsService = this.createLanguagePluginsService(bazelPathsResolver, bspClientLogger);
        FeatureFlags featureFlags = initializeBuildData2.getFeatureFlags();
        if (featureFlags == null) {
            featureFlags = new FeatureFlags(false, false, false, false, false, false, 0, false, 255, null);
        }
        FeatureFlags featureFlags2 = featureFlags;
        ProjectProvider projectProvider = this.createProjectProvider(this.bspInfo, bazelInfo, workspaceContextProvider, bazelRunner, languagePluginsService, bazelPathsResolver, compilationManager, bspClientLogger, featureFlags2);
        BspProjectMapper bspProjectMapper = new BspProjectMapper(languagePluginsService, workspaceContextProvider, bazelPathsResolver, bazelRunner, this.bspInfo);
        FirstPhaseTargetToBspMapper firstPhaseTargetToBspMapper = new FirstPhaseTargetToBspMapper(workspaceContextProvider, this.workspaceRoot);
        BuildClientCapabilities buildClientCapabilities = initializeBuildParams.getCapabilities();
        Intrinsics.checkNotNullExpressionValue((Object)buildClientCapabilities, (String)"getCapabilities(...)");
        ProjectSyncService projectSyncService = new ProjectSyncService(bspProjectMapper, firstPhaseTargetToBspMapper, projectProvider, buildClientCapabilities);
        AdditionalAndroidBuildTargetsProvider additionalBuildTargetsProvider = new AdditionalAndroidBuildTargetsProvider(projectProvider);
        ExecuteService executeService = new ExecuteService(compilationManager, projectProvider, bazelRunner, workspaceContextProvider, bspClientLogger, bazelPathsResolver, additionalBuildTargetsProvider, featureFlags2);
        return new BazelServices(projectSyncService, executeService);
    }

    private final BazelInfo createBazelInfo(BazelRunner bazelRunner) {
        BazelInfoResolver bazelDataResolver = new BazelInfoResolver(bazelRunner);
        return bazelDataResolver.resolveBazelInfo(createBazelInfo.1.INSTANCE);
    }

    private final LanguagePluginsService createLanguagePluginsService(BazelPathsResolver bazelPathsResolver, BspClientLogger bspClientLogger) {
        JdkResolver jdkResolver = new JdkResolver(bazelPathsResolver, new JdkVersionResolver());
        JavaLanguagePlugin javaLanguagePlugin = new JavaLanguagePlugin(this.workspaceContextProvider, bazelPathsResolver, jdkResolver);
        ScalaLanguagePlugin scalaLanguagePlugin = new ScalaLanguagePlugin(javaLanguagePlugin, bazelPathsResolver);
        CppLanguagePlugin cppLanguagePlugin = new CppLanguagePlugin(bazelPathsResolver);
        KotlinLanguagePlugin kotlinLanguagePlugin = new KotlinLanguagePlugin(javaLanguagePlugin, bazelPathsResolver);
        ThriftLanguagePlugin thriftLanguagePlugin = new ThriftLanguagePlugin(bazelPathsResolver);
        PythonLanguagePlugin pythonLanguagePlugin = new PythonLanguagePlugin(bazelPathsResolver);
        RustLanguagePlugin rustLanguagePlugin = new RustLanguagePlugin(bazelPathsResolver);
        AndroidLanguagePlugin androidLanguagePlugin = new AndroidLanguagePlugin(this.workspaceContextProvider, javaLanguagePlugin, kotlinLanguagePlugin, bazelPathsResolver);
        GoLanguagePlugin goLanguagePlugin = new GoLanguagePlugin(bazelPathsResolver, bspClientLogger);
        return new LanguagePluginsService(scalaLanguagePlugin, javaLanguagePlugin, cppLanguagePlugin, kotlinLanguagePlugin, thriftLanguagePlugin, pythonLanguagePlugin, rustLanguagePlugin, androidLanguagePlugin, goLanguagePlugin);
    }

    private final ProjectProvider createProjectProvider(BspInfo bspInfo, BazelInfo bazelInfo, WorkspaceContextProvider workspaceContextProvider, BazelRunner bazelRunner, LanguagePluginsService languagePluginsService, BazelPathsResolver bazelPathsResolver, BazelBspCompilationManager compilationManager, BspClientLogger bspClientLogger, FeatureFlags featureFlags) {
        InternalAspectsResolver aspectsResolver = new InternalAspectsResolver(bspInfo, bazelInfo.getRelease(), bazelInfo.shouldUseInjectRepository());
        BazelBspAspectsManager bazelBspAspectsManager = new BazelBspAspectsManager(compilationManager, aspectsResolver, workspaceContextProvider, featureFlags, bazelInfo.getRelease());
        BazelToolchainManager bazelToolchainManager = new BazelToolchainManager(bazelRunner, featureFlags);
        BazelBspLanguageExtensionsGenerator bazelBspLanguageExtensionsGenerator = new BazelBspLanguageExtensionsGenerator(aspectsResolver);
        BazelLabelExpander bazelLabelExpander = new BazelLabelExpander(bazelRunner);
        TargetTagsResolver targetTagsResolver = new TargetTagsResolver();
        MavenCoordinatesResolver mavenCoordinatesResolver = new MavenCoordinatesResolver();
        KotlinAndroidModulesMerger kotlinAndroidModulesMerger = new KotlinAndroidModulesMerger(featureFlags);
        BazelProjectMapper bazelProjectMapper = new BazelProjectMapper(languagePluginsService, bazelPathsResolver, targetTagsResolver, mavenCoordinatesResolver, kotlinAndroidModulesMerger, bspClientLogger, featureFlags);
        TargetInfoReader targetInfoReader = new TargetInfoReader(bspClientLogger);
        ProjectResolver projectResolver = new ProjectResolver(bazelBspAspectsManager, bazelToolchainManager, bazelBspLanguageExtensionsGenerator, bazelLabelExpander, workspaceContextProvider, bazelProjectMapper, targetInfoReader, bazelInfo, bazelRunner, bazelPathsResolver, bspClientLogger, featureFlags);
        FirstPhaseProjectResolver firstPhaseProjectResolver = new FirstPhaseProjectResolver(this.workspaceRoot, bazelRunner, workspaceContextProvider, bazelInfo, bspClientLogger);
        return new ProjectProvider(projectResolver, firstPhaseProjectResolver);
    }

    @NotNull
    public final Launcher<JoinedBuildClient> buildServer(@NotNull BspIntegrationData bspIntegrationData) {
        Intrinsics.checkNotNullParameter((Object)bspIntegrationData, (String)"bspIntegrationData");
        BspServerApi bspServerApi2 = new BspServerApi((Function2<? super JoinedBuildClient, ? super InitializeBuildParams, BazelServices>)((Function2)new Function2<JoinedBuildClient, InitializeBuildParams, BazelServices>(this){
            final /* synthetic */ BazelBspServer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final BazelServices invoke(JoinedBuildClient client, InitializeBuildParams initializeBuildParams) {
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                Intrinsics.checkNotNullParameter((Object)initializeBuildParams, (String)"initializeBuildParams");
                BspClientLogger bspClientLogger = new BspClientLogger(client, null, 2, null);
                BazelRunner bazelRunner = new BazelRunner(BazelBspServer.access$getWorkspaceContextProvider$p(this.this$0), bspClientLogger, BazelBspServer.access$getWorkspaceRoot$p(this.this$0), null, 8, null);
                this.this$0.verifyBazelVersion(bazelRunner);
                BazelInfo bazelInfo = BazelBspServer.access$createBazelInfo(this.this$0, bazelRunner);
                bazelRunner.setBazelInfo(bazelInfo);
                BazelPathsResolver bazelPathsResolver = new BazelPathsResolver(bazelInfo);
                BazelBspCompilationManager compilationManager = new BazelBspCompilationManager(bazelRunner, bazelPathsResolver, client, BazelBspServer.access$getWorkspaceRoot$p(this.this$0));
                return BazelBspServer.access$bspServerData(this.this$0, initializeBuildParams, bspClientLogger, bazelRunner, compilationManager, bazelInfo, BazelBspServer.access$getWorkspaceContextProvider$p(this.this$0), bazelPathsResolver);
            }
        }));
        Launcher.Builder builder = new TelemetryContextPropagatingLauncherBuilder().setOutput(bspIntegrationData.getStdout()).setInput(bspIntegrationData.getStdin()).setLocalService((Object)bspServerApi2).setRemoteInterface(JoinedBuildClient.class).setExecutorService(bspIntegrationData.getExecutor());
        boolean bl = false;
        Launcher.Builder builder2 = bspIntegrationData.getTraceWriter() != null ? builder.traceMessages(bspIntegrationData.getTraceWriter()) : builder;
        Launcher launcher = builder2.create();
        JoinedBuildClient client = (JoinedBuildClient)launcher.getRemoteProxy();
        BazelBspServerLifetime serverLifetime = new BazelBspServerLifetime(this.workspaceContextProvider);
        BspRequestsRunner bspRequestsRunner = new BspRequestsRunner(serverLifetime);
        Intrinsics.checkNotNull((Object)client);
        bspServerApi2.initialize(client, serverLifetime, bspRequestsRunner);
        Intrinsics.checkNotNull((Object)launcher);
        return launcher;
    }

    public final void verifyBazelVersion(@NotNull BazelRunner bazelRunner) {
        BazelProcessResult bazelProcessResult;
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        BazelCommand command2 = BazelRunner.buildBazelCommand$default(bazelRunner, null, verifyBazelVersion.command.1.INSTANCE, 1, null);
        BazelProcessResult it = bazelProcessResult = BazelRunner.runBazelCommand$default(bazelRunner, command2, null, false, null, false, 22, null).waitAndGetResult(verifyBazelVersion.1.INSTANCE, true);
        boolean bl = false;
        if (it.isNotSuccess()) {
            throw new IllegalStateException(("Querying Bazel version failed.\n" + CollectionsKt.joinToString$default((Iterable)it.getStderrLines(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
        }
    }

    public static final /* synthetic */ WorkspaceContextProvider access$getWorkspaceContextProvider$p(BazelBspServer $this) {
        return $this.workspaceContextProvider;
    }

    public static final /* synthetic */ Path access$getWorkspaceRoot$p(BazelBspServer $this) {
        return $this.workspaceRoot;
    }

    public static final /* synthetic */ BazelInfo access$createBazelInfo(BazelBspServer $this, BazelRunner bazelRunner) {
        return $this.createBazelInfo(bazelRunner);
    }

    public static final /* synthetic */ BazelServices access$bspServerData(BazelBspServer $this, InitializeBuildParams initializeBuildParams, BspClientLogger bspClientLogger, BazelRunner bazelRunner, BazelBspCompilationManager compilationManager, BazelInfo bazelInfo, WorkspaceContextProvider workspaceContextProvider, BazelPathsResolver bazelPathsResolver) {
        return $this.bspServerData(initializeBuildParams, bspClientLogger, bazelRunner, compilationManager, bazelInfo, workspaceContextProvider, bazelPathsResolver);
    }
}

