/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.server.BazelBspServer;
import org.jetbrains.bsp.bazel.server.CliArgs;
import org.jetbrains.bsp.bazel.server.ServerInitializer;
import org.jetbrains.bsp.bazel.server.ServerInitializerKt;
import org.jetbrains.bsp.bazel.server.benchmark.TelemetryConfig;
import org.jetbrains.bsp.bazel.server.bsp.BspIntegrationData;
import org.jetbrains.bsp.bazel.server.bsp.info.BspInfo;
import org.jetbrains.bsp.bazel.workspacecontext.DefaultWorkspaceContextProvider;
import org.jetbrains.bsp.bazel.workspacecontext.WorkspaceContextProvider;
import org.jetbrains.bsp.protocol.JoinedBuildClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/bsp/bazel/server/ServerInitializer;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "createTraceWriterOrNull", "Ljava/io/PrintWriter;", "traceFile", "Ljava/nio/file/Path;", "createTraceFile", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server-server"})
public final class ServerInitializer {
    @NotNull
    public static final ServerInitializer INSTANCE = new ServerInitializer();

    private ServerInitializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ServerInitializerKt.access$getLog$p().info("Starting server with args: " + ArraysKt.toList((Object[])args));
        Runtime.getRuntime().addShutdownHook(new Thread(main.1.INSTANCE));
        if (args.length != 3) {
            ServerInitializerKt.access$getLog$p().error("Wrong number of args, exiting with exit code 1");
            System.err.println("Usage: <bazel workspace root> <project view path> <produce trace log flag>");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        CliArgs cliArgs = new CliArgs(args[0], args[1], Boolean.parseBoolean(args[2]));
        boolean hasErrors = false;
        PrintStream stdout = System.out;
        InputStream stdin = System.in;
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            ServerInitializerKt.access$getLog$p().info("Initializing server");
            Path path2 = Paths.get(cliArgs.getBazelWorkspaceRoot(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            Path rootDir = path2;
            BspInfo bspInfo = new BspInfo(rootDir);
            Path bazelBspDir = bspInfo.bazelBspDir();
            Path traceFile = bazelBspDir.resolve("bazelbsp.trace.json");
            Path path3 = Paths.get(cliArgs.getBazelWorkspaceRoot(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            Path path4 = Paths.get(cliArgs.getProjectViewPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
            Intrinsics.checkNotNull((Object)bazelBspDir);
            DefaultWorkspaceContextProvider workspaceContextProvider = new DefaultWorkspaceContextProvider(path3, path4, bazelBspDir);
            Intrinsics.checkNotNull((Object)stdout);
            OutputStream outputStream = stdout;
            Intrinsics.checkNotNull((Object)stdin);
            Intrinsics.checkNotNull((Object)executor);
            Intrinsics.checkNotNull((Object)traceFile);
            BspIntegrationData bspIntegrationData = new BspIntegrationData(outputStream, stdin, executor, INSTANCE.createTraceWriterOrNull(traceFile, cliArgs.getProduceTraceLog()));
            WorkspaceContextProvider workspaceContextProvider2 = workspaceContextProvider;
            Path path5 = Paths.get(cliArgs.getBazelWorkspaceRoot(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
            BazelBspServer bspServer = new BazelBspServer(bspInfo, workspaceContextProvider2, path5, new TelemetryConfig(null, null, null, 7, null));
            Launcher<JoinedBuildClient> launcher = bspServer.buildServer(bspIntegrationData);
            launcher.startListening().get();
            ServerInitializerKt.access$getLog$p().info("Server has been initialized");
        }
        catch (Exception e) {
            ServerInitializerKt.access$getLog$p().error("Server initialization failed", (Throwable)e);
            e.printStackTrace(System.err);
            hasErrors = true;
        }
        finally {
            executor.shutdown();
        }
        if (hasErrors) {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final PrintWriter createTraceWriterOrNull(Path traceFile, boolean createTraceFile) {
        PrintWriter printWriter;
        if (createTraceFile) {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            PrintWriter printWriter2 = new PrintWriter(Files.newOutputStream(traceFile, openOptionArray));
            printWriter = printWriter2;
        } else {
            printWriter = null;
        }
        return printWriter;
    }
}

