/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.benchmark;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.server.benchmark.FileExporterKt;
import org.jetbrains.bsp.bazel.server.benchmark.TraceKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bsp/bazel/server/benchmark/FileExporter;", "", "logFile", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "logs", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "shutdownRequests", "Ljava/util/concurrent/atomic/AtomicInteger;", "spanExporter", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "metricExporter", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "shutdownRequest", "", "doShutdown", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_benchmark-benchmark"})
public final class FileExporter {
    @NotNull
    private final Path logFile;
    @NotNull
    private final ConcurrentHashMap<String, Long> logs;
    @NotNull
    private final AtomicInteger shutdownRequests;

    public FileExporter(@NotNull Path logFile) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        this.logFile = logFile;
        this.logs = new ConcurrentHashMap();
        this.shutdownRequests = new AtomicInteger(0);
    }

    @NotNull
    public final SpanExporter spanExporter() {
        return new SpanExporter(this){
            final /* synthetic */ FileExporter this$0;
            {
                this.this$0 = $receiver;
            }

            public CompletableResultCode export(Collection<SpanData> spans) {
                Intrinsics.checkNotNullParameter(spans, (String)"spans");
                for (SpanData span : spans) {
                    String string = span.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    CharSequence charSequence = string2;
                    Regex regex = new Regex("\\s+");
                    String string3 = ".";
                    String taskKey = regex.replace(charSequence, string3);
                    ((Map)FileExporter.access$getLogs$p(this.this$0)).put(taskKey + ".time.ms", TraceKt.getDurationMs(span));
                }
                CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
                return completableResultCode;
            }

            public CompletableResultCode flush() {
                CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
                return completableResultCode;
            }

            public CompletableResultCode shutdown() {
                FileExporter.access$shutdownRequest(this.this$0);
                CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
                return completableResultCode;
            }
        };
    }

    @NotNull
    public final MetricExporter metricExporter() {
        return new MetricExporter(this){
            final /* synthetic */ FileExporter this$0;
            {
                this.this$0 = $receiver;
            }

            public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
                Intrinsics.checkNotNullParameter((Object)instrumentType, (String)"instrumentType");
                return AggregationTemporality.CUMULATIVE;
            }

            public CompletableResultCode export(Collection<MetricData> metrics) {
                Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
                for (MetricData metric : metrics) {
                    if (metric.getType() == MetricDataType.LONG_GAUGE) {
                        Map map = FileExporter.access$getLogs$p(this.this$0);
                        String string = metric.getName();
                        Collection collection = metric.getLongGaugeData().getPoints();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
                        Long l = ((LongPointData)CollectionsKt.last((Iterable)collection)).getValue();
                        map.put(string, l);
                        continue;
                    }
                    FileExporterKt.access$getLOGGER$p().warn("Unsupported metric type " + metric.getType());
                }
                CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
                return completableResultCode;
            }

            public CompletableResultCode flush() {
                CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
                return completableResultCode;
            }

            public CompletableResultCode shutdown() {
                FileExporter.access$shutdownRequest(this.this$0);
                CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
                return completableResultCode;
            }
        };
    }

    private final void shutdownRequest() {
        if (this.shutdownRequests.incrementAndGet() != 2) {
            return;
        }
        this.doShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CompletableResultCode doShutdown() {
        Object object = this.logFile;
        Unit unit = new Unit[]{};
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(unit, ((OpenOption[])unit).length)), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl = false;
            for (Map.Entry entry : ((Map)this.logs).entrySet()) {
                String k = (String)entry.getKey();
                long v = ((Number)entry.getValue()).longValue();
                writer.write(k + " " + v + "\n");
            }
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return CompletableResultCode.ofSuccess();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getLogs$p(FileExporter $this) {
        return $this.logs;
    }

    public static final /* synthetic */ void access$shutdownRequest(FileExporter $this) {
        $this.shutdownRequest();
    }
}

