/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.benchmark;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.server.benchmark.TraceKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/bsp/bazel/server/benchmark/LoggingSpanExporter;", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "<init>", "(Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;)V", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "spans", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "flush", "shutdown", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_benchmark-benchmark"})
public final class LoggingSpanExporter
implements SpanExporter {
    @NotNull
    private final BspClientLogger bspClientLogger;

    public LoggingSpanExporter(@NotNull BspClientLogger bspClientLogger) {
        Intrinsics.checkNotNullParameter((Object)bspClientLogger, (String)"bspClientLogger");
        this.bspClientLogger = bspClientLogger;
    }

    @NotNull
    public CompletableResultCode export(@NotNull Collection<? extends SpanData> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        for (SpanData spanData : spans) {
            String string = spanData.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Duration duration = Duration.ofMillis(TraceKt.getDurationMs(spanData));
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            this.bspClientLogger.logDuration(string, duration);
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode flush() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode shutdown() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }
}

