/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.benchmark;

import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.server.benchmark.TelemetryKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0002J\u001a\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bsp/bazel/server/benchmark/MemoryProfiler;", "Ljavax/management/NotificationListener;", "<init>", "()V", "maxUsedMb", "Ljava/util/concurrent/atomic/AtomicLong;", "usedAtExitMb", "startRecording", "", "createOpenTelemetryMemoryGauges", "handleNotification", "notification", "Ljavax/management/Notification;", "handback", "", "stopRecording", "getUsedMemoryMb", "", "forceGc", "getGcCount", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_benchmark-benchmark"})
@SourceDebugExtension(value={"SMAP\nMemoryProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryProfiler.kt\norg/jetbrains/bsp/bazel/server/benchmark/MemoryProfiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1611#2,9:70\n1863#2:79\n1864#2:82\n1620#2:83\n1#3:80\n1#3:81\n*S KotlinDebug\n*F\n+ 1 MemoryProfiler.kt\norg/jetbrains/bsp/bazel/server/benchmark/MemoryProfiler\n*L\n65#1:70,9\n65#1:79\n65#1:82\n65#1:83\n65#1:81\n*E\n"})
public final class MemoryProfiler
implements NotificationListener {
    @NotNull
    public static final MemoryProfiler INSTANCE = new MemoryProfiler();
    @NotNull
    private static final AtomicLong maxUsedMb = new AtomicLong();
    @NotNull
    private static final AtomicLong usedAtExitMb = new AtomicLong();

    private MemoryProfiler() {
    }

    public final void startRecording() {
        this.createOpenTelemetryMemoryGauges();
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            NotificationEmitter notificationEmitter = bean instanceof NotificationEmitter ? (NotificationEmitter)((Object)bean) : null;
            if (notificationEmitter == null) continue;
            notificationEmitter.addNotificationListener(this, null, null);
        }
    }

    private final void createOpenTelemetryMemoryGauges() {
        ObservableLongMeasurement maxUsedMbGauge = TelemetryKt.getMeter().gaugeBuilder("max.used.memory.mb").ofLongs().buildObserver();
        ObservableLongMeasurement usedAtExistMbGauge = TelemetryKt.getMeter().gaugeBuilder("used.at.exit.mb").ofLongs().buildObserver();
        ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{usedAtExistMbGauge};
        TelemetryKt.getMeter().batchCallback(new Runnable(maxUsedMbGauge, usedAtExistMbGauge){
            final /* synthetic */ ObservableLongMeasurement $maxUsedMbGauge;
            final /* synthetic */ ObservableLongMeasurement $usedAtExistMbGauge;
            {
                this.$maxUsedMbGauge = $maxUsedMbGauge;
                this.$usedAtExistMbGauge = $usedAtExistMbGauge;
            }

            public final void run() {
                this.$maxUsedMbGauge.record(MemoryProfiler.access$getMaxUsedMb$p().get());
                this.$usedAtExistMbGauge.record(MemoryProfiler.access$getUsedAtExitMb$p().get());
            }
        }, (ObservableMeasurement)maxUsedMbGauge, observableMeasurementArray);
    }

    @Override
    public void handleNotification(@NotNull Notification notification, @Nullable Object handback) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        if (!Intrinsics.areEqual((Object)notification.getType(), (Object)"com.sun.management.gc.notification")) {
            return;
        }
        long usedMb = this.getUsedMemoryMb();
        maxUsedMb.getAndUpdate(new LongUnaryOperator(usedMb){
            final /* synthetic */ long $usedMb;
            {
                this.$usedMb = $usedMb;
            }

            public final long applyAsLong(long it) {
                return Math.max(it, this.$usedMb);
            }
        });
    }

    public final void stopRecording() {
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            NotificationEmitter notificationEmitter = bean instanceof NotificationEmitter ? (NotificationEmitter)((Object)bean) : null;
            if (notificationEmitter == null) continue;
            notificationEmitter.removeNotificationListener(this);
        }
        this.forceGc();
        long usedAtExitMb = this.getUsedMemoryMb();
        MemoryProfiler.usedAtExitMb.set(usedAtExitMb);
        maxUsedMb.getAndUpdate(new LongUnaryOperator(usedAtExitMb){
            final /* synthetic */ long $usedAtExitMb;
            {
                this.$usedAtExitMb = $usedAtExitMb;
            }

            public final long applyAsLong(long it) {
                return Math.max(it, this.$usedAtExitMb);
            }
        });
    }

    private final long getUsedMemoryMb() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / (long)0x100000;
    }

    private final void forceGc() {
        long oldGcCount = this.getGcCount();
        System.gc();
        while (oldGcCount == this.getGcCount()) {
            Thread.sleep(1L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long getGcCount() {
        void $this$mapNotNullTo$iv$iv;
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv$iv;
            boolean bl2 = false;
            Long l = it.getCollectionCount();
            long count = ((Number)l).longValue();
            boolean bl3 = false;
            if ((count != -1L ? l : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ AtomicLong access$getMaxUsedMb$p() {
        return maxUsedMb;
    }

    public static final /* synthetic */ AtomicLong access$getUsedAtExitMb$p() {
        return usedAtExitMb;
    }
}

