/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.benchmark;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.server.benchmark.FileExporter;
import org.jetbrains.bsp.bazel.server.benchmark.LoggingSpanExporter;
import org.jetbrains.bsp.bazel.server.benchmark.MemoryProfiler;
import org.jetbrains.bsp.bazel.server.benchmark.ShutdownMetricReader;
import org.jetbrains.bsp.bazel.server.benchmark.TelemetryConfig;
import org.jetbrains.bsp.bazel.server.benchmark.TelemetryKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019\u001a*\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002\u001a\"\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002\u001a\u0006\u0010\"\u001a\u00020\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"INSTRUMENTATION_SCOPE_NAME", "", "value", "Lio/opentelemetry/sdk/OpenTelemetrySdk;", "openTelemetry", "getOpenTelemetry", "()Lio/opentelemetry/sdk/OpenTelemetrySdk;", "openTelemetryInitialized", "", "getOpenTelemetryInitialized", "()Z", "tracer", "Lio/opentelemetry/api/trace/Tracer;", "getTracer", "()Lio/opentelemetry/api/trace/Tracer;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "getMeter", "()Lio/opentelemetry/api/metrics/Meter;", "shutdownRoutines", "", "Lkotlin/Function0;", "", "setupTelemetry", "config", "Lorg/jetbrains/bsp/bazel/server/benchmark/TelemetryConfig;", "setupTracing", "sdkBuilder", "Lio/opentelemetry/sdk/OpenTelemetrySdkBuilder;", "resource", "Lio/opentelemetry/sdk/resources/Resource;", "fileExporter", "Lorg/jetbrains/bsp/bazel/server/benchmark/FileExporter;", "setupMetrics", "shutdownTelemetry", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_benchmark-benchmark"})
@SourceDebugExtension(value={"SMAP\ntelemetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 telemetry.kt\norg/jetbrains/bsp/bazel/server/benchmark/TelemetryKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n1863#3,2:114\n*S KotlinDebug\n*F\n+ 1 telemetry.kt\norg/jetbrains/bsp/bazel/server/benchmark/TelemetryKt\n*L\n110#1:114,2\n*E\n"})
public final class TelemetryKt {
    @NotNull
    private static final String INSTRUMENTATION_SCOPE_NAME = "bazel-bsp";
    private static OpenTelemetrySdk openTelemetry;
    @NotNull
    private static final List<Function0<Unit>> shutdownRoutines;

    @NotNull
    public static final OpenTelemetrySdk getOpenTelemetry() {
        OpenTelemetrySdk openTelemetrySdk = openTelemetry;
        if (openTelemetrySdk != null) {
            return openTelemetrySdk;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"openTelemetry");
        return null;
    }

    public static final boolean getOpenTelemetryInitialized() {
        return openTelemetry != null;
    }

    @NotNull
    public static final Tracer getTracer() {
        Tracer tracer = TelemetryKt.getOpenTelemetry().getTracer(INSTRUMENTATION_SCOPE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)tracer, (String)"getTracer(...)");
        return tracer;
    }

    @NotNull
    public static final Meter getMeter() {
        Meter meter = TelemetryKt.getOpenTelemetry().getMeter(INSTRUMENTATION_SCOPE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        return meter;
    }

    public static final void setupTelemetry(@NotNull TelemetryConfig config) {
        FileExporter fileExporter;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Resource resource = Resource.create((Attributes)Attributes.builder().put(AttributeKey.stringKey((String)"service.name"), (Object)"Bazel-BSP").put(AttributeKey.stringKey((String)"service.version"), (Object)"4.0.1").build());
        OpenTelemetrySdkBuilder sdkBuilder = OpenTelemetrySdk.builder();
        Path path2 = config.getMetricsFile();
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            fileExporter = new FileExporter(it);
        } else {
            fileExporter = null;
        }
        FileExporter fileExporter2 = fileExporter;
        Intrinsics.checkNotNull((Object)sdkBuilder);
        Intrinsics.checkNotNull((Object)resource);
        TelemetryKt.setupTracing(sdkBuilder, resource, config, fileExporter2);
        TelemetryKt.setupMetrics(sdkBuilder, resource, fileExporter2);
        sdkBuilder.setPropagators(ContextPropagators.create((TextMapPropagator)((TextMapPropagator)W3CTraceContextPropagator.getInstance())));
        openTelemetry = sdkBuilder.build();
        if (config.getMetricsFile() != null) {
            MemoryProfiler.INSTANCE.startRecording();
            shutdownRoutines.add(setupTelemetry.1.INSTANCE);
        }
    }

    private static final void setupTracing(OpenTelemetrySdkBuilder sdkBuilder, Resource resource, TelemetryConfig config, FileExporter fileExporter) {
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder();
        tracerProviderBuilder.setResource(resource);
        if (fileExporter != null) {
            tracerProviderBuilder.addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)fileExporter.spanExporter()).build());
        }
        if (config.getOpenTelemetryEndpoint() != null) {
            OtlpHttpSpanExporter httpSpanExporter = OtlpHttpSpanExporter.builder().setEndpoint(config.getOpenTelemetryEndpoint()).build();
            tracerProviderBuilder.addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)((SpanExporter)httpSpanExporter)).build());
        }
        if (config.getBspClientLogger() != null) {
            tracerProviderBuilder.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)new LoggingSpanExporter(config.getBspClientLogger())));
        }
        SdkTracerProvider sdkTracerProvider = tracerProviderBuilder.build();
        shutdownRoutines.add(new Function0<Unit>(sdkTracerProvider){
            final /* synthetic */ SdkTracerProvider $sdkTracerProvider;
            {
                this.$sdkTracerProvider = $sdkTracerProvider;
                super(0);
            }

            public final void invoke() {
                this.$sdkTracerProvider.shutdown();
            }
        });
        sdkBuilder.setTracerProvider(sdkTracerProvider);
    }

    private static final void setupMetrics(OpenTelemetrySdkBuilder sdkBuilder, Resource resource, FileExporter fileExporter) {
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder().setResource(resource);
        if (fileExporter != null) {
            meterProviderBuilder.registerMetricReader((MetricReader)new ShutdownMetricReader(fileExporter.metricExporter()));
        }
        SdkMeterProvider meterProvider = meterProviderBuilder.build();
        shutdownRoutines.add(new Function0<Unit>(meterProvider){
            final /* synthetic */ SdkMeterProvider $meterProvider;
            {
                this.$meterProvider = $meterProvider;
                super(0);
            }

            public final void invoke() {
                this.$meterProvider.shutdown();
            }
        });
        sdkBuilder.setMeterProvider(meterProvider);
    }

    public static final void shutdownTelemetry() {
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable(shutdownRoutines);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    static {
        shutdownRoutines = new ArrayList();
    }
}

