/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bep;

import com.google.devtools.build.lib.buildeventstream.BuildEventStreamProtos;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.commons.Format;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/BepLogger;", "", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "<init>", "(Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;)V", "onProgress", "", "progress", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$Progress;", "onBuildMetrics", "metrics", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$BuildMetrics;", "logMessage", "output", "", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
@SourceDebugExtension(value={"SMAP\nBepLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BepLogger.kt\norg/jetbrains/bsp/bazel/server/bep/BepLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n739#2,9:46\n774#2:55\n865#2,2:56\n*S KotlinDebug\n*F\n+ 1 BepLogger.kt\norg/jetbrains/bsp/bazel/server/bep/BepLogger\n*L\n30#1:46,9\n31#1:55\n31#1:56,2\n*E\n"})
public final class BepLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BspClientLogger bspClientLogger;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final String ADDITIONAL_MESSAGE_PREFIX = "    ";

    public BepLogger(@NotNull BspClientLogger bspClientLogger) {
        Intrinsics.checkNotNullParameter((Object)bspClientLogger, (String)"bspClientLogger");
        this.bspClientLogger = bspClientLogger;
    }

    public final void onProgress(@NotNull BuildEventStreamProtos.Progress progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        String output = progress.getStderr();
        Intrinsics.checkNotNull((Object)output);
        if (!StringsKt.isBlank((CharSequence)output)) {
            this.logMessage(output);
            LOGGER.info(output);
        }
    }

    public final void onBuildMetrics(@NotNull BuildEventStreamProtos.BuildMetrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Duration duration = Duration.ofMillis(metrics.getTimingMetrics().getWallTimeInMs());
        String string = "Command completed in %s";
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)duration);
        objectArray[0] = Format.INSTANCE.duration(duration);
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        this.logMessage(string2);
    }

    /*
     * WARNING - void declaration
     */
    private final void logMessage(String output) {
        void $this$filterTo$iv$iv;
        List list;
        Object iterator$iv;
        this.bspClientLogger.message(output);
        char[] cArray = new char[]{'\n'};
        List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)output, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        iterator$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.startsWith$default((String)it, (String)ADDITIONAL_MESSAGE_PREFIX, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String filteredOutput = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        LOGGER.info(filteredOutput);
    }

    static {
        Logger logger = LogManager.getLogger(BspClientLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/BepLogger$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "ADDITIONAL_MESSAGE_PREFIX", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

