/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bep;

import com.google.common.collect.Queues;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.server.bep.TextProtoDepSet;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BI\u0012\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/BepOutput;", "", "outputGroups", "", "", "", "textProtoFileSets", "Lorg/jetbrains/bsp/bazel/server/bep/TextProtoDepSet;", "rootTargets", "Lorg/jetbrains/bazel/label/Label;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Set;)V", "filesByOutputGroupNameTransitive", "Ljava/nio/file/Path;", "outputGroup", "merge", "anotherBepOutput", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
@SourceDebugExtension(value={"SMAP\nBepOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BepOutput.kt\norg/jetbrains/bsp/bazel/server/bep/BepOutput\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1317#2,2:50\n1279#3,2:52\n1293#3,4:54\n*S KotlinDebug\n*F\n+ 1 BepOutput.kt\norg/jetbrains/bsp/bazel/server/bep/BepOutput\n*L\n30#1:50,2\n41#1:52,2\n41#1:54,4\n*E\n"})
public final class BepOutput {
    @NotNull
    private final Map<String, Set<String>> outputGroups;
    @NotNull
    private final Map<String, TextProtoDepSet> textProtoFileSets;
    @NotNull
    private final Set<Label> rootTargets;

    public BepOutput(@NotNull Map<String, ? extends Set<String>> outputGroups, @NotNull Map<String, TextProtoDepSet> textProtoFileSets, @NotNull Set<? extends Label> rootTargets2) {
        Intrinsics.checkNotNullParameter(outputGroups, (String)"outputGroups");
        Intrinsics.checkNotNullParameter(textProtoFileSets, (String)"textProtoFileSets");
        Intrinsics.checkNotNullParameter(rootTargets2, (String)"rootTargets");
        this.outputGroups = outputGroups;
        this.textProtoFileSets = textProtoFileSets;
        this.rootTargets = rootTargets2;
    }

    public /* synthetic */ BepOutput(Map map, Map map2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        this(map, map2, set);
    }

    @NotNull
    public final Set<Label> rootTargets() {
        return this.rootTargets;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Path> filesByOutputGroupNameTransitive(@NotNull String outputGroup) {
        Intrinsics.checkNotNullParameter((Object)outputGroup, (String)"outputGroup");
        Set<String> rootIds = this.outputGroups.getOrDefault(outputGroup, SetsKt.emptySet());
        if (rootIds.isEmpty()) {
            return SetsKt.emptySet();
        }
        HashSet<Path> result2 = new HashSet<Path>(rootIds.size());
        ArrayDeque toVisit = Queues.newArrayDeque((Iterable)rootIds);
        HashSet<String> visited = new HashSet<String>((Collection)rootIds);
        while (!toVisit.isEmpty()) {
            void $this$forEach$iv;
            TextProtoDepSet fileSet;
            String fileSetId = (String)toVisit.remove();
            TextProtoDepSet textProtoDepSet = fileSet = this.textProtoFileSets.get(fileSetId);
            Intrinsics.checkNotNull((Object)textProtoDepSet);
            result2.addAll(textProtoDepSet.getFiles());
            Collection<String> children = fileSet.getChildren();
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)children), (Function1)((Function1)new Function1<String, Boolean>(visited){
                final /* synthetic */ HashSet<String> $visited;
                {
                    this.$visited = $visited;
                    super(1);
                }

                public final Boolean invoke(String child) {
                    Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                    return !this.$visited.contains(child);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String e = (String)element$iv;
                boolean bl = false;
                visited.add(e);
                toVisit.add(e);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BepOutput merge(@NotNull BepOutput anotherBepOutput) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)anotherBepOutput, (String)"anotherBepOutput");
        Iterable iterable = SetsKt.plus(this.textProtoFileSets.keySet(), (Iterable)anotherBepOutput.textProtoFileSets.keySet());
        Map map = MapsKt.plus(this.outputGroups, anotherBepOutput.outputGroups);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            TextProtoDepSet textProtoDepSet;
            TextProtoDepSet left;
            void k;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            TextProtoDepSet textProtoDepSet2 = this.textProtoFileSets.get(k);
            if (textProtoDepSet2 == null) {
                textProtoDepSet2 = left = new TextProtoDepSet(CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }
            if ((textProtoDepSet = anotherBepOutput.textProtoFileSets.get(k)) == null) {
                textProtoDepSet = new TextProtoDepSet(CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }
            TextProtoDepSet right = textProtoDepSet;
            TextProtoDepSet textProtoDepSet3 = new TextProtoDepSet(CollectionsKt.plus(left.getFiles(), (Iterable)right.getFiles()), CollectionsKt.plus(left.getChildren(), (Iterable)right.getChildren()));
            map2.put(t, textProtoDepSet3);
        }
        Set set = SetsKt.plus(this.rootTargets, (Iterable)anotherBepOutput.rootTargets);
        Map map3 = result$iv;
        Map map4 = map;
        return new BepOutput(map4, map3, set);
    }

    public BepOutput() {
        this(null, null, null, 7, null);
    }
}

