/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bep;

import com.google.devtools.build.lib.buildeventstream.BuildEventStreamProtos;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.ProtocolStringList;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.server.bep.BepOutput;
import org.jetbrains.bsp.bazel.server.bep.BepOutputBuilder;
import org.jetbrains.bsp.bazel.server.bep.TextProtoDepSet;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0006\u0010\u001a\u001a\u00020\u000fJ\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/BepOutputBuilder;", "", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;)V", "outputGroups", "", "", "", "textProtoFileSets", "Lorg/jetbrains/bsp/bazel/server/bep/TextProtoDepSet;", "rootTargets", "Lorg/jetbrains/bazel/label/Label;", "storeNamedSet", "", "id", "namedSetOfFiles", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$NamedSetOfFiles;", "toLocalPath", "Ljava/nio/file/Path;", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$File;", "storeTargetOutputGroups", "target", "", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$OutputGroup;", "clear", "build", "Lorg/jetbrains/bsp/bazel/server/bep/BepOutput;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
@SourceDebugExtension(value={"SMAP\nBepOutputBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BepOutputBuilder.kt\norg/jetbrains/bsp/bazel/server/bep/BepOutputBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n774#2:58\n865#2,2:59\n1557#2:61\n1628#2,3:62\n1557#2:65\n1628#2,3:66\n1557#2:69\n1628#2,3:70\n*S KotlinDebug\n*F\n+ 1 BepOutputBuilder.kt\norg/jetbrains/bsp/bazel/server/bep/BepOutputBuilder\n*L\n25#1:58\n25#1:59,2\n26#1:61\n26#1:62,3\n27#1:65\n27#1:66,3\n44#1:69\n44#1:70,3\n*E\n"})
public final class BepOutputBuilder {
    @NotNull
    private final BazelPathsResolver bazelPathsResolver;
    @NotNull
    private final Map<String, Set<String>> outputGroups;
    @NotNull
    private final Map<String, TextProtoDepSet> textProtoFileSets;
    @NotNull
    private final Set<Label> rootTargets;

    public BepOutputBuilder(@NotNull BazelPathsResolver bazelPathsResolver) {
        Intrinsics.checkNotNullParameter((Object)bazelPathsResolver, (String)"bazelPathsResolver");
        this.bazelPathsResolver = bazelPathsResolver;
        this.outputGroups = new HashMap();
        this.textProtoFileSets = new HashMap();
        this.rootTargets = new HashSet();
    }

    /*
     * WARNING - void declaration
     */
    public final void storeNamedSet(@NotNull String id, @NotNull BuildEventStreamProtos.NamedSetOfFiles namedSetOfFiles) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        GeneratedMessage it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)namedSetOfFiles, (String)"namedSetOfFiles");
        List<BuildEventStreamProtos.File> list = namedSetOfFiles.getFilesList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFilesList(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BuildEventStreamProtos.File)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"bsp-info.textproto", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BuildEventStreamProtos.File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toLocalPath((BuildEventStreamProtos.File)it));
        }
        Collection collection2 = (List)destination$iv$iv;
        List<BuildEventStreamProtos.BuildEventId.NamedSetOfFilesId> list2 = namedSetOfFiles.getFileSetsList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFileSetsList(...)");
        $this$map$iv = list2;
        collection = collection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BuildEventStreamProtos.BuildEventId.NamedSetOfFilesId)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(it.getId());
        }
        Collection collection4 = (List)destination$iv$iv;
        Collection collection5 = collection;
        TextProtoDepSet textProtoDepSet = new TextProtoDepSet(collection5, collection4);
        this.textProtoFileSets.put(id, textProtoDepSet);
    }

    private final Path toLocalPath(BuildEventStreamProtos.File $this$toLocalPath) {
        ProtocolStringList protocolStringList = $this$toLocalPath.getPathPrefixList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getPathPrefixList(...)");
        Iterable iterable = (Iterable)protocolStringList;
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        Path path2 = Paths.get(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path mergedPathPrefix = path2;
        Path bazelOutputRelativePath = mergedPathPrefix.resolve($this$toLocalPath.getName());
        Intrinsics.checkNotNull((Object)bazelOutputRelativePath);
        return this.bazelPathsResolver.resolveOutput(bazelOutputRelativePath);
    }

    /*
     * WARNING - void declaration
     */
    public final void storeTargetOutputGroups(@NotNull Label target, @NotNull List<BuildEventStreamProtos.OutputGroup> outputGroups) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(outputGroups, (String)"outputGroups");
        this.rootTargets.add(target);
        for (BuildEventStreamProtos.OutputGroup group : outputGroups) {
            void $this$mapTo$iv$iv;
            List<BuildEventStreamProtos.BuildEventId.NamedSetOfFilesId> list = group.getFileSetsList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFileSetsList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BuildEventStreamProtos.BuildEventId.NamedSetOfFilesId namedSetOfFilesId = (BuildEventStreamProtos.BuildEventId.NamedSetOfFilesId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            List fileSets = (List)destination$iv$iv;
            Function1 function1 = storeTargetOutputGroups.1.INSTANCE;
            this.outputGroups.computeIfAbsent(group.getName(), new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            }).addAll(fileSets);
        }
    }

    public final void clear() {
        this.outputGroups.clear();
        this.textProtoFileSets.clear();
        this.rootTargets.clear();
    }

    @NotNull
    public final BepOutput build() {
        return new BepOutput(this.outputGroups, this.textProtoFileSets, this.rootTargets);
    }
}

