/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bep;

import ch.epfl.scala.bsp4j.CompileReport;
import ch.epfl.scala.bsp4j.CompileTask;
import ch.epfl.scala.bsp4j.PublishDiagnosticsParams;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TaskFinishParams;
import ch.epfl.scala.bsp4j.TaskId;
import ch.epfl.scala.bsp4j.TaskStartParams;
import ch.epfl.scala.bsp4j.TestStatus;
import com.google.devtools.build.lib.buildeventstream.BuildEventStreamProtos;
import com.google.devtools.build.v1.BuildEvent;
import com.google.devtools.build.v1.PublishBuildEventGrpc;
import com.google.devtools.build.v1.PublishBuildToolEventStreamRequest;
import com.google.devtools.build.v1.PublishBuildToolEventStreamResponse;
import com.google.devtools.build.v1.PublishLifecycleEventRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.ProtocolStringList;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bazel.label.LabelKt;
import org.jetbrains.bsp.bazel.commons.BazelStatus;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.logger.BspClientTestNotifier;
import org.jetbrains.bsp.bazel.server.bep.BepLogger;
import org.jetbrains.bsp.bazel.server.bep.BepOutput;
import org.jetbrains.bsp.bazel.server.bep.BepOutputBuilder;
import org.jetbrains.bsp.bazel.server.bep.BepStreamObserver;
import org.jetbrains.bsp.bazel.server.bep.TestXmlParser;
import org.jetbrains.bsp.bazel.server.diagnostics.DiagnosticsService;
import org.jetbrains.bsp.bazel.server.paths.BazelPathsResolver;
import org.jetbrains.bsp.protocol.JoinedBuildClient;
import org.jetbrains.bsp.protocol.PublishOutputParams;
import org.jetbrains.bsp.protocol.TestCoverageReport;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 C2\u00020\u0001:\u0001CB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020!0\u001dH\u0016J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\f\u0010+\u001a\u00020,*\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010/\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00100\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00101\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00102\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00103\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00104\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00105\u001a\u00020\u00192\u0006\u0010&\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\tH\u0002J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010;\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010?\u001a\u00020@\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/BepServer;", "Lcom/google/devtools/build/v1/PublishBuildEventGrpc$PublishBuildEventImplBase;", "bspClient", "Lorg/jetbrains/bsp/protocol/JoinedBuildClient;", "diagnosticsService", "Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsService;", "originId", "", "target", "Lorg/jetbrains/bazel/label/Label;", "bazelPathsResolver", "Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;", "<init>", "(Lorg/jetbrains/bsp/protocol/JoinedBuildClient;Lorg/jetbrains/bsp/bazel/server/diagnostics/DiagnosticsService;Ljava/lang/String;Lorg/jetbrains/bazel/label/Label;Lorg/jetbrains/bsp/bazel/server/paths/BazelPathsResolver;)V", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "bepLogger", "Lorg/jetbrains/bsp/bazel/server/bep/BepLogger;", "startedEvent", "Lch/epfl/scala/bsp4j/TaskId;", "bspClientTestNotifier", "Lorg/jetbrains/bsp/bazel/logger/BspClientTestNotifier;", "bepOutputBuilder", "Lorg/jetbrains/bsp/bazel/server/bep/BepOutputBuilder;", "publishLifecycleEvent", "", "request", "Lcom/google/devtools/build/v1/PublishLifecycleEventRequest;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lcom/google/protobuf/Empty;", "publishBuildToolEventStream", "Lcom/google/devtools/build/v1/PublishBuildToolEventStreamRequest;", "Lcom/google/devtools/build/v1/PublishBuildToolEventStreamResponse;", "handleEvent", "buildEvent", "Lcom/google/devtools/build/v1/BuildEvent;", "handleBuildEventStreamProtosEvent", "event", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$BuildEvent;", "processTestResult", "processTestSummary", "fetchNamedSet", "intern", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$NamedSetOfFiles;", "processBuildStartedEvent", "processProgressEvent", "processBuildMetrics", "consumeBuildStartedEvent", "processFinishedEvent", "consumeFinishedEvent", "processCompletedEvent", "processActionCompletedEvent", "consumeActionCompletedEvent", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$ActionExecuted;", "processDiagnosticText", "stdErrText", "targetLabel", "consumeCompletedEvent", "processAbortedEvent", "consumeAbortedEvent", "aborted", "Lcom/google/devtools/build/lib/buildeventstream/BuildEventStreamProtos$Aborted;", "bepOutput", "Lorg/jetbrains/bsp/bazel/server/bep/BepOutput;", "getBepOutput", "()Lorg/jetbrains/bsp/bazel/server/bep/BepOutput;", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
@SourceDebugExtension(value={"SMAP\nBepServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BepServer.kt\norg/jetbrains/bsp/bazel/server/bep/BepServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1#2:372\n1557#3:373\n1628#3,2:374\n1557#3:376\n1628#3,3:377\n1630#3:380\n1863#3,2:381\n*S KotlinDebug\n*F\n+ 1 BepServer.kt\norg/jetbrains/bsp/bazel/server/bep/BepServer\n*L\n174#1:373\n174#1:374,2\n181#1:376\n181#1:377,3\n174#1:380\n328#1:381,2\n*E\n"})
public final class BepServer
extends PublishBuildEventGrpc.PublishBuildEventImplBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JoinedBuildClient bspClient;
    @NotNull
    private final DiagnosticsService diagnosticsService;
    @Nullable
    private final String originId;
    @Nullable
    private final Label target;
    @NotNull
    private final BspClientLogger bspClientLogger;
    @NotNull
    private final BepLogger bepLogger;
    @Nullable
    private TaskId startedEvent;
    @Nullable
    private BspClientTestNotifier bspClientTestNotifier;
    @NotNull
    private final BepOutputBuilder bepOutputBuilder;
    @NotNull
    private final BepOutput bepOutput;
    @NotNull
    private static final Logger LOGGER;

    public BepServer(@NotNull JoinedBuildClient bspClient, @NotNull DiagnosticsService diagnosticsService, @Nullable String originId, @Nullable Label target, @NotNull BazelPathsResolver bazelPathsResolver) {
        Intrinsics.checkNotNullParameter((Object)bspClient, (String)"bspClient");
        Intrinsics.checkNotNullParameter((Object)diagnosticsService, (String)"diagnosticsService");
        Intrinsics.checkNotNullParameter((Object)bazelPathsResolver, (String)"bazelPathsResolver");
        this.bspClient = bspClient;
        this.diagnosticsService = diagnosticsService;
        this.originId = originId;
        this.target = target;
        this.bspClientLogger = new BspClientLogger(this.bspClient, null, 2, null);
        this.bepLogger = new BepLogger(this.bspClientLogger);
        this.bepOutputBuilder = new BepOutputBuilder(bazelPathsResolver);
        this.bepOutput = this.bepOutputBuilder.build();
    }

    @Override
    public void publishLifecycleEvent(@NotNull PublishLifecycleEventRequest request, @NotNull StreamObserver<Empty> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        responseObserver.onNext(Empty.getDefaultInstance());
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public StreamObserver<PublishBuildToolEventStreamRequest> publishBuildToolEventStream(@NotNull StreamObserver<PublishBuildToolEventStreamResponse> responseObserver) {
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        return new BepStreamObserver(this, responseObserver);
    }

    public final void handleEvent(@NotNull BuildEvent buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        try {
            BuildEventStreamProtos.BuildEvent event = BuildEventStreamProtos.BuildEvent.parseFrom(buildEvent.getBazelEvent().getValue());
            LOGGER.trace("Got event {}", (Object)event);
            Intrinsics.checkNotNull((Object)event);
            this.handleBuildEventStreamProtosEvent(event);
        }
        catch (IOException e) {
            LOGGER.error("Error deserializing BEP proto: {}", (Object)e.toString());
        }
    }

    public final void handleBuildEventStreamProtosEvent(@NotNull BuildEventStreamProtos.BuildEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processBuildStartedEvent(event);
        this.processProgressEvent(event);
        this.processBuildMetrics(event);
        this.processFinishedEvent(event);
        this.processActionCompletedEvent(event);
        this.fetchNamedSet(event);
        this.processCompletedEvent(event);
        this.processAbortedEvent(event);
        this.processTestResult(event);
        this.processTestSummary(event);
    }

    private final void processTestResult(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasTestResult()) {
            String testXmlUri;
            Object v8;
            TestStatus testStatus;
            BspClientTestNotifier bspClientTestNotifier;
            TaskId taskId;
            block19: {
                String coverageReportUri;
                Object v3;
                Object object2;
                BuildEventStreamProtos.TestResult testResult;
                block18: {
                    taskId = this.startedEvent;
                    bspClientTestNotifier = this.bspClientTestNotifier;
                    if (this.originId == null || taskId == null || bspClientTestNotifier == null) {
                        return;
                    }
                    testResult = event.getTestResult();
                    BuildEventStreamProtos.TestStatus testStatus2 = testResult.getStatus();
                    testStatus = switch (testStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[testStatus2.ordinal()]) {
                        case 1 -> TestStatus.SKIPPED;
                        case 2 -> TestStatus.PASSED;
                        case 3 -> TestStatus.FAILED;
                        case 4 -> TestStatus.FAILED;
                        case 5 -> TestStatus.FAILED;
                        case 6 -> TestStatus.SKIPPED;
                        case 7 -> TestStatus.IGNORED;
                        case 8 -> TestStatus.CANCELLED;
                        case 9 -> TestStatus.SKIPPED;
                        default -> TestStatus.FAILED;
                    };
                    List<BuildEventStreamProtos.File> list = testResult.getTestActionOutputList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getTestActionOutputList(...)");
                    Iterable iterable = list;
                    for (Object object2 : iterable) {
                        BuildEventStreamProtos.File it = (BuildEventStreamProtos.File)object2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"test.lcov")) continue;
                        v3 = object2;
                        break block18;
                    }
                    v3 = null;
                }
                BuildEventStreamProtos.File file = v3;
                String string = coverageReportUri = file != null ? file.getUri() : null;
                if (coverageReportUri != null) {
                    String string2 = event.getId().getTestResult().getLabel();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLabel(...)");
                    this.bspClient.onBuildPublishOutput(new PublishOutputParams(this.originId, taskId, LabelKt.toBspIdentifier(Label.Companion.parse(string2)), "coverage-report", new TestCoverageReport(coverageReportUri)));
                }
                List<BuildEventStreamProtos.File> list = testResult.getTestActionOutputList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTestActionOutputList(...)");
                Iterable iterable = list;
                object2 = iterable.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    BuildEventStreamProtos.File it = (BuildEventStreamProtos.File)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"test.xml")) continue;
                    v8 = e;
                    break block19;
                }
                v8 = null;
            }
            BuildEventStreamProtos.File file = v8;
            String string = testXmlUri = file != null ? file.getUri() : null;
            if (testXmlUri != null) {
                new TestXmlParser(bspClientTestNotifier).parseAndReport(testXmlUri);
            } else {
                TaskId childId = new TaskId(UUID.randomUUID().toString());
                childId.setParents(CollectionsKt.listOf((Object)taskId.getId()));
                bspClientTestNotifier.startTest("Test", childId);
                BspClientTestNotifier.finishTest$default(bspClientTestNotifier, "Test", childId, testStatus, "Test finished", null, null, 48, null);
            }
        }
    }

    private final void processTestSummary(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasTestSummary()) {
            // empty if block
        }
    }

    private final void fetchNamedSet(BuildEventStreamProtos.BuildEvent event) {
        if (event.getId().hasNamedSet()) {
            BuildEventStreamProtos.NamedSetOfFiles namedSetOfFiles = event.getNamedSetOfFiles();
            Intrinsics.checkNotNullExpressionValue((Object)namedSetOfFiles, (String)"getNamedSetOfFiles(...)");
            BuildEventStreamProtos.NamedSetOfFiles internedNamedSetOfFiles = this.intern(namedSetOfFiles);
            String string = event.getId().getNamedSet().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            this.bepOutputBuilder.storeNamedSet(string, internedNamedSetOfFiles);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BuildEventStreamProtos.NamedSetOfFiles intern(BuildEventStreamProtos.NamedSetOfFiles $this$intern) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BuildEventStreamProtos.NamedSetOfFiles.Builder builder = $this$intern.toBuilder().clearFiles();
        List<BuildEventStreamProtos.File> list = $this$intern.getFilesList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFilesList(...)");
        Iterable iterable = list;
        BuildEventStreamProtos.NamedSetOfFiles.Builder builder2 = builder;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void file;
            BuildEventStreamProtos.File file2 = (BuildEventStreamProtos.File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BuildEventStreamProtos.File.Builder builder3 = file.toBuilder();
            String string = file.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
            String string2 = string.intern();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"intern(...)");
            BuildEventStreamProtos.File.Builder builder4 = builder3.setUri(string2);
            String string3 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            String string4 = string3.intern();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"intern(...)");
            BuildEventStreamProtos.File.Builder builder5 = builder4.setName(string4).clearPathPrefix();
            ProtocolStringList protocolStringList = file.getPathPrefixList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getPathPrefixList(...)");
            Iterable iterable2 = (Iterable)protocolStringList;
            BuildEventStreamProtos.File.Builder builder6 = builder5;
            boolean $i$f$map2 = false;
            void var15_15 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string5 = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                String string6 = it.intern();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"intern(...)");
                collection2.add(string6);
            }
            collection.add(builder6.addAllPathPrefix((List)destination$iv$iv2).build());
        }
        BuildEventStreamProtos.NamedSetOfFiles namedSetOfFiles = builder2.addAllFiles((List)destination$iv$iv).build();
        Intrinsics.checkNotNullExpressionValue((Object)namedSetOfFiles, (String)"build(...)");
        return namedSetOfFiles;
    }

    private final void processBuildStartedEvent(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasStarted()) {
            this.consumeBuildStartedEvent(event);
        }
    }

    private final void processProgressEvent(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasProgress()) {
            // empty if block
        }
    }

    private final void processBuildMetrics(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasBuildMetrics()) {
            BuildEventStreamProtos.BuildMetrics buildMetrics = event.getBuildMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)buildMetrics, (String)"getBuildMetrics(...)");
            this.bepLogger.onBuildMetrics(buildMetrics);
        }
    }

    private final void consumeBuildStartedEvent(BuildEventStreamProtos.BuildEvent event) {
        Label label;
        this.bepOutputBuilder.clear();
        TaskId taskId = new TaskId(event.getStarted().getUuid());
        TaskStartParams startParams = new TaskStartParams(taskId);
        String string = event.getId().getTestResult().getLabel();
        if (string != null) {
            String it = string;
            boolean bl = false;
            label = ((CharSequence)it).length() > 0 ? Label.Companion.parse(it) : this.target;
        } else {
            label = null;
        }
        Label target = label;
        startParams.setEventTime(Long.valueOf(event.getStarted().getStartTimeMillis()));
        startParams.setOriginId(this.originId);
        if (Intrinsics.areEqual((Object)event.getStarted().getCommand(), (Object)"build")) {
            if (target != null) {
                startParams.setDataKind("compile-task");
                CompileTask task = new CompileTask(LabelKt.toBspIdentifier(target));
                startParams.setData((Object)task);
            }
            this.bspClient.onBuildTaskStart(startParams);
        } else if (Intrinsics.areEqual((Object)event.getStarted().getCommand(), (Object)"test") || Intrinsics.areEqual((Object)event.getStarted().getCommand(), (Object)"coverage")) {
            BspClientTestNotifier bspClientTestNotifier;
            if (this.originId == null) {
                return;
            }
            this.bspClientTestNotifier = bspClientTestNotifier = new BspClientTestNotifier(this.bspClient, this.originId);
            bspClientTestNotifier.beginTestTarget(target, taskId);
        }
        this.startedEvent = taskId;
    }

    private final void processFinishedEvent(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasFinished()) {
            this.consumeFinishedEvent(event);
        }
    }

    private final void consumeFinishedEvent(BuildEventStreamProtos.BuildEvent event) {
        Label target;
        TaskId taskId = this.startedEvent;
        String string = event.getId().getTestResult().getLabel();
        if (string != null) {
            String it = string;
            boolean bl = false;
            v0 = ((CharSequence)it).length() > 0 ? Label.Companion.parse(it) : this.target;
        } else {
            v0 = target = null;
        }
        if (taskId == null) {
            LOGGER.warn("No start event id was found. Origin id: {}", (Object)this.originId);
            return;
        }
        BspClientTestNotifier bspClientTestNotifier = this.bspClientTestNotifier;
        if (bspClientTestNotifier != null) {
            BspClientTestNotifier.endTestTarget$default(bspClientTestNotifier, target, taskId, null, 4, null);
            this.bspClientTestNotifier = null;
            return;
        }
        StatusCode statusCode = BazelStatus.Companion.fromExitCode(event.getFinished().getExitCode().getCode()).toBspStatusCode();
        TaskFinishParams finishParams = new TaskFinishParams(taskId, statusCode);
        finishParams.setOriginId(this.originId);
        finishParams.setEventTime(Long.valueOf(event.getFinished().getFinishTimeMillis()));
        if (target != null) {
            finishParams.setDataKind("compile-report");
            boolean isSuccess = statusCode.getValue() == 1;
            int errors = isSuccess ? 0 : 1;
            CompileReport report = new CompileReport(LabelKt.toBspIdentifier(target), Integer.valueOf(errors), Integer.valueOf(0));
            finishParams.setData((Object)report);
        }
        this.bspClient.onBuildTaskFinish(finishParams);
    }

    private final void processCompletedEvent(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasCompleted()) {
            this.consumeCompletedEvent(event);
        }
    }

    private final void processActionCompletedEvent(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasAction()) {
            BuildEventStreamProtos.ActionExecuted actionExecuted = event.getAction();
            Intrinsics.checkNotNullExpressionValue((Object)actionExecuted, (String)"getAction(...)");
            this.consumeActionCompletedEvent(actionExecuted);
        }
    }

    private final void consumeActionCompletedEvent(BuildEventStreamProtos.ActionExecuted event) {
        String string = event.getLabel();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabel(...)");
        Label label = Label.Companion.parse(string);
        BuildEventStreamProtos.File.FileCase fileCase = event.getStderr().getFileCase();
        switch (fileCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[fileCase.ordinal()]) {
            case 1: {
                try {
                    Path path2 = Paths.get(URI.create(event.getStderr().getUri()));
                    String stdErrText = Files.readString(path2);
                    Intrinsics.checkNotNull((Object)stdErrText);
                    this.processDiagnosticText(stdErrText, label);
                }
                catch (FileSystemNotFoundException e) {
                    LOGGER.warn((Object)e);
                }
                catch (IOException e) {
                    LOGGER.warn((Object)e);
                }
                break;
            }
            case 2: {
                String string2 = event.getStderr().getContents().toStringUtf8();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toStringUtf8(...)");
                this.processDiagnosticText(string2, label);
            }
        }
    }

    private final void processDiagnosticText(String stdErrText, Label targetLabel) {
        if (((CharSequence)stdErrText).length() > 0) {
            List<PublishDiagnosticsParams> events = this.diagnosticsService.extractDiagnostics(stdErrText, targetLabel, this.originId);
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PublishDiagnosticsParams it = (PublishDiagnosticsParams)element$iv;
                boolean bl = false;
                this.bspClient.onBuildPublishDiagnostics(it);
            }
        }
    }

    private final void consumeCompletedEvent(BuildEventStreamProtos.BuildEvent event) {
        Label eventLabel;
        Label label = eventLabel = Label.Companion.parseOrNull(event.getId().getTargetCompleted().getLabel());
        if (label == null) {
            BepServer $this$consumeCompletedEvent_u24lambda_u247 = this;
            boolean bl = false;
            LOGGER.warn("No target label found in event {}", (Object)event);
            return;
        }
        Label label2 = label;
        BuildEventStreamProtos.TargetComplete targetComplete = event.getCompleted();
        List<BuildEventStreamProtos.OutputGroup> outputGroups = targetComplete.getOutputGroupList();
        LOGGER.trace("Consuming target completed event {}", (Object)targetComplete);
        Intrinsics.checkNotNull(outputGroups);
        this.bepOutputBuilder.storeTargetOutputGroups(label2, outputGroups);
    }

    private final void processAbortedEvent(BuildEventStreamProtos.BuildEvent event) {
        if (event.hasAborted()) {
            BuildEventStreamProtos.Aborted aborted = event.getAborted();
            Intrinsics.checkNotNullExpressionValue((Object)aborted, (String)"getAborted(...)");
            this.consumeAbortedEvent(aborted);
        }
    }

    private final void consumeAbortedEvent(BuildEventStreamProtos.Aborted aborted) {
        if (aborted.getReason() != BuildEventStreamProtos.Aborted.AbortReason.NO_BUILD) {
            LOGGER.warn("Command aborted with reason {}: {}", (Object)aborted.getReason(), (Object)aborted.getDescription());
        }
    }

    @NotNull
    public final BepOutput getBepOutput() {
        return this.bepOutput;
    }

    static {
        Logger logger = LogManager.getLogger(BepServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/BepServer$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BuildEventStreamProtos.TestStatus.values().length];
            try {
                nArray[BuildEventStreamProtos.TestStatus.NO_STATUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.TestStatus.PASSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.TestStatus.FLAKY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.TestStatus.TIMEOUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.TestStatus.FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.TestStatus.INCOMPLETE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.TestStatus.REMOTE_FAILURE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.TestStatus.FAILED_TO_BUILD.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.TestStatus.TOOL_HALTED_BEFORE_TESTING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BuildEventStreamProtos.File.FileCase.values().length];
            try {
                nArray[BuildEventStreamProtos.File.FileCase.URI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildEventStreamProtos.File.FileCase.CONTENTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

