/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bep;

import ch.epfl.scala.bsp4j.TaskId;
import ch.epfl.scala.bsp4j.TestStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.logger.BspClientTestNotifier;
import org.jetbrains.bsp.bazel.server.bep.Junit5TestVisualOutputParserKt;
import org.jetbrains.bsp.bazel.server.bep.StartedBuildTarget;
import org.jetbrains.bsp.bazel.server.bep.TestOutputLine;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0002J\b\u0010!\u001a\u00020\fH\u0002J\f\u0010\"\u001a\u00020#*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/Junit5TestVisualOutputParser;", "", "bspClientTestNotifier", "Lorg/jetbrains/bsp/bazel/logger/BspClientTestNotifier;", "<init>", "(Lorg/jetbrains/bsp/bazel/logger/BspClientTestNotifier;)V", "startedSuites", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/bsp/bazel/server/bep/TestOutputLine;", "processTestOutput", "", "output", "", "processTestingEndingLine", "previousOutputLine", "testingEndedMatcher", "Ljava/util/regex/Matcher;", "startedBuildTarget", "Lorg/jetbrains/bsp/bazel/server/bep/StartedBuildTarget;", "processPreviousOutputLine", "currentOutputLine", "removeAllFinishedSuites", "getCurrentOutputLine", "line", "parseStartedBuildTarget", "beginTesting", "startSuite", "suite", "finishTopmostSuite", "startAndFinishTest", "test", "generateParentList", "", "testUUID", "toTestStatus", "Lch/epfl/scala/bsp4j/TestStatus;", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
@SourceDebugExtension(value={"SMAP\nJunit5TestVisualOutputParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Junit5TestVisualOutputParser.kt\norg/jetbrains/bsp/bazel/server/bep/Junit5TestVisualOutputParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1863#2,2:173\n1611#2,9:176\n1863#2:185\n1864#2:187\n1620#2:188\n1#3:175\n1#3:186\n*S KotlinDebug\n*F\n+ 1 Junit5TestVisualOutputParser.kt\norg/jetbrains/bsp/bazel/server/bep/Junit5TestVisualOutputParser\n*L\n22#1:173,2\n129#1:176,9\n129#1:185\n129#1:187\n129#1:188\n129#1:186\n*E\n"})
public final class Junit5TestVisualOutputParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BspClientTestNotifier bspClientTestNotifier;
    @NotNull
    private final ArrayDeque<TestOutputLine> startedSuites;

    public Junit5TestVisualOutputParser(@NotNull BspClientTestNotifier bspClientTestNotifier) {
        Intrinsics.checkNotNullParameter((Object)bspClientTestNotifier, (String)"bspClientTestNotifier");
        this.bspClientTestNotifier = bspClientTestNotifier;
        this.startedSuites = new ArrayDeque();
    }

    public final void processTestOutput(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        StartedBuildTarget startedBuildTarget = null;
        TestOutputLine previousOutputLine = null;
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)output);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (startedBuildTarget == null) {
                startedBuildTarget = this.parseStartedBuildTarget(it);
                continue;
            }
            Matcher testingEndedMatcher = Junit5TestVisualOutputParserKt.access$getTestingEndedPattern$p().matcher(it);
            TestOutputLine currentOutputLine = this.getCurrentOutputLine(it);
            if (currentOutputLine != null) {
                this.processPreviousOutputLine(previousOutputLine, currentOutputLine);
                previousOutputLine = currentOutputLine;
                continue;
            }
            if (!testingEndedMatcher.find()) continue;
            Intrinsics.checkNotNull((Object)testingEndedMatcher);
            this.processTestingEndingLine(previousOutputLine, testingEndedMatcher, startedBuildTarget);
            startedBuildTarget = null;
        }
    }

    private final void processTestingEndingLine(TestOutputLine previousOutputLine, Matcher testingEndedMatcher, StartedBuildTarget startedBuildTarget) {
        TestOutputLine testOutputLine = previousOutputLine;
        if (testOutputLine != null) {
            TestOutputLine it = testOutputLine;
            boolean bl = false;
            this.startAndFinishTest(it);
        }
        while (!((Collection)this.startedSuites).isEmpty()) {
            this.finishTopmostSuite();
        }
        String string = testingEndedMatcher.group("time");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        Long l = StringsKt.toLongOrNull((String)string);
        long time = l != null ? l : 0L;
    }

    private final void processPreviousOutputLine(TestOutputLine previousOutputLine, TestOutputLine currentOutputLine) {
        if (previousOutputLine != null) {
            if (currentOutputLine.getIndent() > previousOutputLine.getIndent()) {
                this.startSuite(previousOutputLine);
            } else {
                this.startAndFinishTest(previousOutputLine);
                this.removeAllFinishedSuites(currentOutputLine);
            }
        }
    }

    private final void removeAllFinishedSuites(TestOutputLine currentOutputLine) {
        while (!((Collection)this.startedSuites).isEmpty() && ((TestOutputLine)this.startedSuites.last()).getIndent() >= currentOutputLine.getIndent()) {
            this.finishTopmostSuite();
        }
    }

    private final TestOutputLine getCurrentOutputLine(String line) {
        TestOutputLine testOutputLine;
        String cleanLine = Junit5TestVisualOutputParserKt.access$removeFormat(line);
        Matcher currentLineMatcher = Junit5TestVisualOutputParserKt.access$getTestLinePattern$p().matcher(cleanLine);
        if (currentLineMatcher.find()) {
            String string = currentLineMatcher.group("name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = currentLineMatcher.group("result");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            TestStatus testStatus = this.toTestStatus(string2);
            String string3 = currentLineMatcher.group("message");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            testOutputLine = new TestOutputLine(string, testStatus, string3, currentLineMatcher.start("name"), new TaskId(this.testUUID()));
        } else {
            testOutputLine = null;
        }
        return testOutputLine;
    }

    private final StartedBuildTarget parseStartedBuildTarget(String line) {
        StartedBuildTarget startedBuildTarget;
        Matcher testingStartMatcher = Junit5TestVisualOutputParserKt.access$getTestingStartPattern$p().matcher(line);
        if (testingStartMatcher.find()) {
            StartedBuildTarget startedBuildTarget2;
            String string = testingStartMatcher.group("target");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            StartedBuildTarget it = startedBuildTarget2 = new StartedBuildTarget(string, new TaskId(this.testUUID()));
            boolean bl = false;
            this.beginTesting(it);
            startedBuildTarget = startedBuildTarget2;
        } else {
            startedBuildTarget = null;
        }
        return startedBuildTarget;
    }

    private final void beginTesting(StartedBuildTarget startedBuildTarget) {
        this.bspClientTestNotifier.beginTestTarget(Label.Companion.parse(startedBuildTarget.getUri()), startedBuildTarget.getTaskId());
    }

    private final void startSuite(TestOutputLine suite) {
        this.bspClientTestNotifier.startTest(suite.getName(), suite.getTaskId());
        this.startedSuites.addLast((Object)suite);
    }

    private final void finishTopmostSuite() {
        TestOutputLine testOutputLine = (TestOutputLine)this.startedSuites.removeLastOrNull();
        if (testOutputLine == null) {
            return;
        }
        TestOutputLine $this$finishTopmostSuite_u24lambda_u243 = testOutputLine;
        boolean bl = false;
        BspClientTestNotifier.finishTest$default(this.bspClientTestNotifier, $this$finishTopmostSuite_u24lambda_u243.getName(), $this$finishTopmostSuite_u24lambda_u243.getTaskId(), $this$finishTopmostSuite_u24lambda_u243.getStatus(), $this$finishTopmostSuite_u24lambda_u243.getMessage(), null, null, 48, null);
    }

    private final void startAndFinishTest(TestOutputLine test2) {
        test2.getTaskId().setParents(this.generateParentList());
        this.bspClientTestNotifier.startTest(test2.getName(), test2.getTaskId());
        this.bspClientTestNotifier.finishTest(test2.getName(), test2.getTaskId(), test2.getStatus(), test2.getMessage(), "junit-style-test-case-data", Junit5TestVisualOutputParserKt.access$createTestCaseData(test2.getMessage()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateParentList() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.reversed((Iterable)CollectionsKt.toList((Iterable)((Iterable)this.startedSuites)));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TestOutputLine it = (TestOutputLine)element$iv$iv;
            boolean bl2 = false;
            if (it.getTaskId().getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String testUUID() {
        return "test-" + UUID.randomUUID();
    }

    private final TestStatus toTestStatus(String $this$toTestStatus) {
        String string = $this$toTestStatus;
        return Intrinsics.areEqual((Object)string, (Object)"\u2714") ? TestStatus.PASSED : (Intrinsics.areEqual((Object)string, (Object)"\u2718") ? TestStatus.FAILED : TestStatus.SKIPPED);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/Junit5TestVisualOutputParser$Companion;", "", "<init>", "()V", "textContainsJunit5VisualOutput", "", "text", "", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean textContainsJunit5VisualOutput(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int n = 9591;
            return StringsKt.contains$default((CharSequence)text, (char)((char)n), (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

