/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bep;

import ch.epfl.scala.bsp4j.TaskId;
import ch.epfl.scala.bsp4j.TestStatus;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.File;
import java.net.URI;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.logger.BspClientTestNotifier;
import org.jetbrains.bsp.bazel.server.bep.FallbackTestXmlParser;
import org.jetbrains.bsp.bazel.server.bep.TestCase;
import org.jetbrains.bsp.bazel.server.bep.TestSuite;
import org.jetbrains.bsp.bazel.server.bep.TestSuites;
import org.jetbrains.bsp.protocol.JUnitStyleTestCaseData;
import org.jetbrains.bsp.protocol.JUnitStyleTestSuiteData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ+\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/bsp/bazel/server/bep/TestXmlParser;", "", "bspClientTestNotifier", "Lorg/jetbrains/bsp/bazel/logger/BspClientTestNotifier;", "<init>", "(Lorg/jetbrains/bsp/bazel/logger/BspClientTestNotifier;)V", "fallbackTestXmlParser", "Lorg/jetbrains/bsp/bazel/server/bep/FallbackTestXmlParser;", "parseAndReport", "", "testXmlUri", "", "parseTestXml", "T", "uri", "valueType", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "processSuite", "suite", "Lorg/jetbrains/bsp/bazel/server/bep/TestSuite;", "processTestCase", "parentId", "testCase", "Lorg/jetbrains/bsp/bazel/server/bep/TestCase;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bep-bep"})
@SourceDebugExtension(value={"SMAP\nTestXmlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestXmlParser.kt\norg/jetbrains/bsp/bazel/server/bep/TestXmlParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n1863#2,2:341\n1863#2,2:343\n1863#2,2:346\n1#3:345\n*S KotlinDebug\n*F\n+ 1 TestXmlParser.kt\norg/jetbrains/bsp/bazel/server/bep/TestXmlParser\n*L\n104#1:341,2\n108#1:343,2\n152#1:346,2\n*E\n"})
public final class TestXmlParser {
    @NotNull
    private BspClientTestNotifier bspClientTestNotifier;
    @NotNull
    private final FallbackTestXmlParser fallbackTestXmlParser;

    public TestXmlParser(@NotNull BspClientTestNotifier bspClientTestNotifier) {
        Intrinsics.checkNotNullParameter((Object)bspClientTestNotifier, (String)"bspClientTestNotifier");
        this.bspClientTestNotifier = bspClientTestNotifier;
        this.fallbackTestXmlParser = new FallbackTestXmlParser(this.bspClientTestNotifier);
    }

    public final void parseAndReport(@NotNull String testXmlUri) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)testXmlUri, (String)"testXmlUri");
                TestSuites testSuites = this.parseTestXml(testXmlUri, TestSuites.class);
                if (testSuites == null) break block2;
                Iterable $this$forEach$iv = testSuites.getTestsuite();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TestSuite it = (TestSuite)element$iv;
                    boolean bl = false;
                    this.processSuite(it);
                }
                break block3;
            }
            FallbackTestXmlParser.IncompleteTestSuites fallbackTestSuites = this.parseTestXml(testXmlUri, FallbackTestXmlParser.IncompleteTestSuites.class);
            Object object = fallbackTestSuites;
            if (object == null || (object = ((FallbackTestXmlParser.IncompleteTestSuites)object).getTestsuite()) == null) break block3;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FallbackTestXmlParser.IncompleteTestSuite it = (FallbackTestXmlParser.IncompleteTestSuite)element$iv;
                boolean bl = false;
                this.fallbackTestXmlParser.processIncompleteInfoSuite(it);
            }
        }
    }

    private final <T> T parseTestXml(String uri, Class<T> valueType) {
        Object object;
        XmlMapper xmlMapper;
        XmlMapper $this$parseTestXml_u24lambda_u242 = xmlMapper = new XmlMapper();
        boolean bl = false;
        ExtensionsKt.registerKotlinModule((ObjectMapper)((ObjectMapper)$this$parseTestXml_u24lambda_u242));
        $this$parseTestXml_u24lambda_u242.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        XmlMapper xmlMapper2 = xmlMapper;
        String rawContent = null;
        rawContent = FilesKt.readText$default((File)new File(URI.create(uri)), null, (int)1, null);
        rawContent = StringsKt.replace$default((String)rawContent, (String)"<skipped />", (String)"<skipped></skipped>", (boolean)false, (int)4, null);
        Object object2 = this;
        try {
            TestXmlParser $this$parseTestXml_u24lambda_u243 = object2;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)xmlMapper2.readValue(rawContent, valueType));
        }
        catch (Throwable bl2) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl3 = false;
        }
        Object testSuites = Result.isFailure-impl((Object)object2) ? null : object2;
        return (T)testSuites;
    }

    private final void processSuite(TestSuite suite) {
        TaskId suiteTaskId = new TaskId(UUID.randomUUID().toString());
        suiteTaskId.setParents(CollectionsKt.emptyList());
        Object object = suite.getSystemErr();
        JUnitStyleTestSuiteData suiteData = new JUnitStyleTestSuiteData(suite.getTime(), null, object != null ? object.toString() : null);
        TestStatus suiteStatus = suite.getFailures() > 0 ? TestStatus.FAILED : (suite.getErrors() > 0 ? TestStatus.FAILED : TestStatus.PASSED);
        this.bspClientTestNotifier.startTest(suite.getName(), suiteTaskId);
        Iterable $this$forEach$iv = suite.getTestcase();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestCase testCase = (TestCase)element$iv;
            boolean bl = false;
            String string = suiteTaskId.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            this.processTestCase(string, testCase);
        }
        this.bspClientTestNotifier.finishTest(suite.getName(), suiteTaskId, suiteStatus, String.valueOf(suite.getSystemOut()), "junit-style-test-suite-data", suiteData);
    }

    private final void processTestCase(String parentId, TestCase testCase) {
        TaskId testCaseTaskId = new TaskId(UUID.randomUUID().toString());
        testCaseTaskId.setParents(CollectionsKt.listOf((Object)parentId));
        String outcomeMessage = testCase.getError() != null ? testCase.getError().getMessage() : (testCase.getFailure() != null ? testCase.getFailure().getMessage() : (testCase.getSkipped() != null ? testCase.getSkipped().getMessage() : null));
        String fullOutput = testCase.getError() != null ? testCase.getError().getContent() : (testCase.getFailure() != null ? testCase.getFailure().getContent() : (testCase.getSkipped() != null ? testCase.getSkipped().getContent() : ""));
        TestStatus testStatusOutcome = testCase.getError() != null ? TestStatus.FAILED : (testCase.getFailure() != null ? TestStatus.FAILED : (testCase.getSkipped() != null ? TestStatus.SKIPPED : TestStatus.PASSED));
        String errorType = testCase.getError() != null ? testCase.getError().getType() : (testCase.getFailure() != null ? testCase.getFailure().getType() : null);
        JUnitStyleTestCaseData testCaseData = new JUnitStyleTestCaseData(testCase.getTime(), testCase.getClassname(), outcomeMessage, fullOutput, errorType);
        this.bspClientTestNotifier.startTest(testCase.getName(), testCaseTaskId);
        this.bspClientTestNotifier.finishTest(testCase.getName(), testCaseTaskId, testStatusOutcome, "", "junit-style-test-case-data", testCaseData);
    }
}

