/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bsp;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bsp.bazel.server.bsp.BazelBspServerLifetime;
import org.jetbrains.bsp.bazel.server.bsp.BspRequestsRunner;
import org.jetbrains.bsp.bazel.server.bsp.CancellableFuture;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JG\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\b0\r2\u0006\u0010\u000f\u001a\u0002H\t\u00a2\u0006\u0002\u0010\u0010J.\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\b0\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0014JJ\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\b0\u00112\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u00070\u0011J\u001e\u0010\u0017\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0018\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000bJ0\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\t0\u0011H\u0002J)\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\u001eJ$\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/BspRequestsRunner;", "", "serverLifetime", "Lorg/jetbrains/bsp/bazel/server/bsp/BazelBspServerLifetime;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/bsp/BazelBspServerLifetime;)V", "handleRequest", "Ljava/util/concurrent/CompletableFuture;", "R", "T", "methodName", "", "function", "Lkotlin/Function2;", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "arg", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Function1;", "handleNotification", "", "Lkotlin/Function0;", "supplier", "precondition", "serverIsRunning", "serverIsInitialized", "serverIsNotFinished", "runAsync", "request", "success", "response", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;", "failure", "error", "Lorg/eclipse/lsp4j/jsonrpc/messages/ResponseError;", "throwable", "", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp-bsp"})
public final class BspRequestsRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BazelBspServerLifetime serverLifetime;
    private static final Logger LOGGER = LogManager.getLogger(BspRequestsRunner.class);

    public BspRequestsRunner(@NotNull BazelBspServerLifetime serverLifetime) {
        Intrinsics.checkNotNullParameter((Object)serverLifetime, (String)"serverLifetime");
        this.serverLifetime = serverLifetime;
    }

    @NotNull
    public final <T, R> CompletableFuture<R> handleRequest(@NotNull String methodName, @NotNull Function2<? super CancelChecker, ? super T, ? extends R> function, T arg) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        LOGGER.info("{} call with param: {}", (Object)methodName, arg);
        CompletableFuture<T> completableFuture = this.serverIsRunning(methodName);
        if (completableFuture == null) {
            completableFuture = this.runAsync(methodName, (Function1)new Function1<CancelChecker, R>(function, arg){
                final /* synthetic */ Function2<CancelChecker, T, R> $function;
                final /* synthetic */ T $arg;
                {
                    this.$function = $function;
                    this.$arg = $arg;
                    super(1);
                }

                public final R invoke(CancelChecker it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (R)this.$function.invoke((Object)it, this.$arg);
                }
            });
        }
        return completableFuture;
    }

    @NotNull
    public final <R> CompletableFuture<R> handleRequest(@NotNull String methodName, @NotNull Function1<? super CancelChecker, ? extends R> function) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        LOGGER.info("{} call", (Object)methodName);
        CompletableFuture<Object> completableFuture = this.serverIsRunning(methodName);
        if (completableFuture == null) {
            completableFuture = this.runAsync(methodName, function);
        }
        return completableFuture;
    }

    public final void handleNotification(@NotNull String methodName, @NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        LOGGER.info("{} call", (Object)methodName);
        function.invoke();
    }

    @NotNull
    public final <R> CompletableFuture<R> handleRequest(@NotNull String methodName, @NotNull Function1<? super CancelChecker, ? extends R> supplier, @NotNull Function1<? super String, ? extends CompletableFuture<R>> precondition) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        Intrinsics.checkNotNullParameter(precondition, (String)"precondition");
        LOGGER.info("{} call", (Object)methodName);
        CompletableFuture<R> completableFuture = (CompletableFuture<R>)precondition.invoke((Object)methodName);
        if (completableFuture == null) {
            completableFuture = this.runAsync(methodName, supplier);
        }
        return completableFuture;
    }

    private final <T> CompletableFuture<T> serverIsRunning(String methodName) {
        CompletableFuture<T> completableFuture = this.serverIsInitialized(methodName);
        if (completableFuture == null) {
            completableFuture = this.serverIsNotFinished(methodName);
        }
        return completableFuture;
    }

    @Nullable
    public final <T> CompletableFuture<T> serverIsInitialized(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return !this.serverLifetime.isInitialized() ? this.failure(methodName, new ResponseError(ResponseErrorCode.ServerNotInitialized, "Server has not been initialized yet!", (Object)false)) : null;
    }

    @Nullable
    public final <T> CompletableFuture<T> serverIsNotFinished(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return this.serverLifetime.isFinished() ? this.failure(methodName, new ResponseError(ResponseErrorCode.ServerNotInitialized, "Server has already shutdown!", (Object)false)) : null;
    }

    private final <T> CompletableFuture<T> runAsync(String methodName, Function1<? super CancelChecker, ? extends T> request) {
        Context telemetryContext = Context.current();
        CompletableFuture asyncRequest2 = CompletableFutures.computeAsync((Function)new Function(telemetryContext, request){
            final /* synthetic */ Context $telemetryContext;
            final /* synthetic */ Function1<CancelChecker, T> $request;
            {
                this.$telemetryContext = $telemetryContext;
                this.$request = $request;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T apply(CancelChecker cancelChecker) {
                Object object;
                AutoCloseable autoCloseable = (AutoCloseable)this.$telemetryContext.makeCurrent();
                Function1<CancelChecker, T> function1 = this.$request;
                Throwable throwable = null;
                try {
                    Scope it = (Scope)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)cancelChecker);
                    object = function1.invoke((Object)cancelChecker);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return (T)object;
            }
        });
        Function1 function1 = runAsync.1.INSTANCE;
        Function function = new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        };
        function1 = new Function1<Either<Throwable, T>, CompletionStage<T>>(this, methodName){
            final /* synthetic */ BspRequestsRunner this$0;
            final /* synthetic */ String $methodName;
            {
                this.this$0 = $receiver;
                this.$methodName = $methodName;
                super(1);
            }

            public final CompletionStage<T> invoke(Either<Throwable, T> it) {
                CompletableFuture completableFuture;
                if (it.isLeft()) {
                    Object object = it.getLeft();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
                    completableFuture = BspRequestsRunner.access$failure(this.this$0, this.$methodName, (Throwable)object);
                } else {
                    completableFuture = BspRequestsRunner.access$success(this.this$0, this.$methodName, it.getRight());
                }
                return completableFuture;
            }
        };
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)CancellableFuture.from(asyncRequest2).thenApply(function)).exceptionally((Function)runAsync.2.INSTANCE)).thenCompose(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    private final <T> CompletableFuture<T> success(String methodName, T response) {
        LOGGER.info("{} call finishing successfully", (Object)methodName);
        CompletableFuture<T> completableFuture = CompletableFuture.completedFuture(response);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private final <T> CompletableFuture<T> failure(String methodName, ResponseError error) {
        LOGGER.error("{} call finishing with error: {}", (Object)methodName, (Object)error);
        CompletableFuture completableFuture = CompletableFuture.failedFuture((Throwable)new ResponseErrorException(error));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
        return completableFuture;
    }

    private final <T> CompletableFuture<T> failure(String methodName, Throwable throwable) {
        LOGGER.error(methodName + " call finishing with error", throwable);
        if (throwable instanceof ResponseErrorException) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(throwable);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String message = StringsKt.trimIndent((String)("\n      " + throwable.getMessage() + "\n      " + sw + "\n      "));
        CompletableFuture completableFuture = CompletableFuture.failedFuture((Throwable)new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, message, null)));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
        return completableFuture;
    }

    public static final /* synthetic */ CompletableFuture access$failure(BspRequestsRunner $this, String methodName, Throwable throwable) {
        return $this.failure(methodName, throwable);
    }

    public static final /* synthetic */ CompletableFuture access$success(BspRequestsRunner $this, String methodName, Object response) {
        return $this.success(methodName, response);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/BspRequestsRunner$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/Logger;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp-bsp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

