/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bsp.managers;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.velocity.app.VelocityEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bazel.label.Label;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelBspLanguageExtensionsGenerator;
import org.jetbrains.bsp.bazel.server.bsp.managers.Language;
import org.jetbrains.bsp.bazel.server.bsp.managers.RulesetLanguage;
import org.jetbrains.bsp.bazel.server.bsp.utils.FileUtils;
import org.jetbrains.bsp.bazel.server.bsp.utils.InternalAspectsResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014J,\u0010\u0016\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002J\u0016\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011H\u0002J\u0016\u0010\u001b\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011H\u0002J,\u0010\u001c\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelBspLanguageExtensionsGenerator;", "", "internalAspectsResolver", "Lorg/jetbrains/bsp/bazel/server/bsp/utils/InternalAspectsResolver;", "<init>", "(Lorg/jetbrains/bsp/bazel/server/bsp/utils/InternalAspectsResolver;)V", "aspectsPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Ljava/nio/file/Path;", "velocityEngine", "Lorg/apache/velocity/app/VelocityEngine;", "calculateProperties", "Ljava/util/Properties;", "generateLanguageExtensions", "", "rulesetLanguages", "", "Lorg/jetbrains/bsp/bazel/server/bsp/managers/RulesetLanguage;", "toolchains", "", "Lorg/jetbrains/bazel/label/Label;", "prepareFileContent", "", "createLoadStatementsString", "languages", "Lorg/jetbrains/bsp/bazel/server/bsp/managers/Language;", "createExtensionListString", "createToolchainListString", "createNewExtensionsFile", "fileContent", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp_managers-managers"})
@SourceDebugExtension(value={"SMAP\nBazelBspLanguageExtensionsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelBspLanguageExtensionsGenerator.kt\norg/jetbrains/bsp/bazel/server/bsp/managers/BazelBspLanguageExtensionsGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1557#2:106\n1628#2,3:107\n1557#2:110\n1628#2,3:111\n1557#2:114\n1628#2,3:115\n1368#2:118\n1454#2,5:119\n1611#2,9:124\n1863#2:133\n1864#2:135\n1620#2:136\n1#3:134\n*S KotlinDebug\n*F\n+ 1 BazelBspLanguageExtensionsGenerator.kt\norg/jetbrains/bsp/bazel/server/bsp/managers/BazelBspLanguageExtensionsGenerator\n*L\n77#1:106\n77#1:107,3\n78#1:110\n78#1:111,3\n86#1:114\n86#1:115,3\n91#1:118\n91#1:119,5\n97#1:124,9\n97#1:133\n97#1:135\n97#1:136\n97#1:134\n*E\n"})
public final class BazelBspLanguageExtensionsGenerator {
    private final Path aspectsPath;
    @NotNull
    private final VelocityEngine velocityEngine;

    public BazelBspLanguageExtensionsGenerator(@NotNull InternalAspectsResolver internalAspectsResolver) {
        Intrinsics.checkNotNullParameter((Object)internalAspectsResolver, (String)"internalAspectsResolver");
        String[] stringArray = new String[]{"aspects"};
        this.aspectsPath = Paths.get(internalAspectsResolver.getBazelBspRoot(), stringArray);
        this.velocityEngine = new VelocityEngine();
        Properties props = this.calculateProperties();
        this.velocityEngine.init(props);
    }

    private final Properties calculateProperties() {
        Properties props = new Properties();
        ((Map)props).put("resource.loader.file.path", ((Object)this.aspectsPath.toAbsolutePath()).toString());
        props.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
        return props;
    }

    public final void generateLanguageExtensions(@NotNull List<RulesetLanguage> rulesetLanguages, @NotNull Map<RulesetLanguage, ? extends Label> toolchains2) {
        Intrinsics.checkNotNullParameter(rulesetLanguages, (String)"rulesetLanguages");
        Intrinsics.checkNotNullParameter(toolchains2, (String)"toolchains");
        String fileContent = this.prepareFileContent(rulesetLanguages, toolchains2);
        this.createNewExtensionsFile(fileContent);
    }

    private final String prepareFileContent(List<RulesetLanguage> rulesetLanguages, Map<RulesetLanguage, ? extends Label> toolchains2) {
        RulesetLanguage it;
        Collection<Language> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object[] objectArray = new String[4];
        objectArray[0] = "# This is a generated file, do not edit it";
        Iterable iterable = rulesetLanguages;
        BazelBspLanguageExtensionsGenerator bazelBspLanguageExtensionsGenerator = this;
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RulesetLanguage rulesetLanguage = (RulesetLanguage)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLanguage());
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = bazelBspLanguageExtensionsGenerator.createLoadStatementsString((List<? extends Language>)collection);
        $this$map$iv = rulesetLanguages;
        bazelBspLanguageExtensionsGenerator = this;
        n = 2;
        objectArray2 = objectArray;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RulesetLanguage)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLanguage());
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = bazelBspLanguageExtensionsGenerator.createExtensionListString((List<? extends Language>)collection);
        objectArray[3] = this.createToolchainListString(rulesetLanguages, toolchains2);
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String createLoadStatementsString(List<? extends Language> languages) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = languages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Language language = (Language)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toLoadStatement());
        }
        List loadStatements = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)loadStatements, (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String createExtensionListString(List<? extends Language> languages) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = languages;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            Iterable list$iv$iv = it.getFunctions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List functionNames = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)functionNames, (CharSequence)",\n ", (CharSequence)"EXTENSIONS = [\n", (CharSequence)"\n]", (int)0, null, (Function1)createExtensionListString.1.INSTANCE, (int)24, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String createToolchainListString(List<RulesetLanguage> rulesetLanguages, Map<RulesetLanguage, ? extends Label> toolchains2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = rulesetLanguages;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Label it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RulesetLanguage it = (RulesetLanguage)element$iv$iv;
            boolean bl2 = false;
            if (toolchains2.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",\n ", (CharSequence)"TOOLCHAINS = [\n", (CharSequence)"\n]", (int)0, null, (Function1)createToolchainListString.2.INSTANCE, (int)24, null);
    }

    private final void createNewExtensionsFile(String fileContent) {
        Path file = this.aspectsPath.resolve("extensions.bzl");
        Intrinsics.checkNotNull((Object)file);
        FileUtils.INSTANCE.writeIfDifferent(file, fileContent);
    }
}

