/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bsp.bazel.server.bsp.managers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bsp.bazel.bazelrunner.BazelCommand;
import org.jetbrains.bsp.bazel.bazelrunner.BazelProcessResult;
import org.jetbrains.bsp.bazel.bazelrunner.BazelRunner;
import org.jetbrains.bsp.bazel.logger.BspClientLogger;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelBzlModExternalRulesetsQueryImpl;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelExternalRulesetsQuery;
import org.jetbrains.bsp.bazel.server.bsp.managers.BazelExternalRulesetsQueryKt;
import org.jetbrains.bsp.bazel.server.bsp.managers.BzlmodGraph;
import org.jetbrains.bsp.bazel.server.bsp.managers.StructuredFilesUtilsKt;
import org.jetbrains.bsp.bazel.server.bzlmod.BzlmodRepoMapping;
import org.jetbrains.bsp.bazel.server.bzlmod.RepoMapping;
import org.jetbrains.bsp.bazel.server.bzlmod.RepoMappingKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelBzlModExternalRulesetsQueryImpl;", "Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelExternalRulesetsQuery;", "bazelRunner", "Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;", "isBzlModEnabled", "", "bspClientLogger", "Lorg/jetbrains/bsp/bazel/logger/BspClientLogger;", "repoMapping", "Lorg/jetbrains/bsp/bazel/server/bzlmod/RepoMapping;", "<init>", "(Lorg/jetbrains/bsp/bazel/bazelrunner/BazelRunner;ZLorg/jetbrains/bsp/bazel/logger/BspClientLogger;Lorg/jetbrains/bsp/bazel/server/bzlmod/RepoMapping;)V", "gson", "Lcom/google/gson/Gson;", "fetchExternalRulesetNames", "", "", "cancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "Companion", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp_managers-managers"})
@SourceDebugExtension(value={"SMAP\nBazelExternalRulesetsQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelExternalRulesetsQuery.kt\norg/jetbrains/bsp/bazel/server/bsp/managers/BazelBzlModExternalRulesetsQueryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,195:1\n1216#2,2:196\n1246#2,4:198\n1755#2,3:212\n1557#2:219\n1628#2,3:220\n487#3,7:202\n535#3:209\n520#3,2:210\n522#3,4:215\n*S KotlinDebug\n*F\n+ 1 BazelExternalRulesetsQuery.kt\norg/jetbrains/bsp/bazel/server/bsp/managers/BazelBzlModExternalRulesetsQueryImpl\n*L\n133#1:196,2\n133#1:198,4\n154#1:212,3\n161#1:219\n161#1:220,3\n153#1:202,7\n154#1:209\n154#1:210,2\n154#1:215,4\n*E\n"})
public final class BazelBzlModExternalRulesetsQueryImpl
implements BazelExternalRulesetsQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BazelRunner bazelRunner;
    private final boolean isBzlModEnabled;
    @NotNull
    private final BspClientLogger bspClientLogger;
    @NotNull
    private final RepoMapping repoMapping;
    @NotNull
    private final Gson gson;
    private static final Logger log = LogManager.getLogger(BazelBzlModExternalRulesetsQueryImpl.class);

    public BazelBzlModExternalRulesetsQueryImpl(@NotNull BazelRunner bazelRunner, boolean isBzlModEnabled, @NotNull BspClientLogger bspClientLogger, @NotNull RepoMapping repoMapping2) {
        Intrinsics.checkNotNullParameter((Object)bazelRunner, (String)"bazelRunner");
        Intrinsics.checkNotNullParameter((Object)bspClientLogger, (String)"bspClientLogger");
        Intrinsics.checkNotNullParameter((Object)repoMapping2, (String)"repoMapping");
        this.bazelRunner = bazelRunner;
        this.isBzlModEnabled = isBzlModEnabled;
        this.bspClientLogger = bspClientLogger;
        this.repoMapping = repoMapping2;
        this.gson = new Gson();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> fetchExternalRulesetNames(@NotNull CancelChecker cancelChecker) {
        JsonElement jsonElement;
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        if (!this.isBzlModEnabled) {
            return CollectionsKt.emptyList();
        }
        BazelCommand command2 = BazelRunner.buildBazelCommand$default(this.bazelRunner, null, fetchExternalRulesetNames.command.1.INSTANCE, 1, null);
        RepoMapping repoMapping2 = this.repoMapping;
        Object object2 = repoMapping2 instanceof BzlmodRepoMapping ? (BzlmodRepoMapping)repoMapping2 : null;
        if (object2 == null || (object2 = ((BzlmodRepoMapping)object2).getApparentRepoNameToCanonicalName()) == null) {
            object2 = MapsKt.emptyMap();
        }
        Object apparentRepoNameToCanonicalName = object2;
        Iterable $this$associateBy$iv = apparentRepoNameToCanonicalName.entrySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            String string = (String)entry.getValue();
            boolean bl2 = false;
            String string2 = (String)entry2.getKey();
            object.put(string, string2);
        }
        Map canonicalNameToApparentRepoName = destination$iv$iv;
        BazelProcessResult result2 = BazelRunner.runBazelCommand$default(this.bazelRunner, command2, null, false, null, false, 18, null).waitAndGetResult(cancelChecker, true);
        boolean bl32 = false;
        if (result2.isNotSuccess()) {
            String queryFailedMessage = BazelExternalRulesetsQueryKt.access$getQueryFailedMessage(result2);
            this.bspClientLogger.warn(queryFailedMessage);
            log.warn(queryFailedMessage);
            jsonElement = null;
        } else {
            jsonElement = StructuredFilesUtilsKt.toJson(result2.getStdout(), log);
        }
        JsonObject bzlmodGraphJson = ($i$f$associateBy = jsonElement) instanceof JsonObject ? (JsonObject)$i$f$associateBy : null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Map $this$filterKeys$iv;
            BzlmodGraph graph2 = (BzlmodGraph)this.gson.fromJson((JsonElement)bzlmodGraphJson, BzlmodGraph.class);
            List<String> directDeps = graph2.getAllDirectRulesetDependencies();
            Map<String, List<String>> bl32 = RepoMappingKt.getRootRulesToNeededTransitiveRules();
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry.getKey();
                boolean bl4 = false;
                if (!directDeps.contains(it)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$filter232 = false;
            result$iv = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean bl = false;
            Iterator it = $this$filterTo$iv$iv.entrySet().iterator();
            while (it.hasNext()) {
                boolean bl2;
                Map.Entry element$iv$iv;
                block14: {
                    Map.Entry it2 = element$iv$iv = it.next();
                    boolean bl6 = false;
                    Iterable $this$any$iv = (Iterable)it2.getValue();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String transitiveDep = (String)element$iv;
                            boolean bl7 = false;
                            if (!graph2.isIncludedTransitively((String)it2.getKey(), transitiveDep)) continue;
                            bl2 = true;
                            break block14;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            List indirectDeps = CollectionsKt.flatten((Iterable)destination$iv$iv2.values());
            Iterable $i$f$filter232 = CollectionsKt.plus((Collection)directDeps, (Iterable)indirectDeps);
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                String bl6 = (String)item$iv$iv;
                object = collection;
                boolean bl8 = false;
                String string = BazelBzlModExternalRulesetsQueryImpl.fetchExternalRulesetNames$toApparentName(canonicalNameToApparentRepoName, (String)it3 + "~");
                if (string == null && (string = BazelBzlModExternalRulesetsQueryImpl.fetchExternalRulesetNames$toApparentName(canonicalNameToApparentRepoName, (String)it3 + "+")) == null) {
                    string = it3;
                }
                object.add(string);
            }
            List deps = CollectionsKt.distinct((Iterable)((List)collection));
            return deps;
        }
        catch (Throwable e) {
            log.warn("The returned bzlmod json is not parsable:\n" + bzlmodGraphJson, e);
            return CollectionsKt.emptyList();
        }
    }

    private static final String fetchExternalRulesetNames$toApparentName(Map<String, String> canonicalNameToApparentRepoName, String canonicalName) {
        return canonicalNameToApparentRepoName.get(canonicalName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/bsp/bazel/server/bsp/managers/BazelBzlModExternalRulesetsQueryImpl$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/apache/logging/log4j/Logger;", "server_server_src_main_kotlin_org_jetbrains_bsp_bazel_server_bsp_managers-managers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

